/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.active.dao.impl;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.active.dao.iface.ActivityGiftRecordDao;
import com.xunlei.niux.data.active.vo.commonactivity.ActivityGiftRecord;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowCallbackHandler;

public class ActivityGiftRecordDaoImpl
extends BaseDaoImpl
implements ActivityGiftRecordDao {
    @Override
    public List<ActivityGiftRecord> getGiftRecords(String actNo, String moduleId, int max) {
        final ArrayList<ActivityGiftRecord> giftRecordList = new ArrayList<ActivityGiftRecord>();
        if (StringUtils.isEmpty(actNo)) {
            return giftRecordList;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select actNo,moduleId,giftId,userId,ip,isSuccess,isNeedReissue,recordTime,issueBy,issueTime\n");
        sb.append("from activityGiftRecord\n");
        sb.append("where 1 = 1\n");
        sb.append(" and actNo=? \n");
        if (StringUtils.isNotEmpty(moduleId)) {
            sb.append("  and moduleId=? \n");
        }
        sb.append(" order by recordTime desc\n");
        if (max > 0) {
            sb.append(" limit ?");
        }
        Object[] args = null;
        args = StringUtils.isNotEmpty(moduleId) ? new Object[]{actNo, moduleId, max} : new Object[]{actNo, max};
        this.getJdbcTemplate().query(sb.toString(), args, new RowCallbackHandler(){

            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
                ActivityGiftRecord giftRecord = new ActivityGiftRecord();
                giftRecord.setActNo(resultSet.getString("actNo"));
                giftRecord.setModuleId(resultSet.getString("moduleId"));
                giftRecord.setGiftId(Integer.parseInt(resultSet.getString("giftId")));
                giftRecord.setUserId(resultSet.getLong("userId"));
                giftRecord.setIp(resultSet.getString("ip"));
                giftRecord.setIsSuccess(resultSet.getBoolean("isSuccess"));
                giftRecord.setIsNeedReissue(resultSet.getBoolean("isNeedReissue"));
                giftRecord.setRecordTime(resultSet.getString("recordTime"));
                giftRecord.setIssueBy(resultSet.getString("issueBy"));
                giftRecord.setIssueTime(resultSet.getString("issueTime"));
                giftRecordList.add(giftRecord);
            }
        });
        return giftRecordList;
    }

    @Override
    public List<String> getAllDistinctActNo() {
        String sql = " select distinct actNo from activityGiftRecord ";
        List actNoList = this.getJdbcTemplate().queryForList(sql, String.class);
        return actNoList;
    }
}

