/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.active.bo.impl;

import com.xunlei.niux.data.active.bo.iface.ActivityGiftRecordBo;
import com.xunlei.niux.data.active.dao.iface.ActivityGiftRecordDao;
import com.xunlei.niux.data.active.dto.commonactivity.ActivityGiftRecordDTO;
import com.xunlei.niux.data.active.vo.commonactivity.ActivityGiftRecord;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@Repository
public class ActivityGiftRecordBoImpl
implements ActivityGiftRecordBo {
    @Resource(name="activityGiftRecordDao")
    private ActivityGiftRecordDao activityGiftRecordDao;

    @Override
    public List<ActivityGiftRecordDTO> getGiftRecords(String actNo, int max) {
        return this.getGiftRecords(actNo, null, max);
    }

    @Override
    public List<ActivityGiftRecordDTO> getGiftRecords(String actNo, String moduleId, int max) {
        ArrayList<ActivityGiftRecordDTO> dtoList = new ArrayList<ActivityGiftRecordDTO>();
        if (StringUtils.isEmpty(actNo)) {
            return dtoList;
        }
        List<ActivityGiftRecord> giftRecordList = this.activityGiftRecordDao.getGiftRecords(actNo, moduleId, max);
        if (CollectionUtils.isEmpty(giftRecordList)) {
            return dtoList;
        }
        for (ActivityGiftRecord giftRecord : giftRecordList) {
            ActivityGiftRecordDTO dto = new ActivityGiftRecordDTO();
            BeanUtils.copyProperties(giftRecord, dto);
            dtoList.add(dto);
        }
        return dtoList;
    }

    @Override
    public List<String> getAllDistinctActNo() {
        return this.activityGiftRecordDao.getAllDistinctActNo();
    }
}

