/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.active.bo.impl;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.active.bo.iface.ActivityGiftBo;
import com.xunlei.niux.data.active.dao.iface.ActivityGiftInfoDao;
import com.xunlei.niux.data.active.dto.commonactivity.ActivityGiftInfoDTO;
import com.xunlei.niux.data.active.vo.commonactivity.ActivityGiftInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@Repository
public class ActivityGiftBoImpl
implements ActivityGiftBo {
    @Resource(name="activityGiftInfoDao")
    private ActivityGiftInfoDao activityGiftInfoDao;

    @Override
    public List<ActivityGiftInfoDTO> getActivityGiftList(ActivityGiftInfo query) {
        ArrayList<ActivityGiftInfoDTO> dtolist = new ArrayList<ActivityGiftInfoDTO>();
        if (query == null) {
            return dtolist;
        }
        Page page = new Page();
        page.addOrder("displayOrder", OrderType.DESC);
        List<ActivityGiftInfo> list = this.activityGiftInfoDao.findObjects(query, page);
        if (CollectionUtils.isEmpty(list)) {
            return dtolist;
        }
        for (ActivityGiftInfo giftInfo : list) {
            ActivityGiftInfoDTO dto = new ActivityGiftInfoDTO();
            BeanUtils.copyProperties(giftInfo, dto);
            dtolist.add(dto);
        }
        return dtolist;
    }

    @Override
    public ActivityGiftInfoDTO getActivityGift(ActivityGiftInfo query) {
        ActivityGiftInfoDTO dto = new ActivityGiftInfoDTO();
        if (query == null) {
            return null;
        }
        ActivityGiftInfo giftInfo = this.activityGiftInfoDao.findByObject(query);
        if (giftInfo == null) {
            return null;
        }
        BeanUtils.copyProperties(giftInfo, dto);
        return dto;
    }

    @Override
    public void updateActivityGift(ActivityGiftInfoDTO giftInfoDTO) {
        ActivityGiftInfo giftInfo = new ActivityGiftInfo();
        BeanUtils.copyProperties(giftInfoDTO, giftInfo);
        this.activityGiftInfoDao.updateObjectById(giftInfo);
    }

    @Override
    public List<ActivityGiftInfoDTO> getRankingJinZuanPackageTaked(String actNo, int limit) {
        ArrayList<ActivityGiftInfoDTO> giftInfoDTOList = new ArrayList<ActivityGiftInfoDTO>();
        List<ActivityGiftInfo> giftInfoList = this.activityGiftInfoDao.getRankingJinZuanPackageTaked(actNo, limit);
        if (CollectionUtils.isEmpty(giftInfoList)) {
            return giftInfoDTOList;
        }
        for (ActivityGiftInfo giftInfo : giftInfoList) {
            ActivityGiftInfoDTO giftInfoDTO = new ActivityGiftInfoDTO();
            BeanUtils.copyProperties(giftInfo, giftInfoDTO);
            giftInfoDTOList.add(giftInfoDTO);
        }
        return giftInfoDTOList;
    }

    @Override
    public void update_recharge(ActivityGiftInfo gift) {
        ActivityGiftInfo bp;
        StringBuilder sb = new StringBuilder();
        sb.append("select * from activityGiftInfo where seqid=?  for update");
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(gift.getSeqid());
        List<ActivityGiftInfo> bplist = this.activityGiftInfoDao.executeQuery(sb.toString(), list);
        ActivityGiftInfo activityGiftInfo = bp = bplist == null || bplist.size() == 0 ? null : bplist.get(0);
        if (bp == null) {
            throw new RuntimeException("\u5956\u54c1\u4e0d\u5b58\u5728");
        }
        bp.setTotalCount(bp.getTotalCount() + gift.getLeftCount());
        bp.setLeftCount(bp.getLeftCount() + gift.getLeftCount());
        if (bp.getLeftCount() < 0) {
            throw new RuntimeException("\u53ef\u7528\u5956\u54c1\u6570\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        bp.setEditBy(gift.getEditBy());
        bp.setEditTime(gift.getEditTime());
        this.activityGiftInfoDao.updateObjectById(bp);
    }

    @Override
    public List<ActivityGiftInfoDTO> getActivityGiftList(String actNo) {
        return this.getActivityGiftList(actNo, "");
    }

    @Override
    public List<ActivityGiftInfoDTO> getActivityGiftList(String actNo, String moduleId) {
        return this.getActivityGiftList(actNo, moduleId, 0);
    }

    @Override
    public List<ActivityGiftInfoDTO> getActivityGiftList(String actNo, String moduleId, int giftId) {
        return this.getActivityGiftList(actNo, moduleId, giftId, 0);
    }

    @Override
    public List<ActivityGiftInfoDTO> getActivityGiftList(String actNo, String moduleId, int giftId, int limit) {
        List<ActivityGiftInfo> list;
        ArrayList<ActivityGiftInfoDTO> dtolist = new ArrayList<ActivityGiftInfoDTO>();
        if (StringUtils.isEmpty(actNo)) {
            throw new RuntimeException("actNo can't be empty!");
        }
        ActivityGiftInfo query = new ActivityGiftInfo();
        query.setActNo(actNo);
        if (StringUtils.isNotEmpty(moduleId)) {
            query.setModuleId(moduleId);
        }
        if (giftId > 0) {
            query.setGiftId(giftId);
        }
        query.setIsValid(true);
        Page page = new Page();
        page.addOrder("displayOrder", OrderType.DESC);
        if (limit > 0) {
            page.setPageSize(limit);
        }
        if (CollectionUtils.isEmpty(list = this.activityGiftInfoDao.findObjects(query, page))) {
            return dtolist;
        }
        for (ActivityGiftInfo giftInfo : list) {
            ActivityGiftInfoDTO dto = new ActivityGiftInfoDTO();
            BeanUtils.copyProperties(giftInfo, dto);
            dtolist.add(dto);
        }
        return dtolist;
    }
}

