/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.active.bo.impl;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.data.active.bo.iface.ActivityExtendBo;
import com.xunlei.niux.data.active.bo.iface.BaseSo;
import com.xunlei.niux.data.active.dto.commonactivity.ActivityExtendInfoDTO;
import com.xunlei.niux.data.active.vo.commonactivity.ActivityExtendInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ActivityExtendBoImpl
implements ActivityExtendBo {
    private static final int timeOut = 10;
    @Autowired
    private BaseSo baseSo;

    @Override
    public ActivityExtendInfoDTO getActivityInfo(String actNo, String moduleId) {
        if (StringUtils.isEmpty(actNo)) {
            return null;
        }
        ActivityExtendInfoDTO dto = null;
        String cacheKey = this.getClass().getName() + "getActivityInfo" + "actNo_moduleId" + actNo + moduleId;
        CacheManager cacheManager = CacheManager.GetInstance();
        Object object = cacheManager.get(cacheKey);
        if (object == null) {
            ActivityExtendInfo activityInfo;
            ActivityExtendInfo query = new ActivityExtendInfo();
            query.setActNo(actNo);
            if (StringUtils.isNotEmpty(moduleId)) {
                query.setModuleId(moduleId);
            }
            if ((activityInfo = this.baseSo.findObject(query)) == null) {
                return null;
            }
            dto = new ActivityExtendInfoDTO();
            BeanUtils.copyProperties(activityInfo, dto);
            cacheManager.put(cacheKey, dto, 10L);
        } else {
            dto = (ActivityExtendInfoDTO)object;
        }
        return dto;
    }

    @Override
    public List<ActivityExtendInfoDTO> getActivityInfoList(String actNo) {
        if (StringUtils.isEmpty(actNo)) {
            return null;
        }
        ArrayList<ActivityExtendInfoDTO> activityExtendInfoDTOs = null;
        String cacheKey = this.getClass().getName() + "getActivityInfoList" + "actNo" + actNo;
        CacheManager cacheManager = CacheManager.GetInstance();
        Object object = cacheManager.get(cacheKey);
        if (object == null) {
            ActivityExtendInfo query = new ActivityExtendInfo();
            query.setActNo(actNo);
            List<ActivityExtendInfo> activityInfoList = this.baseSo.findObjects(query, new Page());
            if (CollectionUtils.isEmpty(activityInfoList)) {
                return null;
            }
            activityExtendInfoDTOs = new ArrayList<ActivityExtendInfoDTO>();
            ActivityExtendInfoDTO dto = null;
            for (ActivityExtendInfo activityInfo : activityInfoList) {
                dto = new ActivityExtendInfoDTO();
                BeanUtils.copyProperties(activityInfo, dto);
                activityExtendInfoDTOs.add(dto);
            }
            cacheManager.put(cacheKey, activityExtendInfoDTOs, 10L);
        } else {
            activityExtendInfoDTOs = (ArrayList<ActivityExtendInfoDTO>)object;
        }
        return activityExtendInfoDTOs;
    }
}

