/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.client.jinzuan;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.niux.client.jinzuan.dto.PrivilegeDTO;
import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.niux.client.util.MapEasyUtils;
import com.xunlei.niux.data.jinzuan.enums.PrivilegeType;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PrivilegeClient {
    private static final Logger logger = Logger.getLogger(PrivilegeClient.class);
    private static final String PrivilegeUrl = "http://jinzuan.niu.xunlei.com:9090/privilege/";
    private static final String priKey = EnvPropertyUtil.loadProperty("niuxclient", "PrivilegeClient_priKey");

    public static Map<String, Object> haveUnusedPrivilege(String userId, PrivilegeType pritype) {
        String url = "http://jinzuan.niu.xunlei.com:9090/privilege/receive.do?";
        url = url + "uid=" + userId;
        url = url + "&ptype=" + pritype.getValue();
        logger.info("haveUnusedPrivilege request URL: " + url);
        String resp = HttpClientUtil.get(url);
        logger.info("haveUnusedPrivilege request response: " + resp);
        Gson gson = new Gson();
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Map myMap = (Map)gson.fromJson(resp, type);
        return myMap;
    }

    public static String usePrivilege(String userId, PrivilegeType pritype, int useCount) {
        String url = "http://jinzuan.niu.xunlei.com:9090/privilege/use.do?";
        String timestamp = String.valueOf(new Date().getTime());
        url = url + "uid=" + userId;
        url = url + "&ptype=" + pritype.getValue();
        url = url + "&timestamp=" + timestamp;
        url = url + "&usedValue=" + useCount;
        String sign = Md5Encrypt.md5(userId + pritype.getValue() + useCount + timestamp + priKey);
        url = url + "&sign=" + sign;
        logger.info("usePrivilege request URL: " + url);
        String resp = HttpClientUtil.get(url);
        logger.info("usePrivilege request response: " + resp);
        return resp;
    }

    public static Map<String, Object> signInGetBonusNum(String userId) {
        String url = "http://jinzuan.niu.xunlei.com:9090/privilege/getBonus.do?";
        url = url + "uid=" + userId;
        logger.info("signInGetBonusNum request URL: " + url);
        String resp = HttpClientUtil.get(url);
        logger.info("signInGetBonusNum request response: " + resp);
        JsonObject jsonObject = new JsonParser().parse(resp).getAsJsonObject();
        int rtnCode = jsonObject.get("rtn").getAsInt();
        if (rtnCode == 0) {
            JsonObject dataObj = jsonObject.getAsJsonObject("data");
            int bonusNum = dataObj.get("value").getAsInt();
            return MapEasyUtils.generateMap(0, bonusNum);
        }
        return MapEasyUtils.generateMap(-1, resp);
    }

    public static String getAllPrivilegeInfo() {
        HashMap resultMap = new HashMap();
        String url = "http://jinzuan.niu.xunlei.com:9090/privilege/privilegeinfo.do";
        logger.info("getAllPrivilegeInfo request URL: " + url);
        String resp = HttpClientUtil.get(url);
        logger.info("getAllPrivilegeInfo request response: " + resp);
        return resp;
    }

    public static Map<String, Object> getPrivilegeLevelInfo(PrivilegeType privilegeType) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String url = "http://jinzuan.niu.xunlei.com:9090/privilege/getPrivilege.do?";
        url = url + "ptype=" + privilegeType.getValue();
        logger.info("getPrivilegeLevelInfo request URL: " + url);
        String resp = HttpClientUtil.get(url);
        logger.info("getPrivilegeLevelInfo request response: " + resp);
        JsonObject jsonObject = new JsonParser().parse(resp).getAsJsonObject();
        int rtnCode = jsonObject.get("rtn").getAsInt();
        if (rtnCode == 0) {
            Gson gson = new Gson();
            Type type = new TypeToken<List<PrivilegeDTO>>(){}.getType();
            List priInfoList = (List)gson.fromJson(jsonObject.get("data"), type);
            resultMap.put("code", rtnCode);
            resultMap.put("data", priInfoList);
        } else {
            resultMap.put("code", rtnCode);
            resultMap.put("data", jsonObject.get("data"));
        }
        return resultMap;
    }
}

