/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.util;

import com.xunlei.common.util.XLRuntimeException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.UUID;

public class Utility {
    private static int se = 0;
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat timeFormat2 = new SimpleDateFormat("yyyyMMddHHmmss");

    public static String createSerial(String src, int len) {
        String dest = "";
        dest = src.length() >= len ? src.substring(0, len) : Utility.createSameChar("0", len - src.length()) + src;
        return dest;
    }

    public static String createSameChar(String src, int len) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            sb.append(src);
        }
        return sb.toString();
    }

    public static String getLeftFixedLengthString(String src, String c, int len) {
        if (src.length() >= len) {
            return src.substring(0, len);
        }
        StringBuffer ext = new StringBuffer();
        for (int i = src.length(); i < len; ++i) {
            ext.append(c);
        }
        return ext.toString() + src;
    }

    public static int createRandomNum(int max) {
        Random random = new Random();
        return Math.abs(random.nextInt()) % max;
    }

    public static String moveChar(String pwd, int s, int e) {
        if (s > e) {
            int p = e;
            e = s;
            s = p;
        }
        if (s == e || s > 19) {
            return pwd;
        }
        String befor = pwd.substring(0, s);
        String s1 = pwd.substring(s, s + 1);
        String middle = pwd.substring(s + 1, e);
        String s2 = pwd.substring(e, e + 1);
        String after = pwd.substring(e + 1);
        return befor + s2 + middle + s1 + after;
    }

    public static String dateofnow() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(new Date());
    }

    public static String otherdateofnow() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return sdf.format(new Date());
    }

    public static String timeofnow() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar curcal = Calendar.getInstance();
        return sdf.format(curcal.getTime());
    }

    public static String addTime(String time1, String addpart, int num) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String now = sdf.format(new Date());
            String string = time1 = time1 == null ? now : time1;
            if (time1.length() < 19) {
                time1 = time1 + " 00:00:00";
            }
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(sdf.parse(time1));
            if (addpart.equalsIgnoreCase("Y")) {
                cal.add(1, num);
            } else if (addpart.equalsIgnoreCase("M")) {
                cal.add(2, num);
            } else if (addpart.equalsIgnoreCase("D")) {
                cal.add(5, num);
            } else if (addpart.equalsIgnoreCase("H")) {
                cal.add(10, num);
            } else if (addpart.equalsIgnoreCase("F")) {
                cal.add(12, num);
            } else if (addpart.equalsIgnoreCase("S")) {
                cal.add(13, num);
            }
            return sdf.format(cal.getTime());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String addDate(String date1, String addpart, int num) {
        return Utility.addTime(date1, addpart, num).substring(0, 10);
    }

    public static String ConvertCN2(String is) {
        if (is == null || is.compareTo("") == 0) {
            return "";
        }
        int l = is.length();
        for (int q = 0; q < l; ++q) {
            char t = is.charAt(q);
            if (t <= '\u00ff') continue;
            return is;
        }
        try {
            String os = new String(is.getBytes("ISO-8859-1"), "GBK");
            return os;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getTradeSn() {
        return "" + new Date().getTime();
    }

    public static String getTimeByTradeSn(long sn) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date(sn));
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static String getFixedLengthString(String src, String c, int len) {
        if (src.length() >= len) {
            return src.substring(0, len);
        }
        StringBuffer ext = new StringBuffer();
        for (int i = src.length(); i < len; ++i) {
            ext.append(c);
        }
        return src + ext.toString();
    }

    public static String getXunleiIdHash(String xunleiid, int flag) throws Exception {
        String src = null;
        String rtn = null;
        String xunleiid2 = xunleiid.toLowerCase();
        int sum = 0;
        int mod = 0;
        if (flag == 0) {
            src = xunleiid2.substring(0, 2);
        } else if (flag == 1) {
            src = xunleiid2.substring(2, 4);
        } else {
            throw new Exception("getXunleiIdHash error");
        }
        byte[] bytesrc = src.getBytes();
        for (int i = 0; i < bytesrc.length; ++i) {
            sum += bytesrc[i];
        }
        mod = sum % 100;
        rtn = mod < 10 ? "0" + mod : "" + mod;
        return rtn;
    }

    public static void callshell(String path) throws Exception {
        long time = System.currentTimeMillis();
        try {
            String line;
            Process process = Runtime.getRuntime().exec(path);
            InputStreamReader ir = new InputStreamReader(process.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            while ((line = input.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException e) {
            System.err.println("IOException " + e.getMessage());
            throw new Exception(e);
        }
        System.out.println("callshell:" + path + " and" + (System.currentTimeMillis() - time) / 1000L + "second");
    }

    public static DecimalFormat getNumberFormat() {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance();
        df.setMinimumFractionDigits(2);
        df.setMaximumFractionDigits(2);
        df.setDecimalSeparatorAlwaysShown(true);
        String s = "###,##0.00";
        df.applyPattern(s);
        return df;
    }

    public static synchronized String createApplyId() {
        String nextFrozeId = "";
        if (se > 99) {
            se = 0;
        }
        nextFrozeId = Utility.otherdateofnow().substring(2, 8) + Utility.getTradeSn().substring(3, 13) + Utility.createSerial("" + se, 2);
        ++se;
        if (nextFrozeId.length() != 18) {
            throw new XLRuntimeException("\u7533\u8bf7\u53f7\u957f\u5ea6\u9519\u8bef[" + nextFrozeId + "]");
        }
        return nextFrozeId;
    }

    public static byte[] getTheBytes(byte b, int len) {
        byte[] s = new byte[len];
        for (int i = 0; i < len; ++i) {
            s[i] = b;
        }
        return s;
    }

    public static byte[] getGiveLengthBytes(int type, byte[] src, int len) {
        byte[] rtn = new byte[len];
        if (src.length > len) {
            System.arraycopy(src, 0, rtn, 0, len);
            return rtn;
        }
        if (type == 0) {
            byte[] s = Utility.getTheBytes((byte)32, len - src.length);
            rtn = Utility.addByteArray(src, s);
        } else {
            byte[] s = Utility.getTheBytes((byte)48, len - src.length);
            rtn = Utility.addByteArray(s, src);
        }
        return rtn;
    }

    public static byte[] addByteArray(byte[] s1, byte[] s2) {
        byte[] rtn = new byte[s1.length + s2.length];
        System.arraycopy(s1, 0, rtn, 0, s1.length);
        System.arraycopy(s2, 0, rtn, s1.length, s2.length);
        return rtn;
    }

    public static String getGBKGiveLengthBytes(String srcstr, int len) throws Exception {
        byte[] src = srcstr.getBytes("GBK");
        byte[] rtn = new byte[len];
        String result = null;
        if (src.length <= len) {
            result = srcstr;
            return result;
        }
        int lastbyte = 0;
        int lastbyteindex = 0;
        int i = 0;
        while (i < len) {
            if (src[i] < 256 && src[i] > 0) {
                lastbyte = src[i];
                lastbyteindex = i++;
                continue;
            }
            lastbyte = src[i];
            lastbyteindex = i;
            i += 2;
        }
        if (lastbyte < 256 && lastbyte > 0) {
            rtn = Utility.getGiveLengthBytes(0, src, len);
        } else if ((lastbyte > 256 || lastbyte < 0) && lastbyteindex == len - 2) {
            rtn = Utility.getGiveLengthBytes(0, src, len);
        } else if ((lastbyte > 256 || lastbyte < 0) && lastbyteindex == len - 1) {
            byte[] tempremarkBytes = new byte[len - 1];
            System.arraycopy(src, 0, tempremarkBytes, 0, len - 1);
            rtn = Utility.getGiveLengthBytes(0, tempremarkBytes, len);
        }
        result = new String(rtn, "GBK");
        return result;
    }

    public static void main(String[] args) {
        try {
            for (int i = 0; i < 200; ++i) {
                System.out.println("" + Utility.createApplyId());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static double percentToDouble(String percent) {
        NumberFormat nf = NumberFormat.getPercentInstance();
        double number = 0.0;
        try {
            number = nf.parse(percent).doubleValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return number;
    }

    public static String formatToDateTime(String time) {
        try {
            Date date = timeFormat2.parse(time);
            time = timeFormat.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return time;
    }

    public static String formatToyyyyMMddHHmmss(String time) {
        try {
            Date date = timeFormat.parse(time);
            time = timeFormat2.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return time;
    }

    public static boolean after(String dateTimeFirst, String dateTimeSecond) {
        boolean flag = false;
        try {
            Date dateOne = timeFormat.parse(dateTimeFirst);
            Date dateTwo = timeFormat.parse(dateTimeSecond);
            flag = dateOne.after(dateTwo);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean before(String dateTimeFirst, String dateTimeSecond) {
        boolean flag = false;
        try {
            Date dateOne = timeFormat.parse(dateTimeFirst);
            Date dateTwo = timeFormat.parse(dateTimeSecond);
            System.out.println(dateOne + "  " + dateTwo);
            flag = dateOne.before(dateTwo);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return flag;
    }
}

