/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class UserInfoDecoder {
    public static Map<String, String> decode(BufferedInputStream bin) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        try {
            byte[] intBytes = new byte[4];
            while (bin.read(intBytes) != -1) {
                int size = UserInfoDecoder.byte2int(intBytes);
                if (size > 2048) {
                    return fieldMap;
                }
                ByteBuffer recordBuffer = ByteBuffer.allocate(size - 4);
                byte[] recordbyte = new byte[size - 4];
                bin.read(recordbyte);
                recordBuffer.put(recordbyte);
                recordBuffer.flip();
                while (recordBuffer.remaining() > 0) {
                    recordBuffer.get(intBytes);
                    int rowSize = UserInfoDecoder.byte2int(intBytes);
                    ByteBuffer rowBuffer = ByteBuffer.allocate(rowSize);
                    byte[] rowByte = new byte[rowSize];
                    recordBuffer.get(rowByte);
                    rowBuffer.put(rowByte);
                    rowBuffer.flip();
                    while (rowBuffer.remaining() > 0) {
                        rowBuffer.get(intBytes);
                        int fileLength = UserInfoDecoder.byte2int(intBytes);
                        ByteBuffer filedBuffer = ByteBuffer.allocate(fileLength);
                        byte[] filebyte = new byte[fileLength];
                        rowBuffer.get(filebyte);
                        filedBuffer.put(filebyte);
                        filedBuffer.flip();
                        while (filedBuffer.remaining() > 0) {
                            filedBuffer.get(intBytes);
                            int keysize = UserInfoDecoder.byte2int(intBytes);
                            byte[] keyByte = new byte[keysize];
                            filedBuffer.get(keyByte);
                            String key = new String(keyByte, "gbk");
                            filedBuffer.get(intBytes);
                            int valuesize = UserInfoDecoder.byte2int(intBytes);
                            if (valuesize > 0) {
                                byte[] valuebyte = new byte[valuesize];
                                filedBuffer.get(valuebyte);
                                String value = new String(valuebyte, "gbk");
                                fieldMap.put(key, value);
                                continue;
                            }
                            fieldMap.put(key, "");
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fieldMap;
    }

    public static int byte2int(byte[] res) {
        int targets = res[3] & 0xFF | res[2] << 8 & 0xFF00 | res[1] << 24 >>> 8 | res[0] << 24;
        return targets;
    }
}

