/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class StringUtil {
    public static String getYearMonthWeek(Date date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = sdf.format(date);
        String[] dateArr = dateStr.split("-");
        int year = Integer.valueOf(dateArr[0]);
        int month = Integer.valueOf(dateArr[1]);
        int day = Integer.valueOf(dateArr[2]);
        Date monthFirstDate = sdf.parse(dateArr[0] + "-" + dateArr[1] + "-01");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(monthFirstDate);
        int monthFirstDateXiqiji = calendar.get(7);
        boolean thismonthweek = true;
        int notthismonthweekdays = 0;
        if (monthFirstDateXiqiji == 1) {
            thismonthweek = true;
            notthismonthweekdays = 0;
        } else if (day >= 8 - monthFirstDateXiqiji + 1) {
            thismonthweek = true;
            notthismonthweekdays = 8 - monthFirstDateXiqiji;
        } else {
            thismonthweek = false;
        }
        if (thismonthweek) {
            int tempday = day - notthismonthweekdays;
            int weeknum = tempday / 7;
            if (tempday % 7 > 0) {
                ++weeknum;
            }
            return year + "_" + month + "_" + weeknum;
        }
        int lastmonthyear = year;
        int lastmonth = month - 1;
        if (month == 1) {
            lastmonth = 12;
            lastmonthyear = year - 1;
        } else {
            lastmonth = month - 1;
        }
        String lastmonthStr = lastmonth < 10 ? "0" + lastmonth : "" + lastmonth;
        Date lastmonthfirstdate = sdf.parse(year + "-" + lastmonthStr + "-01");
        calendar.setTime(lastmonthfirstdate);
        int lastmonthfirstdatexiqiji = calendar.get(7);
        int lastmonthweekdays = calendar.getActualMaximum(5);
        if (lastmonthfirstdatexiqiji > 1) {
            lastmonthweekdays -= 8 - lastmonthfirstdatexiqiji;
        }
        int weeknum = lastmonthweekdays / 7;
        if (lastmonthweekdays % 7 > 0) {
            ++weeknum;
        }
        return lastmonthyear + "_" + lastmonth + "_" + weeknum;
    }

    public static boolean isEmpty(String ... strs) {
        if (strs == null || strs.length == 0) {
            return true;
        }
        for (String str : strs) {
            if (str != null && str.length() != 0) continue;
            return true;
        }
        return false;
    }

    public static List<String> getListFromString(String source, String separator) {
        if (StringUtils.isEmpty(source)) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = null;
        if (StringUtils.isBlank(separator)) {
            result = new ArrayList<String>();
            result.add(source);
            return result;
        }
        result = Arrays.asList(source.split(separator));
        return result;
    }
}

