/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.util;

import com.xunlei.niux.center.thirdclient.qcoins.QcoinsOrder;
import com.xunlei.util.Log;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;

public class QcoinsPayUtil {
    private static Logger logger = Log.getLogger(QcoinsPayUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QcoinsOrder parseXml(String xml) {
        if (StringUtils.isEmpty(xml)) {
            logger.error("[parseXml]load xml return null");
            return null;
        }
        QcoinsOrder info = null;
        Document doc = null;
        InputStream myIn = null;
        try {
            SAXReader saxReader = new SAXReader();
            myIn = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            doc = saxReader.read(myIn);
        }
        catch (Exception e) {
            logger.error("[parseXml]load xml exception,xml:" + xml, e);
            QcoinsOrder qcoinsOrder = info;
            return qcoinsOrder;
        }
        finally {
            if (myIn != null) {
                try {
                    myIn.close();
                }
                catch (IOException e) {
                    logger.error("[parseXml]load xml exception,xml:" + xml, e);
                }
            }
        }
        Element root = doc.getRootElement();
        info = new QcoinsOrder();
        Element ele = root.element("order-id");
        if (ele != null) {
            info.setOrderId(ele.getTextTrim());
        }
        if ((ele = root.element("merchant-order-id")) != null) {
            info.setMerchantOrderID(ele.getTextTrim());
        }
        if ((ele = root.element("state")) != null) {
            info.setStatus(ele.getTextTrim());
        }
        if ((ele = root.element("state-info")) != null) {
            info.setStatusInfo(ele.getTextTrim());
        }
        if ((ele = root.element("total-price")) != null) {
            info.setTotalPrice(ele.getTextTrim());
        }
        logger.info("[parseXml]load xml exception,xml:" + xml + ",info:" + info);
        return info;
    }
}

