/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.xunlei.util.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class QRCodeUtil {
    public static BitMatrix getImageBitMatrix(String content) throws WriterException, UnsupportedEncodingException {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.L);
        hints.put(EncodeHintType.MARGIN, 0);
        return new QRCodeWriter().encode(new String(content.getBytes("UTF-8"), "ISO-8859-1"), BarcodeFormat.QR_CODE, 300, 300, hints);
    }

    public static ChannelBuffer getImageBytes(String content, String format) throws WriterException, IOException {
        BitMatrix byteMatrix = QRCodeUtil.getImageBitMatrix(content);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream(byteMatrix, format, baos);
        return ChannelBuffers.wrappedBuffer(baos.toByteArray());
    }

    public static void genImageFile(String content, String filePathName) throws WriterException, IOException {
        BitMatrix byteMatrix = QRCodeUtil.getImageBitMatrix(content);
        File file = new File(filePathName);
        String format = FileUtil.getExtension(filePathName);
        MatrixToImageWriter.writeToFile(byteMatrix, format, file);
    }

    public static void genCsvFile(String content, String filePathName) throws WriterException, IOException {
        File file = new File(filePathName);
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(content.getBytes("UTF-8"));
        fos.close();
    }
}

