/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReportUtil {
    private static Logger logger = LoggerFactory.getLogger(LogReportUtil.class.getName());
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void report(LogReport report) {
        if (report == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sdf.format(report.logTime)).append("\t").append(LogReportUtil.urlencode(report.gameId)).append("\t").append(LogReportUtil.urlencode(report.serverId)).append("\t").append(LogReportUtil.urlencode(report.actId)).append("\t").append(LogReportUtil.urlencode(report.logSrc)).append("\t").append(LogReportUtil.urlencode(report.userId)).append("\t").append(LogReportUtil.urlencode(report.operatorId)).append("\t").append(LogReportUtil.urlencode(report.subOperatorId)).append("\t").append(LogReportUtil.urlencode(report.productId)).append("\t").append(LogReportUtil.urlencode(report.bonusNum)).append("\t").append(LogReportUtil.urlencode(report.num1)).append("\t").append(LogReportUtil.urlencode(report.num2)).append("\t").append(LogReportUtil.urlencode(report.str1)).append("\t").append(LogReportUtil.urlencode(report.str2));
        logger.info(sb.toString());
    }

    public static String urlencode(String value) {
        if (value == null) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String urlencode(Integer value) {
        if (value == null) {
            return "";
        }
        return String.valueOf(value);
    }

    public static class LogReport {
        public Date logTime;
        public String gameId;
        public String serverId;
        public String actId;
        public String logSrc;
        public String userId;
        public String operatorId;
        public String subOperatorId;
        public String productId;
        public Integer bonusNum;
        public Integer num1;
        public Integer num2;
        public String str1;
        public String str2;
    }
}

