/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.util;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.commons.lang.StringUtils;

public class JndiCommonProvider {
    private static String fileName = "/dbjndi.properties";
    private static List<ComboPooledDataSource> dbList = new ArrayList<ComboPooledDataSource>();

    private JndiCommonProvider() {
    }

    public static void init() throws Exception {
        Properties prop = new Properties();
        String env = EnvPropertyUtil.getEnv();
        System.out.println("##################");
        System.out.println("ENV: " + env);
        System.out.println("##################");
        String filePath = StringUtils.isNotEmpty(env) ? "/" + env + fileName : fileName;
        InputStream is = Object.class.getResourceAsStream(filePath);
        prop.load(is);
        if (is != null) {
            is.close();
        }
        System.setProperty("java.naming.factory.initial", "com.xunlei.org.apache.naming.java.javaURLContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "com.xunlei.org.apache.naming");
        InitialContext context = new InitialContext();
        context.createSubcontext("java:comp").createSubcontext("env").createSubcontext("jdbc");
        int poolSize = Integer.parseInt(prop.getProperty("poolsize"));
        for (int i = 1; i <= poolSize; ++i) {
            ComboPooledDataSource source = new ComboPooledDataSource();
            source.setDriverClass("com.mysql.jdbc.Driver");
            source.setJdbcUrl(prop.getProperty("pool" + i + ".url"));
            source.setUser(prop.getProperty("pool" + i + ".user"));
            source.setPassword(prop.getProperty("pool" + i + ".password"));
            source.setIdleConnectionTestPeriod(30);
            source.setMaxPoolSize(JndiCommonProvider.getProperty(prop, "pool" + i + ".maxpoolsize", 100));
            source.setMinPoolSize(JndiCommonProvider.getProperty(prop, "pool" + i + ".minpoolsize", 5));
            source.setInitialPoolSize(JndiCommonProvider.getProperty(prop, "pool" + i + ".initialpoolsize", 5));
            source.setCheckoutTimeout(JndiCommonProvider.getProperty(prop, "pool" + i + ".checkouttimeout", 8000));
            source.setMaxIdleTime(JndiCommonProvider.getProperty(prop, "pool" + i + ".maxidletime", 300));
            source.setAcquireIncrement(JndiCommonProvider.getProperty(prop, "pool" + i + ".acquireincrement", 3));
            source.setNumHelperThreads(JndiCommonProvider.getProperty(prop, "pool" + i + ".numhelperthreads", 3));
            source.setMaxStatements(0);
            source.setAutomaticTestTable("c3p0_con_test");
            source.setTestConnectionOnCheckin(true);
            dbList.add(source);
            ((Context)context.lookup("java:comp/env/jdbc")).rebind(prop.getProperty("pool" + i + ".jndiName"), (Object)source);
            System.out.println("jndiName:" + prop.getProperty("pool" + i + ".jndiName"));
        }
    }

    public static int getProperty(Properties prop, String key, int defaultValue) {
        if (prop.getProperty(key) == null) {
            return defaultValue;
        }
        int value = defaultValue;
        try {
            value = Integer.parseInt(prop.getProperty(key));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value > 0 ? value : defaultValue;
    }

    public static String getDbInfo() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (ComboPooledDataSource ds : dbList) {
            sb.append("\n====================\n").append(ds.getJdbcUrl());
            sb.append("\nNumConnections:").append(ds.getNumConnections());
            sb.append("\nNumBusyConnections").append(ds.getNumBusyConnections());
            sb.append("\nNumIdleConnections:").append(ds.getNumIdleConnections());
            sb.append("\nThreadPoolNumActiveThreads:").append(ds.getThreadPoolNumActiveThreads());
            sb.append("\nThreadPoolNumIdleThreads").append(ds.getThreadPoolNumIdleThreads());
            sb.append("\nThreadPoolNumTasksPending").append(ds.getThreadPoolNumTasksPending());
        }
        return sb.toString();
    }
}

