/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.log4j.Logger;

public class FileUtil {
    private static Logger logger = Logger.getLogger(FileUtil.class.getName());

    public static void write(File file, String context) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            ((OutputStream)out).write(context.getBytes());
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtil.close(out);
                throw throwable;
            }
        }
        FileUtil.close(out);
    }

    public static void write(String path, String context) {
        File file = new File(path);
        FileUtil.write(file, context);
    }

    public static void writeByChar(String dirPath, String fileName, String context) {
        File file = FileUtil.createFile(dirPath, fileName);
        FileUtil.writeByChar(file, context);
    }

    public static void writeByChar(File file, String content) {
        BufferedWriter bufw = null;
        try {
            bufw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            bufw.write(content);
            bufw.flush();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtil.close(bufw);
                throw throwable;
            }
        }
        FileUtil.close(bufw);
    }

    public static void writeByChar(String path, String content) {
        File file = new File(path);
        FileUtil.writeByChar(file, content);
    }

    public static File createFile(String dirPath, String fileName) {
        File dir = new File(dirPath = dirPath == null ? "" : dirPath.replaceAll("\\\\", "/"));
        if (!dir.exists() && !dir.isDirectory()) {
            dir.mkdirs();
        }
        String filepath = dirPath.endsWith("/") ? dirPath + fileName : dirPath + "/" + fileName;
        System.out.println(filepath);
        return new File(filepath);
    }

    public static String readByChar(File file) {
        String string;
        BufferedReader reader = null;
        try {
            StringBuilder sb = new StringBuilder();
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            char[] buf = new char[1024];
            int len = -1;
            while ((len = reader.read(buf)) != -1) {
                sb.append(buf, 0, len);
            }
            string = sb.toString();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtil.close(reader);
                throw throwable;
            }
        }
        FileUtil.close(reader);
        return string;
    }

    public static String readByChar(String filepath) {
        File file = new File(filepath);
        return FileUtil.readByChar(file);
    }

    public static void close(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {
            logger.error("\u5173\u95edinputstream\u51fa\u73b0\u5f02\u5e38");
        }
    }

    public static void close(BufferedWriter out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {
            logger.error("\u5173\u95edinputstream\u51fa\u73b0\u5f02\u5e38");
        }
    }

    public static void close(BufferedReader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception e) {
            logger.error("\u5173\u95edinputstream\u51fa\u73b0\u5f02\u5e38");
        }
    }
}

