/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.util;

import com.xunlei.netty.httpserver.Bootstrap;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class EmailSender {
    private JavaMailSender javaMailSender = (JavaMailSender)Bootstrap.CONTEXT.getBean("mailSender");
    private static EmailSender instance;

    private EmailSender() {
    }

    public static synchronized EmailSender getInstance() {
        if (instance == null) {
            instance = new EmailSender();
        }
        return instance;
    }

    public void sendMail(String[] toMail, String subject, String context) {
        SimpleMailMessage mail = new SimpleMailMessage();
        mail.setTo(toMail);
        mail.setSubject(subject);
        mail.setText(context);
        mail.setFrom("xlniux@xunlei.com");
    }

    public void sendHtmlEmail(String[] toMail, String subject, String context) {
        try {
            MimeMessage message = this.javaMailSender.createMimeMessage();
            MimeMessageHelper messageHelper = new MimeMessageHelper(message, true, "utf-8");
            messageHelper.setTo(toMail);
            messageHelper.setFrom("xlniux@xunlei.com");
            messageHelper.setSubject(subject);
            messageHelper.setText(context, true);
            this.javaMailSender.send(message);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }
}

