/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    private static SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
    private static final String DEFAULT_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public static Date yesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -1);
        return calendar.getTime();
    }

    public static String formatNow(String pattern) {
        return DateUtil.format(new Date(), pattern);
    }

    public static String formatByDefault(Date date) {
        return DateUtil.format(date, DEFAULT_PATTERN);
    }

    public static long compareTime(String fromtime, String totime, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        Date one = null;
        Date two = null;
        long days = 0L;
        try {
            one = df.parse(fromtime);
            two = df.parse(totime);
            long time1 = one.getTime();
            long time2 = two.getTime();
            long diff = time1 - time2;
            days = diff / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return days;
    }

    public static String formatNowByDefault() {
        return DateUtil.formatNow(DEFAULT_PATTERN);
    }

    public static Date tomorrow() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, 1);
        return calendar.getTime();
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date);
    }

    public static Date parse(String date, String pattern) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.parse(date);
    }

    public static Date parseByDefault(String data) throws ParseException {
        return DateUtil.parse(data, DEFAULT_PATTERN);
    }

    public static Date getStartTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getEndTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getTodayStartTime() {
        return DateUtil.getStartTime(new Date());
    }

    public static Date getTodayEndTime() {
        return DateUtil.getEndTime(new Date());
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.getTodayStartTime());
        System.out.println(DateUtil.getTodayEndTime());
    }

    public static String calExpireDate(int days) {
        long now = System.currentTimeMillis();
        long expiretime = now + 86400000L * (long)days;
        return sdfDate.format(new Date(expiretime));
    }

    public static String getCurDateStr() {
        return sdfDate.format(new Date());
    }

    public static Date getEndTime(Date StartTime, String timeType, int offSet) {
        Calendar endTimeCalendar = Calendar.getInstance();
        endTimeCalendar.setTime(StartTime);
        if (timeType.equals("day")) {
            endTimeCalendar.add(6, offSet);
        } else if (timeType.equals("hour")) {
            endTimeCalendar.add(11, offSet);
        } else if (timeType.equals("minute")) {
            endTimeCalendar.add(12, offSet);
        } else if (timeType.equals("second")) {
            endTimeCalendar.add(13, offSet);
        }
        return endTimeCalendar.getTime();
    }

    public static String getNowDay() {
        return DateUtil.formatNow("yyyy-MM-dd");
    }
}

