/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class CodeUtil {
    private static final String BASEPATH = EnvPropertyUtil.loadProperty("niux", "zcodePath");
    private static final int width = 95;
    private static final int height = 95;

    public static BufferedImage getZcode(String fileName, String content) {
        return CodeUtil.getZcode(BASEPATH, fileName, content, 95, 95);
    }

    public static BufferedImage getZcode(String fileName, String content, int awidth, int aheight) {
        return CodeUtil.getZcode(BASEPATH, fileName, content, awidth, aheight);
    }

    public static BufferedImage getZcode(String path, String fileName, String content, int awidth, int aheight) {
        File file1 = null;
        BufferedImage image = null;
        try {
            MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
            hints.put(EncodeHintType.MARGIN, 0);
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            BitMatrix bitMatrix = multiFormatWriter.encode(content, BarcodeFormat.QR_CODE, awidth, aheight, hints);
            file1 = new File(path, fileName);
            MatrixToImageConfig config = new MatrixToImageConfig(-16777215, -1);
            MatrixToImageWriter.writeToFile(bitMatrix, "jpg", file1, config);
            int[] rec = bitMatrix.getEnclosingRectangle();
            int resWidth = rec[2] + 1;
            int resHeight = rec[3] + 1;
            BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
            resMatrix.clear();
            for (int i = 0; i < resWidth; ++i) {
                for (int j = 0; j < resHeight; ++j) {
                    if (!bitMatrix.get(i + rec[0], j + rec[1])) continue;
                    resMatrix.set(i, j);
                }
            }
            int width = resMatrix.getWidth();
            int height = resMatrix.getHeight();
            int onColor = config.getPixelOnColor();
            int offColor = config.getPixelOffColor();
            image = new BufferedImage(width, height, onColor != -16777216 || offColor != -1 ? 1 : 12);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    image.setRGB(x, y, resMatrix.get(x, y) ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                    image.setRGB(x, y, resMatrix.get(x, y) ? onColor : offColor);
                }
            }
            ImageIO.write((RenderedImage)image, "jpg", file1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return image;
    }

    public static void getZcode(String path, String fileName, String content, int awidth, int aheight, XLHttpResponse response) {
        File file1 = null;
        try {
            MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
            hints.put(EncodeHintType.MARGIN, 0);
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            BitMatrix bitMatrix = multiFormatWriter.encode(content, BarcodeFormat.QR_CODE, awidth, aheight, hints);
            file1 = new File(path, fileName);
            MatrixToImageConfig config = new MatrixToImageConfig(-16777215, -1);
            MatrixToImageWriter.toBufferedImage(bitMatrix, config);
            int[] rec = bitMatrix.getEnclosingRectangle();
            int resWidth = rec[2] + 1;
            int resHeight = rec[3] + 1;
            BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
            resMatrix.clear();
            for (int i = 0; i < resWidth; ++i) {
                for (int j = 0; j < resHeight; ++j) {
                    if (!bitMatrix.get(i + rec[0], j + rec[1])) continue;
                    resMatrix.set(i, j);
                }
            }
            int width = resMatrix.getWidth();
            int height = resMatrix.getHeight();
            int onColor = config.getPixelOnColor();
            int offColor = config.getPixelOffColor();
            BufferedImage image = new BufferedImage(width, height, onColor != -16777216 || offColor != -1 ? 1 : 12);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    image.setRGB(x, y, resMatrix.get(x, y) ? Color.BLACK.getRGB() : Color.WHITE.getRGB());
                    image.setRGB(x, y, resMatrix.get(x, y) ? onColor : offColor);
                }
            }
            ImageIO.write((RenderedImage)image, "jpg", file1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

