/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.thirdclient.ipinfoclient;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.xunlei.niux.center.dto.ipinfo.IpInfoDTO;
import com.xunlei.niux.center.util.HttpClientUtil;
import com.xunlei.util.Log;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class IPInfoLookUpClient {
    private static Logger logger = Log.getLogger(IPInfoLookUpClient.class.getName());
    private static final String TAOBAOIPAPI = "http://ip.taobao.com/service/getIpInfo.php";
    private static final String SINAIPAPI = "http://int.dpool.sina.com.cn/iplookup/iplookup.php";

    public IpInfoDTO getIpInfo(String ip) {
        IpInfoDTO ipInfo = null;
        ipInfo = this.getTaoBaoIPInfo(ip);
        if (ipInfo == null) {
            ipInfo = this.getSinaIpInfo(ip);
        }
        return ipInfo;
    }

    private IpInfoDTO getTaoBaoIPInfo(String ip) {
        IpInfoDTO ipInfoDTO = null;
        String url = "http://ip.taobao.com/service/getIpInfo.php?ip=" + ip;
        String result = "";
        try {
            result = HttpClientUtil.getHtml(url);
        }
        catch (Exception e) {
            logger.error("getTaoBaoIPInfo with ip " + ip + " error, cause by:" + e);
        }
        JsonObject jsonObject = null;
        String code = null;
        try {
            jsonObject = new JsonParser().parse(result).getAsJsonObject();
            code = jsonObject.get("code").toString();
        }
        catch (JsonSyntaxException e) {
            logger.error("getTaoBaoIPInfo with ip " + ip + ", error resp " + result + ", cause by:" + e);
            return null;
        }
        if (!code.equals("0")) {
            return ipInfoDTO;
        }
        ipInfoDTO = new IpInfoDTO();
        JsonObject data = jsonObject.getAsJsonObject("data");
        String country = data.get("country").getAsString();
        String province = data.get("region").getAsString();
        String city = data.get("city").getAsString();
        String isp = data.get("isp").getAsString();
        ipInfoDTO.setCounty(country);
        ipInfoDTO.setProvince(province);
        ipInfoDTO.setCity(city);
        ipInfoDTO.setIsp(isp);
        return ipInfoDTO;
    }

    private IpInfoDTO getSinaIpInfo(String ip) {
        IpInfoDTO ipInfoDTO = null;
        String url = "http://int.dpool.sina.com.cn/iplookup/iplookup.php?format=json&ip=" + ip;
        String result = "";
        try {
            result = HttpClientUtil.getHtml(url);
        }
        catch (Exception e) {
            logger.error("getSinaIpInfo with ip " + ip + " error, cause by:" + e);
        }
        JsonObject jsonObject = null;
        String code = null;
        try {
            jsonObject = new JsonParser().parse(result).getAsJsonObject();
            code = jsonObject.get("ret").getAsString();
        }
        catch (JsonSyntaxException e) {
            logger.error("getSinaIpInfo with ip " + ip + ", error resp " + result + ", cause by:" + e);
            return null;
        }
        if (!code.equals("1")) {
            return ipInfoDTO;
        }
        ipInfoDTO = new IpInfoDTO();
        String country = jsonObject.get("country").getAsString();
        String province = jsonObject.get("province").getAsString();
        String city = jsonObject.get("city").getAsString();
        String isp = jsonObject.get("isp").getAsString();
        ipInfoDTO.setCounty(country);
        ipInfoDTO.setProvince(province);
        ipInfoDTO.setCity(city);
        ipInfoDTO.setIsp(isp);
        return ipInfoDTO;
    }

    public Boolean isIPChinaMainland(String ip) {
        IpInfoDTO ipInfo = this.getIpInfo(ip);
        if (ipInfo == null) {
            return false;
        }
        if (!ipInfo.getCounty().equals("\u4e2d\u56fd")) {
            return false;
        }
        if (StringUtils.isEmpty(ipInfo.getProvince()) || ipInfo.getProvince().contains("\u53f0\u6e7e") || ipInfo.getProvince().contains("\u9999\u6e2f") || ipInfo.getProvince().contains("\u6fb3\u95e8")) {
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        IPInfoLookUpClient ininfolookup = new IPInfoLookUpClient();
        String ip = "117.89.35.98";
        boolean flag = ininfolookup.isIPChinaMainland(ip);
        System.out.println("Success!");
    }
}

