/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.thirdclient;

import com.xunlei.niux.center.thirdclient.weixin.BindInfo;
import com.xunlei.niux.center.util.UserInfoDecoder;
import com.xunlei.niux.center.util.UserInfoEncoder;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class UserInfoClient {
    private static UserInfoClient userClient = new UserInfoClient();
    private static Logger logger = Log.getLogger(UserInfoClient.class);
    private Properties config = new Properties();

    public static UserInfoClient getInstance() {
        return userClient;
    }

    private UserInfoClient() {
        try {
            String env = EnvPropertyUtil.getEnv();
            String filePath = StringUtils.isEmpty(env) ? "userClient.properties" : env + "/userClient.properties";
            this.config.load(UserInfoClient.class.getClassLoader().getResourceAsStream(filePath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getConfigValue(String key) {
        return (String)this.config.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindInfo bind(String userid, String third_uid) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("request", "set_user_token");
        fieldMap.put("userno", userid);
        fieldMap.put("xl_type", "0");
        fieldMap.put("third_uid", third_uid);
        BindInfo result = new BindInfo();
        result.setResult(500);
        byte[] requestData = UserInfoEncoder.encode(fieldMap);
        String[] ips = this.config.getProperty("ip3").trim().split(",");
        String[] ports = this.config.getProperty("port3").trim().split(",");
        int i = 0;
        String ip = "";
        int port = 0;
        boolean flag = false;
        while (i < ips.length && !flag) {
            Socket socket = null;
            try {
                ip = ips[i];
                port = Integer.parseInt(ports[i]);
                logger.info("\ufffd\ufffd " + ++i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd bind\ufffd\ufffduserName:" + userid + ",third_uid:" + third_uid + ",ip:" + ip + ",port:" + port);
                socket = new Socket(ip, port);
                socket.setSoTimeout(20000);
                socket.setSoTimeout(20000);
                OutputStream out = socket.getOutputStream();
                out.write(requestData);
                InputStream in = socket.getInputStream();
                BufferedInputStream bin = new BufferedInputStream(in);
                Map<String, String> resultFieldMap = UserInfoDecoder.decode(bin);
                result.setResult(Integer.parseInt(resultFieldMap.get("result").trim()));
                if (result.getResult() == 200) {
                    flag = true;
                    logger.info("\ufffd\ufffd " + i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd bind\ufffd\ufffd\ufffd\u0279\ufffd\ufffd\ufffduserid:" + userid + ",third_uid:" + third_uid + ",ip:" + ip + ",port:" + port + "result:" + result.getResult());
                    continue;
                }
                result.setErrorinfo(resultFieldMap.get("strerr"));
                result.setSign(resultFieldMap.get("sign"));
                logger.info("\ufffd\ufffd " + i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd bind\ufffd\ufffd\u02a7\ufffd\u0723\ufffduserid:" + userid + ",third_uid:" + third_uid + ",ip:" + ip + ",port:" + port + "result:" + result.getResult());
            }
            catch (Exception e) {
                logger.info("\ufffd\ufffd " + i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd bind\ufffd\ufffd\ufffd\ucce3\ufffd\ufffduserid:" + userid + ",third_uid:" + third_uid + ",ip:" + ip + ",port:" + port + "result:" + result.getResult(), e);
            }
            finally {
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindInfo checkBind(String userid, String third_uid) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("request", "check_bind");
        if (!StringUtils.isEmpty(userid)) {
            fieldMap.put("userno", userid);
        }
        if (!StringUtils.isEmpty(third_uid)) {
            fieldMap.put("ID", third_uid);
        }
        BindInfo result = new BindInfo();
        result.setResult(500);
        byte[] requestData = UserInfoEncoder.encode(fieldMap);
        String[] ips = this.config.getProperty("ip3").trim().split(",");
        String[] ports = this.config.getProperty("port3").trim().split(",");
        int i = 0;
        String ip = "";
        int port = 0;
        boolean flag = false;
        while (i < ips.length && !flag) {
            Socket socket = null;
            try {
                ip = ips[i];
                port = Integer.parseInt(ports[i]);
                logger.info("\ufffd\ufffd " + ++i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd checkBind\ufffd\ufffduserName:" + userid + ",third_uid:" + third_uid + ",ip:" + ip + ",port:" + port);
                socket = new Socket(ip, port);
                socket.setSoTimeout(20000);
                socket.setSoTimeout(20000);
                OutputStream out = socket.getOutputStream();
                out.write(requestData);
                InputStream in = socket.getInputStream();
                BufferedInputStream bin = new BufferedInputStream(in);
                Map<String, String> resultFieldMap = UserInfoDecoder.decode(bin);
                result.setResult(Integer.parseInt(resultFieldMap.get("result").trim()));
                if (result.getResult() == 200) {
                    flag = true;
                    result.setUserid(resultFieldMap.get("userno"));
                    result.setSign(resultFieldMap.get("sign"));
                    logger.info("\ufffd\ufffd " + i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd checkBind\ufffd\ufffd\ufffd\u0279\ufffd\ufffd\ufffduserid:" + userid + ",third_uid:" + third_uid + ",ip:" + ip + ",port:" + port + "result:" + result.getResult());
                    continue;
                }
                result.setSign(resultFieldMap.get("sign"));
                result.setErrorinfo(resultFieldMap.get("strerr"));
                logger.info("\ufffd\ufffd " + i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd checkBind\ufffd\ufffd\u02a7\ufffd\u0723\ufffduserid:" + userid + ",third_uid:" + third_uid + ",ip:" + ip + ",port:" + port + "result:" + result.getResult());
            }
            catch (Exception e) {
                logger.info("\ufffd\ufffd " + i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd checkBind\ufffd\ufffd\ufffd\ucce3\ufffd\ufffduserid:" + userid + ",third_uid:" + third_uid + ",ip:" + ip + ",port:" + port + "result:" + result.getResult(), e);
            }
            finally {
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindInfo unBind(String third_uid) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("request", "release_bind");
        fieldMap.put("thirdid", third_uid);
        BindInfo result = new BindInfo();
        result.setResult(500);
        byte[] requestData = UserInfoEncoder.encode(fieldMap);
        String[] ips = this.config.getProperty("ip3").trim().split(",");
        String[] ports = this.config.getProperty("port3").trim().split(",");
        int i = 0;
        String ip = "";
        int port = 0;
        boolean flag = false;
        while (i < ips.length && !flag) {
            Socket socket = null;
            try {
                ip = ips[i];
                port = Integer.parseInt(ports[i]);
                logger.info("\ufffd\ufffd " + ++i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd unBind\ufffd\ufffduserid:" + "" + ",third_uid:" + third_uid + ",ip:" + ip + ",port:" + port);
                socket = new Socket(ip, port);
                socket.setSoTimeout(20000);
                socket.setSoTimeout(20000);
                OutputStream out = socket.getOutputStream();
                out.write(requestData);
                InputStream in = socket.getInputStream();
                BufferedInputStream bin = new BufferedInputStream(in);
                Map<String, String> resultFieldMap = UserInfoDecoder.decode(bin);
                result.setResult(Integer.parseInt(resultFieldMap.get("result").trim()));
                if (result.getResult() == 200) {
                    flag = true;
                    logger.info("\ufffd\ufffd " + i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd unBind\ufffd\ufffd\ufffd\u0279\ufffd\ufffd\ufffduserid:" + "" + ",third_uid:" + third_uid + ",ip:" + ip + ",port:" + port + "result:" + result.getResult());
                    continue;
                }
                result.setErrorinfo(resultFieldMap.get("strerr"));
                logger.info("\ufffd\ufffd " + i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd unBind\ufffd\ufffd\u02a7\ufffd\u0723\ufffduserid:" + "" + ",third_uid:" + third_uid + ",ip:" + ip + ",port:" + port + "result:" + result.getResult() + ",strerr:" + result.getErrorinfo());
            }
            catch (Exception e) {
                logger.info("\ufffd\ufffd " + i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd unBind\ufffd\ufffd\ufffd\ucce3\ufffd\ufffduserid:" + "" + ",third_uid:" + third_uid + ",ip:" + ip + ",port:" + port + "result:" + result.getResult(), e);
            }
            finally {
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindInfo unBind2(String userid) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("request", "release_bind_2");
        fieldMap.put("userno", userid);
        BindInfo result = new BindInfo();
        result.setResult(500);
        byte[] requestData = UserInfoEncoder.encode(fieldMap);
        String[] ips = this.config.getProperty("ip3").trim().split(",");
        String[] ports = this.config.getProperty("port3").trim().split(",");
        int i = 0;
        String ip = "";
        int port = 0;
        boolean flag = false;
        while (i < ips.length && !flag) {
            Socket socket = null;
            try {
                ip = ips[i];
                port = Integer.parseInt(ports[i]);
                logger.info("\ufffd\ufffd " + ++i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd unBind\ufffd\ufffduserid:" + "" + ",userid:" + userid + ",ip:" + ip + ",port:" + port);
                socket = new Socket(ip, port);
                socket.setSoTimeout(20000);
                socket.setSoTimeout(20000);
                OutputStream out = socket.getOutputStream();
                out.write(requestData);
                InputStream in = socket.getInputStream();
                BufferedInputStream bin = new BufferedInputStream(in);
                Map<String, String> resultFieldMap = UserInfoDecoder.decode(bin);
                result.setResult(Integer.parseInt(resultFieldMap.get("result").trim()));
                if (result.getResult() == 200) {
                    flag = true;
                    logger.info("\ufffd\ufffd " + i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd unBind\ufffd\ufffd\ufffd\u0279\ufffd\ufffd\ufffduserid:" + "" + ",userid:" + userid + ",ip:" + ip + ",port:" + port + "result:" + result.getResult());
                    continue;
                }
                result.setErrorinfo(resultFieldMap.get("strerr"));
                logger.info("\ufffd\ufffd " + i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd unBind\ufffd\ufffd\u02a7\ufffd\u0723\ufffduserid:" + "" + ",userid:" + userid + ",ip:" + ip + ",port:" + port + "result:" + result.getResult() + ",strerr:" + result.getErrorinfo());
            }
            catch (Exception e) {
                logger.info("\ufffd\ufffd " + i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd unBind\ufffd\ufffd\ufffd\ucce3\ufffd\ufffduserid:" + "" + ",userid:" + userid + ",ip:" + ip + ",port:" + port + "result:" + result.getResult(), e);
            }
            finally {
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindInfo getLoginUserInfoByUserId(String userid) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("request", "getuserinfo");
        fieldMap.put("userid", userid);
        fieldMap.put("usertype", "2");
        fieldMap.put("usernewno", "");
        fieldMap.put("usrname", "");
        fieldMap.put("md5psw", "");
        fieldMap.put("nickname", "");
        fieldMap.put("level", "");
        BindInfo userinfo = new BindInfo();
        userinfo.setResult(500);
        byte[] requestData = UserInfoEncoder.encode(fieldMap);
        String[] ips = this.config.getProperty("ip2").trim().split(",");
        String[] ports = this.config.getProperty("port2").trim().split(",");
        int i = 0;
        boolean flag = true;
        String ip = "";
        int port = 0;
        while (i < ips.length && flag) {
            Socket socket = null;
            try {
                ip = ips[i];
                port = Integer.parseInt(ports[i]);
                logger.info("\u7b2c " + ++i + "\u6b21\u8bf7\u6c42 getuserinfo\uff0cuserid:" + userid + ",ip:" + ip + ",port:" + port);
                socket = new Socket(ip, port);
                socket.setSoTimeout(20000);
                OutputStream out = socket.getOutputStream();
                out.write(requestData);
                InputStream in = socket.getInputStream();
                BufferedInputStream bin = new BufferedInputStream(in);
                Map<String, String> resultFieldMap = UserInfoDecoder.decode(bin);
                userinfo.setResult(Integer.parseInt(resultFieldMap.get("result").trim()));
                if (userinfo.getResult() == 200) {
                    flag = false;
                    logger.info("\u7b2c " + i + "\u6b21\u8bf7\u6c42 getusrinfor\uff0c\u6210\u529f\uff0cuserid:" + userid + ",ip:" + ip + ",port:" + port + "result:" + userinfo.getResult());
                    userinfo.setUserid(resultFieldMap.get("userno"));
                    userinfo.setDigitaccount(resultFieldMap.get("usernewno"));
                    userinfo.setNickName(resultFieldMap.get("nickname"));
                    userinfo.setLevel(resultFieldMap.get("level"));
                    continue;
                }
                logger.info("\u7b2c " + i + "\u6b21\u8bf7\u6c42 getusrinfor\uff0c\u5931\u8d25\uff0cuserid:" + userid + ",ip:" + ip + ",port:" + port + "result:" + userinfo.getResult());
            }
            catch (Exception e) {
                logger.info("\u7b2c " + i + "\u6b21\u8bf7\u6c42 getusrinfor\uff0c\u5f02\u5e38\uff0cuserid:" + userid + ",ip:" + ip + ",port:" + port + "result:" + userinfo.getResult(), e);
            }
            finally {
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (Exception e) {}
            }
        }
        return userinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BindInfo getUserInfo(String loginName) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        long start = System.currentTimeMillis();
        fieldMap.put("request", "getuserinfo");
        fieldMap.put("userid", loginName);
        fieldMap.put("usertype", "-1");
        fieldMap.put("usernewno", "");
        fieldMap.put("usrname", "");
        fieldMap.put("md5psw", "");
        fieldMap.put("sex", "");
        BindInfo userinfo = new BindInfo();
        userinfo.setResult(500);
        byte[] requestData = UserInfoEncoder.encode(fieldMap);
        String[] ips = this.config.getProperty("ip2").trim().split(",");
        String[] ports = this.config.getProperty("port2").trim().split(",");
        int i = 0;
        boolean flag = true;
        String ip = "";
        int port = 0;
        while (i < ips.length && flag) {
            Socket socket = null;
            try {
                ip = ips[i];
                port = Integer.parseInt(ports[i]);
                logger.info("\u7b2c " + ++i + "\u6b21\u8bf7\u6c42 getuserinfo\uff0cuserName:" + loginName + ",ip:" + ip + ",port:" + port);
                socket = new Socket(ip, port);
                socket.setSoTimeout(20000);
                OutputStream out = socket.getOutputStream();
                out.write(requestData);
                InputStream in = socket.getInputStream();
                BufferedInputStream bin = new BufferedInputStream(in);
                Map<String, String> resultFieldMap = UserInfoDecoder.decode(bin);
                userinfo.setResult(Integer.parseInt(resultFieldMap.get("result")));
                if (userinfo.getResult() == 200) {
                    flag = false;
                    logger.info("\u7b2c " + i + "\u6b21\u8bf7\u6c42 getuserinfo\uff0c\u6210\u529f\uff0cuserName:" + loginName + ",ip:" + ip + ",port:" + port + "result:" + userinfo.getResult() + ",cost:" + (System.currentTimeMillis() - start));
                    userinfo.setUserid(resultFieldMap.get("userno"));
                    continue;
                }
                logger.info("\u7b2c " + i + "\u6b21\u8bf7\u6c42 getuserinfo\uff0c\u5931\u8d25\uff0cuserName:" + loginName + ",ip:" + ip + ",port:" + port + "result:" + userinfo.getResult() + ",cost:" + (System.currentTimeMillis() - start));
            }
            catch (Exception e) {
                logger.info("\u7b2c " + i + "\u6b21\u8bf7\u6c42 getuserinfo\uff0c\u5f02\u5e38\uff0cuserid:" + loginName + ",ip:" + ip + ",port:" + port + "result:" + userinfo.getResult() + ",cost:" + (System.currentTimeMillis() - start), e);
            }
            finally {
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (Exception e) {}
            }
        }
        return userinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkpass(String userName, String md5psw) {
        boolean result = false;
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("request", "checkpass");
        fieldMap.put("userid", userName);
        fieldMap.put("usertype", "-1");
        fieldMap.put("md5psw", md5psw);
        int code = 500;
        byte[] requestData = UserInfoEncoder.encode(fieldMap);
        String[] ips = this.config.getProperty("ip2").trim().split(",");
        String[] ports = this.config.getProperty("port2").trim().split(",");
        int i = 0;
        String ip = "";
        int port = 0;
        while (i < ips.length && !result) {
            Socket socket = null;
            try {
                ip = ips[i];
                port = Integer.parseInt(ports[i]);
                logger.info("\ufffd\ufffd " + ++i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd checkpass\ufffd\ufffduserName:" + userName + ",ip:" + ip + ",port:" + port);
                socket = new Socket(ip, port);
                socket.setSoTimeout(20000);
                socket.setSoTimeout(20000);
                OutputStream out = socket.getOutputStream();
                out.write(requestData);
                InputStream in = socket.getInputStream();
                BufferedInputStream bin = new BufferedInputStream(in);
                Map<String, String> resultFieldMap = UserInfoDecoder.decode(bin);
                code = Integer.parseInt(resultFieldMap.get("result").trim());
                if (code == 200) {
                    result = true;
                    logger.info("\ufffd\ufffd " + i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd checkpass\ufffd\ufffd\ufffd\u0279\ufffd\ufffd\ufffduserName:" + userName + ",ip:" + ip + ",port:" + port + "result:" + code);
                    continue;
                }
                logger.info("\ufffd\ufffd " + i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd checkpass\ufffd\ufffd\u02a7\ufffd\u0723\ufffduserName:" + userName + ",ip:" + ip + ",port:" + port + "result:" + code);
            }
            catch (Exception e) {
                logger.info("\ufffd\ufffd " + i + "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd checkpass\ufffd\ufffd\ufffd\ucce3\ufffd\ufffduserid:" + userName + ",ip:" + ip + ",port:" + port + "result:" + code, e);
            }
            finally {
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        UserInfoClient xy = new UserInfoClient();
        String md5psw = "11";
        String third_uid = "ojZwIj5g1A1gwGy5e2ChEUtQMxOg";
        String userid = "123540516";
        BindInfo isbinded = UserInfoClient.getInstance().checkBind(userid, null);
        isbinded = UserInfoClient.getInstance().checkBind(userid, third_uid);
    }
}

