/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.thirdclient;

import com.xunlei.niux.center.exception.NiuxException;
import com.xunlei.niux.center.thread.RetrySendSMSIdentifyingCodeThread;
import com.xunlei.niux.center.util.HttpClientUtil;
import com.xunlei.niux.center.util.SignUtil;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class SmsClient {
    private static String sms_domain = EnvPropertyUtil.loadProperty("sms", "sms_domain");
    private static String sms_bizno = EnvPropertyUtil.loadProperty("sms", "sms_bizno");
    private static String sms_bizpwd = EnvPropertyUtil.loadProperty("sms", "sms_bizpwd");
    private static String sms_identifyingcodelen = "6";
    private static String sms_identifyingcodeonlynum = "1";
    private static String sms_identifyingcodeexpire = "300";
    private static String sms_identifyingcodesmscontentformat = "\u9a8c\u8bc1\u7801{}\u3010\u8fc5\u96f7\u7f51\u7edc\u3011";
    private static Logger logger = Log.getLogger(SmsClient.class);
    private static Map<String, String> errCodeMap = new HashMap<String, String>();

    public static void sendIdentifyingCode(String mobileNum) throws NiuxException {
        SmsClient.sendIdentifyingCode(mobileNum, sms_identifyingcodesmscontentformat);
    }

    public static void sendIdentifyingCode(String mobileNum, String content) throws NiuxException {
        if (!content.endsWith("\u3010\u8fc5\u96f7\u7f51\u7edc\u3011")) {
            content = content + "\u3010\u8fc5\u96f7\u7f51\u7edc\u3011";
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", "v1.0");
        param.put("pageCharset", "GBK");
        param.put("bizNo", sms_bizno);
        param.put("mobile", mobileNum);
        param.put("content", content);
        String signPwd = SignUtil.sign(param, sms_bizpwd);
        param.put("needCode", "1");
        param.put("codeLen", sms_identifyingcodelen);
        param.put("onlyNum", sms_identifyingcodeonlynum);
        param.put("expire", sms_identifyingcodeexpire);
        String paramStr = SignUtil.getSignatureContent(param, "UTF-8");
        try {
            String requesturl = sms_domain + "/sendsms?" + paramStr + "&signMsg=" + signPwd;
            String resp = HttpClientUtil.get(requesturl);
            if (!resp.contains("<sendresult>00</sendresult>")) {
                RetrySendSMSIdentifyingCodeThread retryThread = new RetrySendSMSIdentifyingCodeThread(requesturl);
                new Thread(retryThread).start();
                String errorCode = resp.substring(resp.indexOf("<errcode>") + 9, resp.indexOf("</errcode>"));
                throw new NiuxException(errorCode, errCodeMap.get(errorCode));
            }
        }
        catch (NiuxException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NiuxException("99", e.getMessage(), e);
        }
    }

    public static void sendSms(String mobileNum, String content) throws NiuxException {
        if (!content.endsWith("\u3010\u8fc5\u96f7\u7f51\u7edc\u3011")) {
            content = content + "\u3010\u8fc5\u96f7\u7f51\u7edc\u3011";
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", "v1.0");
        param.put("pageCharset", "GBK");
        param.put("bizNo", sms_bizno);
        param.put("mobile", mobileNum);
        param.put("content", content);
        String signPwd = SignUtil.sign(param, sms_bizpwd);
        String paramStr = SignUtil.getSignatureContent(param, "UTF-8");
        try {
            String url = sms_domain + "/sendsms?" + paramStr + "&signMsg=" + signPwd;
            System.out.println("smsurl:" + url);
            String resp = HttpClientUtil.get(url);
            if (!resp.contains("<sendresult>00</sendresult>")) {
                String errorCode = resp.substring(resp.indexOf("<errcode>") + 9, resp.indexOf("</errcode>"));
                throw new NiuxException(errorCode, errCodeMap.get(errorCode));
            }
        }
        catch (NiuxException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NiuxException("99", e.getMessage(), e);
        }
    }

    public static void checkIdentifyingCode(String mobileNum, String code) throws NiuxException {
        if (mobileNum == null || "".equals(mobileNum)) {
            throw new NiuxException("13", "\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        if (code == null || "".equals(code)) {
            throw new NiuxException("14", "\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sms_domain).append("/validate?").append("mobile=").append(mobileNum).append("&bizNo=").append(sms_bizno).append("&authcode=").append(code);
        try {
            String resp = HttpClientUtil.get(sb.toString());
            if (!resp.contains("<sendresult>00</sendresult>")) {
                String errorCode = resp.substring(resp.indexOf("<errcode>") + 9, resp.indexOf("</errcode>"));
                throw new NiuxException(errorCode, errCodeMap.get(errorCode));
            }
        }
        catch (NiuxException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NiuxException("99", e.getMessage(), e);
        }
    }

    static {
        errCodeMap.put("12", "\u624b\u673a\u53f7\u6216\u77ed\u4fe1\u5f62\u5bb9\u4e3a\u7a7a");
        errCodeMap.put("13", "\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
        errCodeMap.put("21", "\u4e0d\u597d\u610f\u601d\uff0c\u60a8\u7684\u9a8c\u8bc1\u7801\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6~");
        errCodeMap.put("22", "\u4e0d\u597d\u610f\u601d\uff0c\u60a8\u7684\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165~");
    }
}

