/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.thirdclient;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.util.Log;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class JinZuanClient {
    private static final String queryJinZuanUrl = "http://jinzuan.niu.xunlei.com:9090/member/getmemberinfo.do?";
    private static Logger logger = Log.getLogger(JinZuanClient.class);

    public static int isJinZuanUser(String uid) throws Exception {
        StringBuffer url = new StringBuffer(queryJinZuanUrl).append("uid=").append(uid);
        String reponseText = HttpClientUtil.get(url.toString());
        JsonObject jsonObject = new JsonParser().parse(reponseText).getAsJsonObject();
        int code = jsonObject.get("rtn").getAsInt();
        logger.info("userId" + uid + "isJinZuanUser returnCode:" + code);
        if (code == 3) {
            return 1;
        }
        if (code == 0) {
            JsonObject result = jsonObject.get("data").getAsJsonObject();
            int memberStatus = result.get("memberStatus").getAsInt();
            int experienceStatus = result.get("experienceStatus").getAsInt();
            if (memberStatus == 1) {
                if (experienceStatus == 1) {
                    return 3;
                }
                return 0;
            }
            return 2;
        }
        return -1;
    }

    public static JsonObject getMemberInfo(String uid) throws Exception {
        StringBuffer url = new StringBuffer(queryJinZuanUrl).append("uid=").append(uid);
        String reponseText = HttpClientUtil.get(url.toString());
        if (reponseText == null || reponseText.indexOf("{") < 0) {
            throw new NullPointerException("\u8bf7\u6c42\u91d1\u94bb\u63a5\u53e3\u5f02\u5e38,response=" + reponseText);
        }
        return new JsonParser().parse(reponseText).getAsJsonObject();
    }

    public static Integer getJinzuanLevel(String uid) throws Exception {
        StringBuffer url = new StringBuffer(queryJinZuanUrl).append("uid=").append(uid);
        String reponseText = HttpClientUtil.get(url.toString());
        if (reponseText == null || reponseText.indexOf("{") < 0) {
            throw new NullPointerException("\u8bf7\u6c42\u91d1\u94bb\u63a5\u53e3\u5f02\u5e38,response=" + reponseText);
        }
        JsonObject jsonObject = new JsonParser().parse(reponseText).getAsJsonObject();
        int code = jsonObject.get("rtn").getAsInt();
        int jinzuanlevel = 0;
        if (code == 3) {
            jinzuanlevel = 0;
        } else if (code == 0) {
            String memberStatus = jsonObject.get("data").getAsJsonObject().get("memberStatus").getAsString();
            jinzuanlevel = StringUtils.isEmpty(memberStatus) || "0".equals(memberStatus) ? 0 : jsonObject.get("data").getAsJsonObject().get("levelNum").getAsInt();
        }
        return jinzuanlevel;
    }
}

