/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.so.rechargevip;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.center.thirdclient.vip.VipClient;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.pay.RechargeRecord;
import com.xunlei.niux.easyutils.commonutils.OrderNoUtil;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;

public class RechargeThread
extends Thread {
    private static long sleeptime = 5000L;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static Logger logger = Log.getLogger(RechargeThread.class.getName());

    @Override
    public void run() {
        while (true) {
            int count = this.exec();
            this.sleep1(count);
        }
    }

    private void sleep1(int count) {
        if (count < 100) {
            try {
                RechargeThread.sleep(sleeptime);
            }
            catch (InterruptedException e) {
                logger.error("\u7761\u7720\u51fa\u73b0\u5f02\u5e38", e);
            }
        }
    }

    private int exec() {
        List<RechargeRecord> list = null;
        try {
            list = this.getNeedRechargeRecordList();
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u9700\u8981\u5145\u503c\u7684\u8bb0\u5f55\u51fa\u73b0\u5f02\u5e38", e);
        }
        if (list == null) {
            list = new ArrayList<RechargeRecord>();
        }
        for (RechargeRecord record : list) {
            this.exec(record);
        }
        return list.size();
    }

    private void exec(RechargeRecord record) {
        try {
            if ("1".equals(record.getRechargeType()) || "2".equals(record.getRechargeType())) {
                this.rechargeWhiteVip(record);
            }
            RechargeRecord rr = FacadeFactory.INSTANCE.getRechargeRecordBo().find(record.getSeqId());
            rr.setRechargeStatus("3");
            rr.setNextCallRechargeTime("");
            rr.setRechargeTime(sdf.format(new Date()));
            FacadeFactory.INSTANCE.getRechargeRecordBo().updateSuccessRechareg(rr);
        }
        catch (Exception e) {
            logger.error("\u6267\u884cseqid:" + record.getSeqId() + "\u51fa\u73b0\u5f02\u5e38", e);
            RechargeRecord rr = FacadeFactory.INSTANCE.getRechargeRecordBo().find(record.getSeqId());
            rr.setFailNum(rr.getFailNum() + 1);
            long time = System.currentTimeMillis();
            time = 60000L * time;
            String timeStr = sdf.format(new Date(time));
            if (rr.getFailNum() > 5) {
                timeStr = "9999-12-31 00:00:00";
            }
            rr.setNextCallRechargeTime(timeStr);
            rr.setRechargeTime(sdf.format(new Date()));
            String message = e.getMessage();
            message = message.length() > 250 ? message.substring(0, 245) : message;
            rr.setRemark(message);
            FacadeFactory.INSTANCE.getRechargeRecordBo().update(rr);
        }
    }

    private void rechargeWhiteVip(RechargeRecord record) throws Exception {
        int days = VipClient.vipUpdteToWhiteVip(record.getUserId(), record.getPayId());
        if (days > 0) {
            RechargeRecord rr = new RechargeRecord();
            rr.setRechargeNo(OrderNoUtil.getOrderNo());
            rr.setRechargeTime(sdf.format(new Date()));
            rr.setNextCallRechargeTime("");
            rr.setRechargeStatus("3");
            rr.setProductName("\u5347\u7ea7\u767d\u91d1\u4f1a\u5458");
            rr.setFailNum(0);
            rr.setRechargeType("4");
            rr.setExt1(rr.getRechargeNo());
            rr.setUserId(record.getUserId());
            rr.setOrderNo(record.getOrderNo());
            rr.setRechargeNum(days);
            FacadeFactory.INSTANCE.getRechargeRecordBo().insert(rr);
        }
        VipClient.openWhiteVip(record.getUserId(), record.getRechargeNo(), record.getPayId(), "3", record.getRechargeNum());
    }

    private List<RechargeRecord> getNeedRechargeRecordList() {
        RechargeRecord qrr = new RechargeRecord();
        String now = sdf.format(new Date());
        qrr.setToNextCallRechargeTime(now);
        qrr.setRechargeStatus("0");
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(100);
        List<RechargeRecord> list = FacadeFactory.INSTANCE.getRechargeRecordBo().find(qrr, page);
        return list;
    }
}

