/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.so.pay.channel;

import com.xunlei.niux.center.so.pay.AbstractDirectPay;
import com.xunlei.niux.center.so.pay.PayConstant;
import com.xunlei.niux.center.so.pay.PayException;
import com.xunlei.niux.center.so.pay.PayResponse;
import com.xunlei.niux.center.so.pay.PayUtil;
import com.xunlei.niux.center.so.paygateway.PayGatewayReq;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.pay.PayOrder;
import com.xunlei.niux.easyutils.commonutils.OrderNoUtil;
import java.util.Date;

public class LeiDianDirectPay
extends AbstractDirectPay {
    @Override
    protected void checkPayRequest() throws PayException {
        if (this.payRequest.orderAmt == null) {
            throw new PayException("13", "\u8ba2\u5355\u91d1\u989d\u4e3a\u7a7a");
        }
        if (this.payRequest.orderAmt == 0.0) {
            throw new PayException("13", "\u8ba2\u5355\u91d1\u989d\u4e3a\u96f6");
        }
        if ("".equals(this.payRequest.payPwd)) {
            throw new PayException("13", "\u652f\u4ed8\u5bc6\u7801\u4e3a\u7a7a");
        }
        if ("".equals(this.payRequest.userId)) {
            throw new PayException("13", "\u8fc5\u96f7userid\u4e3a\u7a7a");
        }
        if ("".equals(this.payRequest.userName)) {
            throw new PayException("13", "\u8fc5\u96f7\u8d26\u53f7\u4e3a\u7a7a");
        }
    }

    @Override
    protected void insertPayOrder() throws PayException {
        PayOrder temppayOrder = new PayOrder();
        temppayOrder.setUserId(this.payRequest.userId);
        temppayOrder.setUserName(this.payRequest.userName);
        temppayOrder.setOrderNo(OrderNoUtil.getOrderNo());
        temppayOrder.setOrderTime(sdf.format(new Date()));
        temppayOrder.setOrderAmt(this.payRequest.orderAmt);
        temppayOrder.setOrderIp(this.payRequest.clientIp);
        temppayOrder.setOrderStatus("0");
        temppayOrder.setProductNo(this.payRequest.productNo);
        temppayOrder.setProductName(this.payRequest.productName);
        temppayOrder.setPayType("A1");
        temppayOrder.setFactAmt(this.payRequest.orderAmt);
        temppayOrder.setFareAmt(0.0);
        temppayOrder.setTempOrderNo(this.payRequest.tempOrderNo);
        temppayOrder.setActNo(this.payRequest.actNo);
        temppayOrder.setProductNum(this.payRequest.productNum);
        FacadeFactory.INSTANCE.getPayOrderBo().insert(temppayOrder);
        this.payOrder = temppayOrder;
    }

    @Override
    protected void initPayGatewayReq() throws PayException {
        PayGatewayReq tempPayGatewayReq = new PayGatewayReq();
        tempPayGatewayReq.setOrderId(this.payOrder.getOrderNo());
        tempPayGatewayReq.setOrderAmt((long)(this.payOrder.getOrderAmt() * 100.0));
        tempPayGatewayReq.setOrderTime(this.payOrder.getOrderTime().replaceAll(":| |-", ""));
        tempPayGatewayReq.setPayType(this.payOrder.getPayType());
        tempPayGatewayReq.setXunleiId(this.payOrder.getUserName());
        tempPayGatewayReq.setXlnumId(this.payOrder.getUserId());
        tempPayGatewayReq.setProductName(this.payOrder.getProductName());
        tempPayGatewayReq.setProductDesc(this.payOrder.getProductName());
        tempPayGatewayReq.setClientIp(this.payOrder.getOrderIp());
        tempPayGatewayReq.setOther1(this.payRequest.payPwd);
        tempPayGatewayReq.setBizNo(PayConstant.whitevipbizno);
        tempPayGatewayReq.setSignMsg(PayUtil.sign(tempPayGatewayReq, PayConstant.whitevipbizpwd));
        this.payGatewayReq = tempPayGatewayReq;
    }

    @Override
    protected PayResponse dealPayGatewayRes(String respString) throws PayException {
        String errorcode = "00";
        if (!respString.contains("<payresult>00</payresult>")) {
            int startindex = respString.indexOf("<errcode>") + "<errocde>".length();
            int endindex = respString.indexOf("</errcode>");
            errorcode = endindex > startindex ? respString.substring(startindex, endindex) : "99";
        }
        PayResponse payResponse = new PayResponse();
        payResponse.setCode(errorcode);
        return payResponse;
    }
}

