/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.so.pay;

import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.niux.center.so.paygateway.PayGatewayReq;
import com.xunlei.util.Log;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;

public class PayUtil {
    private static Logger log = Log.getLogger(PayUtil.class.getName());

    public static String sign(PayGatewayReq payGatewayReq, String privateKey) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", payGatewayReq.getVersion());
        param.put("pageCharset", payGatewayReq.getPageCharset());
        param.put("bgUrl", payGatewayReq.getBgUrl());
        param.put("fgUrl", payGatewayReq.getFgUrl());
        param.put("bizNo", payGatewayReq.getBizNo());
        param.put("orderId", payGatewayReq.getOrderId());
        param.put("orderAmt", String.valueOf(payGatewayReq.getOrderAmt()));
        param.put("orderTime", payGatewayReq.getOrderTime());
        param.put("payType", payGatewayReq.getPayType());
        param.put("xunleiId", payGatewayReq.getXunleiId());
        param.put("xlnumId", payGatewayReq.getXlnumId());
        param.put("peerId", payGatewayReq.getPeerId());
        param.put("productName", payGatewayReq.getProductName());
        param.put("productDesc", payGatewayReq.getProductDesc());
        param.put("bankNo", payGatewayReq.getBankNo());
        param.put("other1", payGatewayReq.getOther1());
        param.put("other2", payGatewayReq.getOther2());
        param.put("other3", payGatewayReq.getOther3());
        param.put("payerName", payGatewayReq.getPayerName());
        param.put("payerContact", payGatewayReq.getPayerContact());
        param.put("ext1", payGatewayReq.getExt1());
        param.put("ext2", payGatewayReq.getExt2());
        String content = PayUtil.getSignatureContent(param);
        String signStr = PayUtil.sign(content, privateKey);
        log.info("\u9700\u8981\u7b7e\u540d\u5904\u7406\u7684URL\uff1a" + content + " \u52a0\u5bc6\u4e32\uff1a" + signStr);
        return signStr;
    }

    public static String sign(String content, String privateKey) {
        if (content == null) {
            return null;
        }
        return Md5Encrypt.md5(content + privateKey);
    }

    public static void main(String[] args) {
        String msg = PayUtil.sign("123456qq", "");
        System.out.println(msg);
    }

    public static String getSignatureContent(Map<String, String> param) {
        return PayUtil.getSignatureContent(param, null);
    }

    public static String getSignatureContent(Map<String, String> param, String encodeCharset) {
        Properties prop = new Properties();
        for (String key : param.keySet()) {
            String value;
            if (key.equals("signMsg") || (value = param.get(key)) == null || "".equals(value)) continue;
            prop.setProperty(key, value);
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> keys = new ArrayList<Object>(prop.keySet());
        Collections.sort((List)keys);
        for (int i = 0; i < ((List)keys).size(); ++i) {
            String key = (String)((List)keys).get(i);
            String value = prop.getProperty(key);
            if (encodeCharset != null && !"".equals(encodeCharset)) {
                try {
                    value = URLEncoder.encode(prop.getProperty(key), encodeCharset);
                }
                catch (Exception localException) {
                    // empty catch block
                }
            }
            sb.append(i == 0 ? "" : "&");
            sb.append(key).append("=").append(value);
        }
        return sb.toString();
    }

    public static String urlEncode(String value, String charset) {
        try {
            return URLEncoder.encode(value, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

