/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.so.pay;

import com.xunlei.niux.center.so.pay.PayException;
import com.xunlei.niux.center.so.pay.PayRequest;
import com.xunlei.niux.center.so.pay.PayResponse;
import com.xunlei.niux.center.so.pay.PayUtil;
import com.xunlei.niux.center.so.paygateway.PayGatewayReq;
import com.xunlei.niux.center.util.HttpClientUtil;
import com.xunlei.niux.data.vipgame.vo.pay.PayOrder;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;

public abstract class AbstractDirectPay {
    protected static Logger logger = Log.getLogger(AbstractDirectPay.class.getName());
    protected static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected PayGatewayReq payGatewayReq;
    protected PayRequest payRequest;
    protected PayOrder payOrder;
    protected String payGatewayReqUrl = EnvPropertyUtil.loadProperty("pay", "paygatewayurl");

    public PayResponse pay(PayRequest payRequest) {
        try {
            this.payRequest = payRequest;
            this.checkPayRequest();
            this.insertPayOrder();
            this.initPayGatewayReq();
            String resp = this.sendReqToGateway();
            return this.dealPayGatewayRes(resp);
        }
        catch (PayException e) {
            return this.toPayResponse(e);
        }
        catch (Exception e) {
            return this.toPayResponse(e);
        }
    }

    protected abstract void checkPayRequest() throws PayException;

    protected abstract void insertPayOrder() throws PayException;

    protected abstract void initPayGatewayReq() throws PayException;

    String sendReqToGateway() throws PayException {
        StringBuilder sb = new StringBuilder();
        sb.append("version=").append(this.payGatewayReq.getVersion()).append("&pageCharset=").append(this.payGatewayReq.getPageCharset()).append("&bgUrl=").append(this.payGatewayReq.getBgUrl()).append("&fgUrl=").append(this.payGatewayReq.getFgUrl()).append("&bizNo=").append(this.payGatewayReq.getBizNo()).append("&orderId=").append(this.payGatewayReq.getOrderId()).append("&orderAmt=").append(this.payGatewayReq.getOrderAmt()).append("&orderTime=").append(this.payGatewayReq.getOrderTime()).append("&payType=").append(this.payGatewayReq.getPayType()).append("&xunleiId=").append(this.payGatewayReq.getXunleiId()).append("&xlnumId=").append(this.payGatewayReq.getXlnumId()).append("&peerId=").append(this.payGatewayReq.getPeerId()).append("&productName=").append(PayUtil.urlEncode(this.payGatewayReq.getProductName(), "UTF-8")).append("&productDesc=").append(PayUtil.urlEncode(this.payGatewayReq.getProductDesc(), "UTF-8")).append("&bankNo=").append(this.payGatewayReq.getBankNo()).append("&other1=").append(PayUtil.urlEncode(this.payGatewayReq.getOther1(), "UTF-8")).append("&other2=").append(PayUtil.urlEncode(this.payGatewayReq.getOther2(), "UTF-8")).append("&other3=").append(PayUtil.urlEncode(this.payGatewayReq.getOther3(), "UTF-8")).append("&payerName=").append(PayUtil.urlEncode(this.payGatewayReq.getPayerName(), "UTF-8")).append("&payerContact=").append(PayUtil.urlEncode(this.payGatewayReq.getPayerContact(), "UTF-8")).append("&clientIp=").append(this.payGatewayReq.getClientIp()).append("&ext1=").append(PayUtil.urlEncode(this.payGatewayReq.getExt1(), "UTF-8")).append("&ext2=").append(PayUtil.urlEncode(this.payGatewayReq.getExt2(), "UTF-8")).append("&signMsg=").append(this.payGatewayReq.getSignMsg());
        String url = this.payGatewayReqUrl + "?" + sb.toString();
        return HttpClientUtil.get(url);
    }

    protected abstract PayResponse dealPayGatewayRes(String var1) throws PayException;

    private PayResponse toPayResponse(Exception e) {
        logger.error("vip\u652f\u4ed8\u51fa\u73b0\u5f02\u5e38", e);
        PayResponse payResponse = new PayResponse();
        String errorCode = "99";
        if (e instanceof PayException) {
            errorCode = ((PayException)e).errorCode;
        }
        payResponse.setCode(errorCode);
        payResponse.setMsg(e.getMessage());
        return payResponse;
    }
}

