/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.so.jinzuan;

import com.xunlei.niux.center.serviceutils.JinKaUtils;
import com.xunlei.niux.center.so.jinzuan.thread.MemberInfoThread;
import com.xunlei.niux.center.so.jinzuan.thread.UserBonusThread;
import com.xunlei.niux.client.jinzuan.dto.MemberShipDTO;
import com.xunlei.niux.client.jinzuan.dto.PrivilegeReceiveInfoDTO;
import com.xunlei.niux.data.jinzuan.enums.PrivilegeType;
import com.xunlei.niux.dto.UserBonus;
import com.xunlei.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class MemberInfoService {
    private static Logger logger = Log.getLogger(MemberInfoService.class);
    private static ExecutorService executorService = Executors.newFixedThreadPool(2);

    public Map<String, Object> getMemberInfo(long userId) {
        String userIdstr = String.valueOf(userId);
        Future<MemberShipDTO> memberFuture = executorService.submit(new MemberInfoThread(userIdstr));
        Future<UserBonus> bonusFuture = executorService.submit(new UserBonusThread(userIdstr));
        MemberShipDTO memberShipDTO = null;
        UserBonus userBonus = null;
        try {
            memberShipDTO = memberFuture.get();
            userBonus = bonusFuture.get();
        }
        catch (InterruptedException e) {
            logger.error("InterruptedException", e);
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            logger.error("ExecutionException", e);
            e.printStackTrace();
        }
        if (memberShipDTO == null) {
            logger.info("\u83b7\u53d6memberShipDTO\u4e3anull");
            return null;
        }
        logger.info("\u83b7\u53d6memberShipDTO\u4fe1\u606f\uff1a" + memberShipDTO.toString());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("memberStatus", memberShipDTO.getMemberStatus() == null ? "" : memberShipDTO.getMemberStatus());
        result.put("isAnnualMember", memberShipDTO.getIsAnnualMember() == null ? 0 : memberShipDTO.getIsAnnualMember());
        result.put("levelNum", memberShipDTO.getLevelNum() == null ? 0 : memberShipDTO.getLevelNum());
        result.put("memberExpireDate", memberShipDTO.getMemberExpireDate() == null ? "" : memberShipDTO.getMemberExpireDate());
        result.put("growthValue", memberShipDTO.getGrowthValue() == null ? 0L : memberShipDTO.getGrowthValue());
        result.put("levelGrowthValue", memberShipDTO.getLevelGrowthValue() == null ? 0L : memberShipDTO.getLevelGrowthValue());
        result.put("nextLevelGrowthValue", memberShipDTO.getNextLevelGrowthValue() == null ? 0L : memberShipDTO.getNextLevelGrowthValue());
        result.put("duobaoStatus", memberShipDTO.getDuobaoStatus());
        result.put("duobaoExpireDate", memberShipDTO.getDuobaoExpireDate() == null ? "" : memberShipDTO.getDuobaoExpireDate());
        result.put("experienceStatus", memberShipDTO.getExperienceStatus());
        result.put("experienceDate", memberShipDTO.getExperienceDate() == null ? "" : memberShipDTO.getExperienceDate());
        List<PrivilegeReceiveInfoDTO> priList = memberShipDTO.getPrilist();
        result.put("priList", this.getPriListStr(priList));
        if (CollectionUtils.isNotEmpty(priList)) {
            Map<String, Object> dhybMap = this.getPriCount(priList, PrivilegeType.BonusExchangeCoin);
            result.put("dhyb", dhybMap);
            Map<String, Object> lqscMap = this.getPriCount(priList, PrivilegeType.FreeFirstGamePay);
            result.put("mfsc", lqscMap);
            Map<String, Object> bqMap = this.getPriCount(priList, PrivilegeType.FillCheck);
            result.put("bq", bqMap);
        } else {
            HashMap map = new HashMap();
            result.put("dhyb", map);
            result.put("mfsc", map);
            result.put("bq", map);
        }
        if (userBonus == null) {
            result.put("totalBonus", 0);
            result.put("bonusNum", 0);
        } else {
            result.put("totalBonus", userBonus.getRechargeSum());
            result.put("bonusNum", userBonus.getBonusNum());
        }
        String rebateRatio = JinKaUtils.getJinKaRebateRatio(userId);
        if (StringUtils.isEmpty(rebateRatio)) {
            result.put("rebateRatio", "");
        } else {
            result.put("rebateRatio", rebateRatio);
        }
        return result;
    }

    private List<String> getPriListStr(List<PrivilegeReceiveInfoDTO> priList) {
        ArrayList<String> result = new ArrayList<String>();
        if (CollectionUtils.isEmpty(priList)) {
            return result;
        }
        for (PrivilegeReceiveInfoDTO priinfo : priList) {
            if (!StringUtils.isNotEmpty(priinfo.getSimpleName())) continue;
            result.add(priinfo.getSimpleName());
        }
        return result;
    }

    private Map<String, Object> getPriCount(List<PrivilegeReceiveInfoDTO> priList, PrivilegeType privilegeType) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty(priList)) {
            return resultMap;
        }
        for (PrivilegeReceiveInfoDTO priInfo : priList) {
            if (priInfo.getPrivilegeType().intValue() != privilegeType.getValue()) continue;
            resultMap.put("totalValue", priInfo.getTotalValue());
            resultMap.put("availableValue", priInfo.getAvailableValue());
            break;
        }
        return resultMap;
    }
}

