/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.so.gift;

import com.ferret.common.dao.vo.Page;
import com.xunlei.channel.util.UserUtility;
import com.xunlei.niux.center.thirdclient.CardClient;
import com.xunlei.niux.center.util.JsonUtil;
import com.xunlei.niux.center.util.SignUtil;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.client.daijinquan.DaiJinQuanClient;
import com.xunlei.niux.client.util.URLUtil;
import com.xunlei.niux.client.yuanbao.YuanBaoClient;
import com.xunlei.niux.common.exception.NiuExceptionAndCode;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.vip.bo.UserVipBo;
import com.xunlei.niux.data.vip.facade.FacadeFactory;
import com.xunlei.niux.data.vip.vo.UserVip;
import com.xunlei.niux.data.vipgame.vo.CustomerInfo;
import com.xunlei.niux.data.vipgame.vo.GamePayInfo;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.gift.GiftPackage;
import com.xunlei.niux.data.vipgame.vo.gift.GiftPackageGame;
import com.xunlei.niux.data.vipgame.vo.gift.GiftRecord;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class UseGiftPackageSo {
    private static Logger logger = Log.getLogger(UseGiftPackageSo.class.getName());
    private static SimpleDateFormat sdftime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static String daijinquanbizno = EnvPropertyUtil.loadProperty("niux", "daijinquanbizno_niuxgift");
    private static String daijinquanbizpwd = EnvPropertyUtil.loadProperty("niux", "daijinquanbizpwd_niuxgift");
    private static String roleQuerykey = "Bk17dES88ApSJwsO";

    public static void useGift(long recordId, String userId, String gameId, String serverId, String roleId, String xunleiVipType, String serverName) throws NiuExceptionAndCode {
        GiftRecord useRecord = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(GiftRecord.class, recordId);
        if (useRecord == null) {
            throw new NiuExceptionAndCode("3007", "\u6ca1\u6709\u83b7\u5f97\u5bf9\u5e94\u7684\u793c\u5305[" + recordId + "]");
        }
        if (!userId.equals(useRecord.getUserId())) {
            throw new NiuExceptionAndCode("3007", "\u5bf9\u5e94\u7684\u793c\u5305[" + userId + "]\u4e0e\u7528\u6237\u4e0d\u5339\u914d");
        }
        if (!useRecord.getGiftStatus().equals("WAIT")) {
            throw new NiuExceptionAndCode("3011", "\u5bf9\u5e94\u7684\u793c\u5305[" + userId + "]\u5df2\u7ecf\u4f7f\u7528");
        }
        Gift gift = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, useRecord.getGiftId());
        if (!gift.getGiftType().equals("niuxgift")) {
            throw new NiuExceptionAndCode("99", "\u975e\u793c\u5305\u8bb0\u5f55[" + recordId + "]");
        }
        GiftPackage giftPackage = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(GiftPackage.class, gift.getGiftLot());
        if (giftPackage == null) {
            throw new NiuExceptionAndCode("3000", "\u793c\u5305[" + gift.getGiftLot() + "]\u4e0d\u5b58\u5728");
        }
        if (!giftPackage.getIsValid().booleanValue()) {
            throw new NiuExceptionAndCode("3001", "\u793c\u5305[" + giftPackage.getPackageId() + "]\u5df2\u65e0\u6548");
        }
        if (giftPackage.getMinJinKaLevelNum() > 0 && UseGiftPackageSo.getJinKaLevelNum(Long.valueOf(useRecord.getUserId())) < giftPackage.getMinJinKaLevelNum()) {
            throw new NiuExceptionAndCode("3008", "\u91d1\u5361\u7b49\u7ea7\u4e0d\u591f");
        }
        useRecord.setXunleiVipType(xunleiVipType);
        if (giftPackage.getIsGamePackage().booleanValue()) {
            boolean isNeedSelectRole;
            if (giftPackage.getInheritParentGameServerType().equals("NOT")) {
                useRecord.setGameId(gameId);
                useRecord.setServerId(serverId);
                useRecord.setServerName(serverName);
                useRecord.setRoleId(roleId);
            } else if (giftPackage.getInheritParentGameServerType().equals("GAME")) {
                useRecord.setServerId(serverId);
                useRecord.setServerName(serverName);
                useRecord.setRoleId(roleId);
            }
            if (useRecord.getGameId() == null || "".equals(useRecord.getGameId())) {
                throw new NiuExceptionAndCode("3002", "\u793c\u5305[" + giftPackage.getPackageId() + "]\u672a\u6307\u5b9a\u6e38\u620f\u4f7f\u7528");
            }
            GiftPackageGame giftGame = UseGiftPackageSo.getGiftPackageGame(giftPackage.getPackageId(), useRecord.getGameId());
            if (giftGame == null) {
                throw new NiuExceptionAndCode("3003", "\u793c\u5305[" + giftPackage.getPackageId() + "]\u6307\u5b9a\u7684\u6e38\u620f\u65e0\u6548");
            }
            GamePayInfo getGamePayInfo = UseGiftPackageSo.getGamePayInfo(giftGame.getGameId());
            boolean isNeedSelectServer = getGamePayInfo == null || getGamePayInfo.getFormType().contains("s");
            boolean bl = isNeedSelectRole = getGamePayInfo == null || getGamePayInfo.getFormType().contains("r");
            if (isNeedSelectServer && "".equals(useRecord.getServerId())) {
                throw new NiuExceptionAndCode("3004", "\u793c\u5305[" + giftPackage.getPackageId() + "]\u672a\u6307\u5b9a\u533a\u670d\u4f7f\u7528");
            }
            if (isNeedSelectRole && "".equals(useRecord.getRoleId())) {
                throw new NiuExceptionAndCode("3005", "\u793c\u5305[" + giftPackage.getPackageId() + "]\u672a\u6307\u5b9a\u89d2\u8272\u4f7f\u7528");
            }
            if (giftGame.getIsNeedBindMobile().booleanValue()) {
                String mobile = UseGiftPackageSo.getBindMobile(useRecord.getUserId());
                if ("".equals(mobile)) {
                    throw new NiuExceptionAndCode("3009", "\u793c\u5305[" + giftPackage.getPackageId() + "]\u672a\u7ed1\u5b9a\u624b\u673a");
                }
                GiftRecord tq = new GiftRecord();
                tq.setMobile(mobile);
                tq.setGiftId(gift.getGiftId());
                if (com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().countObject(tq) > 0) {
                    throw new NiuExceptionAndCode("3012", "\u793c\u5305[" + giftPackage.getPackageId() + "]\u7ed1\u5b9a\u7684\u624b\u673a\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u4f7f\u7528");
                }
                useRecord.setMobile(mobile);
            }
            if (giftGame.getMinRoleLevelNum() > 0 && UseGiftPackageSo.getRoleNum(useRecord.getUserId(), useRecord.getGameId(), useRecord.getServerId(), useRecord.getRoleId()) < giftGame.getMinRoleLevelNum()) {
                throw new NiuExceptionAndCode("3010", "\u793c\u5305[" + giftPackage.getPackageId() + "]\u89d2\u8272\u7b49\u7ea7\u4e0d\u591f");
            }
        }
        com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getUseGiftPackageBo().userGiftPackage(useRecord);
    }

    public static void userPackageDetail(long parentRecordId) {
        GiftRecord query = new GiftRecord();
        query.setParentRecordId(parentRecordId);
        List<GiftRecord> childGRList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
        for (int i = 0; i < childGRList.size(); ++i) {
            GiftRecord childGR = childGRList.get(0);
            Gift gift = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, childGR.getGiftId());
            if (gift.getGiftType().equals("niuxgift") || !childGR.getGiftStatus().equals("WAIT")) continue;
            UseGiftPackageSo.userPackageDetail(childGR, gift);
        }
    }

    private static void userPackageDetail(GiftRecord childGR, Gift gift) {
        try {
            if (gift.getIsGameGift().booleanValue() && (childGR.getGameId() == null || childGR.getGameId().equals(""))) {
                throw new RuntimeException("\u6e38\u620f\u4e3a\u7a7a");
            }
            if (gift.getGiftType().equals("yuanbao")) {
                boolean isNeedSelectRole;
                GamePayInfo getGamePayInfo = UseGiftPackageSo.getGamePayInfo(gift.getGameId());
                boolean isNeedSelectServer = getGamePayInfo == null || getGamePayInfo.getFormType().contains("s");
                boolean bl = isNeedSelectRole = getGamePayInfo == null || getGamePayInfo.getFormType().contains("r");
                if (isNeedSelectRole && (childGR.getRoleId() == null || "".equals(childGR.getRoleId()))) {
                    throw new RuntimeException("RoleId\u4e3a\u7a7a");
                }
                if (isNeedSelectServer && (childGR.getServerId() == null || "".equals(childGR.getServerId()))) {
                    throw new RuntimeException("serverId\u4e3a\u7a7a");
                }
            }
            if (gift.getGiftType().equals("gift") && (childGR.getServerId() == null || "".equals(childGR.getServerId()))) {
                childGR.setServerId("1");
            }
            if (gift.getGiftType().equals("yuanbao")) {
                String userName = UserUtility.getUserNameByUserId(childGR.getUserId());
                YuanBaoClient.giveOutYuanBao(userName, childGR.getGameId(), childGR.getServerId(), childGR.getRecordId() + "_giftrecord", childGR.getActNo(), (int)(childGR.getGiftNum() * gift.getProductUnitPrice()), childGR.getRoleId());
            } else if ("cash".equals(gift.getGiftType())) {
                DaiJinQuanClient.giveOut(childGR.getUserId(), childGR.getRecordId() + "_giftrecord", gift.getGiftType(), (long)(gift.getProductUnitPrice() * 100.0), daijinquanbizno, daijinquanbizpwd);
            } else if ("gift".equals(gift.getGiftType())) {
                String gameId = childGR.getGameId();
                gameId = gameId.length() > 5 ? gameId.substring(gameId.length() - 5) : gameId;
                String userName = UserUtility.getUserNameByUserId(childGR.getUserId());
                String tempserialNum = CardClient.getCardCode22(gameId, childGR.getServerId(), gift.getGiftType(), gift.getGiftLot(), Long.valueOf(childGR.getUserId()), userName, true);
                if (StringUtil.isEmpty(tempserialNum)) {
                    throw new Exception("\u793c\u5305\u83b7\u53d6\u5931\u8d25");
                }
                childGR.setSerialNumber(tempserialNum);
            } else {
                throw new Exception("\u672a\u77e5\u7c7b\u578b");
            }
            childGR.setGiftStatus("SUCCESS");
        }
        catch (NiuRuntimeException e) {
            childGR.setGiftStatus("FAIL");
            childGR.setFailCause(e.code + "-" + e.getMessage());
            logger.error("\u793c\u5305\u4f7f\u7528\u660e\u7ec6[" + childGR.getRecordId() + "]\u4f7f\u7528\u5931\u8d25", e);
        }
        catch (Exception e) {
            childGR.setGiftStatus("FAIL");
            childGR.setFailCause(e.getMessage());
            logger.error("\u793c\u5305\u4f7f\u7528\u660e\u7ec6[" + childGR.getRecordId() + "]\u4f7f\u7528\u5931\u8d25", e);
        }
        childGR.setDealTime(sdftime.format(new Date()));
        com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().updateObjectById(childGR);
    }

    private static GiftPackageGame getGiftPackageGame(long packageId, String gameId) {
        GiftPackageGame query = new GiftPackageGame();
        query.setGameId(gameId);
        query.setPackageId(packageId);
        return com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObject(query);
    }

    private static int getJinKaLevelNum(long userId) {
        UserVipBo userVipBo = FacadeFactory.INSTANCE.getUserVipBo();
        UserVip userVip = userVipBo.find(userId);
        return userVip == null ? 0 : userVip.getVipLervelNum();
    }

    private static String getBindMobile(String userId) {
        CustomerInfo query = new CustomerInfo();
        query.setUid(userId);
        CustomerInfo customer = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        return customer == null || customer.getPhone() == null ? "" : customer.getPhone();
    }

    private static int getRoleNum(String userId, String gameId, String serverId, String roleId) {
        String sign = SignUtil.sign(userId + gameId + serverId, roleQuerykey).toLowerCase();
        String url = "http://websvr.niu.xunlei.com/boxQueryGameUserLevel.gameUserInfo?";
        url = url + "gameid=" + gameId;
        url = url + "&serverid=" + serverId;
        url = url + "&userid=" + userId;
        url = url + "&sign=" + sign;
        String resp = URLUtil.get(url);
        Map map = null;
        try {
            map = (Map)JsonUtil.jsonToObject(resp);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89d2\u8272\u7b49\u7ea7\u67e5\u8be2\u5f02\u5e38", e);
        }
        Object status = map.get("statues");
        if (!"0".equals(status.toString())) {
            return 0;
        }
        return Integer.valueOf(map.get("level").toString());
    }

    public static GamePayInfo getGamePayInfo(String gameId) {
        GamePayInfo query = new GamePayInfo();
        query.setGameid(gameId);
        return com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObject(query);
    }

    public static void useBoxGift(long recordId, String userId, String gameId) throws NiuExceptionAndCode {
        GiftRecord useRecord = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(GiftRecord.class, recordId);
        if (useRecord == null) {
            throw new NiuExceptionAndCode("3007", "\u6ca1\u6709\u83b7\u5f97\u5bf9\u5e94\u7684\u793c\u5305[" + recordId + "]");
        }
        if (!userId.equals(useRecord.getUserId())) {
            throw new NiuExceptionAndCode("3007", "\u5bf9\u5e94\u7684\u793c\u5305[" + userId + "]\u4e0e\u7528\u6237\u4e0d\u5339\u914d");
        }
        if (!useRecord.getGiftStatus().equals("WAIT")) {
            throw new NiuExceptionAndCode("3011", "\u5bf9\u5e94\u7684\u793c\u5305[" + userId + "]\u5df2\u7ecf\u4f7f\u7528");
        }
        Gift gift = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, useRecord.getGiftId());
        if (!gift.getGiftType().equals("niuxgift")) {
            throw new NiuExceptionAndCode("99", "\u975e\u793c\u5305\u8bb0\u5f55[" + recordId + "]");
        }
        GiftPackage giftPackage = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(GiftPackage.class, gift.getGiftLot());
        if (giftPackage == null) {
            throw new NiuExceptionAndCode("3000", "\u793c\u5305[" + gift.getGiftLot() + "]\u4e0d\u5b58\u5728");
        }
        if (!giftPackage.getIsValid().booleanValue()) {
            throw new NiuExceptionAndCode("3001", "\u793c\u5305[" + giftPackage.getPackageId() + "]\u5df2\u65e0\u6548");
        }
        if (giftPackage.getIsGamePackage().booleanValue()) {
            useRecord.setGameId(gameId);
            GiftPackageGame giftGame = UseGiftPackageSo.getGiftPackageGame(giftPackage.getPackageId(), useRecord.getGameId());
            if (giftGame == null) {
                throw new NiuExceptionAndCode("3003", "\u793c\u5305[" + giftPackage.getPackageId() + "]\u6307\u5b9a\u7684\u6e38\u620f\u65e0\u6548");
            }
            if (giftGame.getIsNeedBindMobile().booleanValue()) {
                String mobile = UseGiftPackageSo.getBindMobile(useRecord.getUserId());
                if ("".equals(mobile)) {
                    throw new NiuExceptionAndCode("3009", "\u793c\u5305[" + giftPackage.getPackageId() + "]\u672a\u7ed1\u5b9a\u624b\u673a");
                }
                GiftRecord tq = new GiftRecord();
                tq.setMobile(mobile);
                tq.setGiftId(gift.getGiftId());
                if (com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().countObject(tq) > 0) {
                    throw new NiuExceptionAndCode("3012", "\u793c\u5305[" + giftPackage.getPackageId() + "]\u7ed1\u5b9a\u7684\u624b\u673a\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u4f7f\u7528");
                }
                useRecord.setMobile(mobile);
            }
            if (giftGame.getMinRoleLevelNum() > 0 && UseGiftPackageSo.getRoleNum(useRecord.getUserId(), useRecord.getGameId(), useRecord.getServerId(), useRecord.getRoleId()) < giftGame.getMinRoleLevelNum()) {
                throw new NiuExceptionAndCode("3010", "\u793c\u5305[" + giftPackage.getPackageId() + "]\u89d2\u8272\u7b49\u7ea7\u4e0d\u591f");
            }
        }
        com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getUseGiftPackageBo().userGiftPackage(useRecord);
    }

    public static void userBoxPackageDetail(long parentRecordId) {
        GiftRecord query = new GiftRecord();
        query.setParentRecordId(parentRecordId);
        List<GiftRecord> childGRList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
        for (int i = 0; i < childGRList.size(); ++i) {
            GiftRecord childGR = childGRList.get(0);
            Gift gift = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, childGR.getGiftId());
            if (gift.getGiftType().equals("niuxgift") || !childGR.getGiftStatus().equals("WAIT")) continue;
            UseGiftPackageSo.userBoxPackageDetail(childGR, gift);
        }
    }

    private static void userBoxPackageDetail(GiftRecord childGR, Gift gift) {
        try {
            if (gift.getIsGameGift().booleanValue() && (childGR.getGameId() == null || childGR.getGameId().equals(""))) {
                throw new RuntimeException("\u6e38\u620f\u4e3a\u7a7a");
            }
            if (gift.getGiftType().equals("gift") && (childGR.getServerId() == null || "".equals(childGR.getServerId()))) {
                childGR.setServerId("1");
            }
            if (gift.getGiftType().equals("yuanbao")) {
                String userName = UserUtility.getUserNameByUserId(childGR.getUserId());
                YuanBaoClient.giveOutYuanBao(userName, childGR.getGameId(), childGR.getServerId(), childGR.getRecordId() + "_giftrecord", childGR.getActNo(), (int)(childGR.getGiftNum() * gift.getProductUnitPrice()), childGR.getRoleId());
            } else if ("cash".equals(gift.getGiftType())) {
                DaiJinQuanClient.giveOut(childGR.getUserId(), childGR.getRecordId() + "_giftrecord", gift.getGiftType(), (long)(gift.getProductUnitPrice() * 100.0), daijinquanbizno, daijinquanbizpwd);
            } else if ("gift".equals(gift.getGiftType())) {
                String gameId = childGR.getGameId();
                gameId = gameId.length() > 5 ? gameId.substring(gameId.length() - 5) : gameId;
                String userName = UserUtility.getUserNameByUserId(childGR.getUserId());
                userName = userName == null ? childGR.getUserId() : userName;
                String tempserialNum = CardClient.getCardCode22(gameId, childGR.getServerId(), gift.getGiftType(), gift.getGiftLot(), Long.valueOf(childGR.getUserId()), userName, true);
                if (StringUtil.isEmpty(tempserialNum)) {
                    throw new Exception("\u793c\u5305\u83b7\u53d6\u5931\u8d25");
                }
                childGR.setSerialNumber(tempserialNum);
            } else {
                throw new Exception("\u672a\u77e5\u7c7b\u578b");
            }
            childGR.setGiftStatus("SUCCESS");
        }
        catch (NiuRuntimeException e) {
            childGR.setGiftStatus("FAIL");
            childGR.setFailCause(e.code + "-" + e.getMessage());
            logger.error("\u793c\u5305\u4f7f\u7528\u660e\u7ec6[" + childGR.getRecordId() + "]\u4f7f\u7528\u5931\u8d25", e);
        }
        catch (Exception e) {
            childGR.setGiftStatus("FAIL");
            childGR.setFailCause(e.getMessage());
            logger.error("\u793c\u5305\u4f7f\u7528\u660e\u7ec6[" + childGR.getRecordId() + "]\u4f7f\u7528\u5931\u8d25", e);
        }
        childGR.setDealTime(sdftime.format(new Date()));
        com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().updateObjectById(childGR);
    }
}

