/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.so.gift;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xunlei.channel.util.UserUtility;
import com.xunlei.niux.client.bonus.BonusClient;
import com.xunlei.niux.client.card.CardClient;
import com.xunlei.niux.client.daijinquan.NewDaiJinQuanClient;
import com.xunlei.niux.client.jinzuan.JinZuanPayClient;
import com.xunlei.niux.client.qqcoin.QCoinClient;
import com.xunlei.niux.client.util.SignUtil;
import com.xunlei.niux.client.util.StringUtil;
import com.xunlei.niux.client.vip.VipClient;
import com.xunlei.niux.client.yuanbao.YuanBaoClient;
import com.xunlei.niux.common.exception.NiuExceptionAndCode;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.FortuneRecord;
import com.xunlei.niux.data.vipgame.vo.GamePayInfo;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.gift.GiftFlow;
import com.xunlei.niux.data.vipgame.vo.gift.GiftPackage;
import com.xunlei.niux.data.vipgame.vo.gift.GiftRecord;
import com.xunlei.niux.data.vipgame.vo.lottery.FreeLotteryChance;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class GiftFlowSo {
    private static Logger logger = Log.getLogger(GiftFlowSo.class);
    private static SimpleDateFormat sdftime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat sdfdate = new SimpleDateFormat("yyyy-MM-dd");

    public static GiftFlow addFlow(GiftFlow p_giftFlow, boolean isReport) throws NiuExceptionAndCode {
        return GiftFlowSo.addFlow(p_giftFlow, isReport, "");
    }

    public static GiftFlow addFlow(GiftFlow p_giftFlow, boolean isReport, String qqAcount) throws NiuExceptionAndCode {
        Gift gift = FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, p_giftFlow.getGiftId());
        if (gift == null || !gift.getIsValid().booleanValue()) {
            throw new NiuRuntimeException("2000", "\u4ea7\u54c1[" + p_giftFlow.getGiftId() + "]\u4e0d\u5b58\u5728\u6216\u8005\u65e0\u6548");
        }
        GiftFlowSo.checkGiftGameInfoValid(gift, p_giftFlow.getGameId(), p_giftFlow.getServerId(), p_giftFlow.getRoleId());
        GiftFlow giftFlow = GiftFlowSo.findGiftFlow(p_giftFlow.getActNo(), p_giftFlow.getThirdOrderNo());
        if (giftFlow == null) {
            giftFlow = new GiftFlow();
            giftFlow.setActNo(p_giftFlow.getActNo());
            giftFlow.setDealTime("");
            giftFlow.setFailCause("");
            giftFlow.setFlowStatus("W");
            giftFlow.setFlowTime(sdftime.format(new Date()));
            giftFlow.setGameId(p_giftFlow.getGameId());
            giftFlow.setGiftId(p_giftFlow.getGiftId());
            giftFlow.setUserId(p_giftFlow.getUserId());
            giftFlow.setThirdOrderNo(p_giftFlow.getThirdOrderNo());
            giftFlow.setServerId(p_giftFlow.getServerId());
            giftFlow.setSerialNum("");
            giftFlow.setRoleId(p_giftFlow.getRoleId());
            giftFlow.setGiftNum(p_giftFlow.getGiftNum());
            giftFlow.setShowLocNo(p_giftFlow.getShowLocNo() == null || "".equals(p_giftFlow.getShowLocNo()) ? "myproduct" : p_giftFlow.getShowLocNo());
            FacadeFactory.INSTANCE.getBaseSo().addObject(giftFlow);
            giftFlow = GiftFlowSo.findGiftFlow(p_giftFlow.getActNo(), p_giftFlow.getThirdOrderNo());
        }
        if ("W".equals(giftFlow.getFlowStatus()) || "F".equals(giftFlow.getFlowStatus())) {
            giftFlow = GiftFlowSo.dealGift(giftFlow, gift, qqAcount);
        }
        if ("niuxgift".equals(gift.getGiftType())) {
            isReport = false;
        }
        if ("S".equals(giftFlow.getFlowStatus()) && isReport) {
            GiftRecord giftRecord = new GiftRecord();
            giftRecord.setGiftId(gift.getGiftId());
            giftRecord.setUserId(giftFlow.getUserId());
            giftRecord.setActNo(giftFlow.getActNo());
            giftRecord.setDealTime(giftFlow.getDealTime());
            giftRecord.setExpireDate("");
            giftRecord.setFailCause("");
            giftRecord.setGameId(giftFlow.getGameId());
            giftRecord.setGiftNum((double)giftFlow.getGiftNum().intValue() * 1.0);
            giftRecord.setGiftStatus("SUCCESS");
            giftRecord.setIsShow(true);
            giftRecord.setMobile("");
            giftRecord.setParentRecordId(0L);
            giftRecord.setRecordTime(giftFlow.getDealTime());
            giftRecord.setRoleId(giftFlow.getRoleId());
            giftRecord.setSerialNumber(giftFlow.getSerialNum());
            giftRecord.setServerId(giftFlow.getServerId());
            giftRecord.setThirdRecordId(giftFlow.getThirdOrderNo());
            giftRecord.setXunleiVipType("UNKOWN");
            giftRecord.setShowLocNo(StringUtils.isEmpty(giftFlow.getShowLocNo()) ? "myproduct" : giftFlow.getShowLocNo());
            FacadeFactory.INSTANCE.getBaseSo().addObject(giftRecord);
        }
        return giftFlow;
    }

    private static GiftFlow dealGift(GiftFlow giftFlow, Gift gift, String qqAcount) {
        try {
            if (gift.getGiftType().equals("yuanbao")) {
                String userName = UserUtility.getUserNameByUserId(giftFlow.getUserId());
                YuanBaoClient.giveOutYuanBao(userName, giftFlow.getGameId(), giftFlow.getServerId(), giftFlow.getThirdOrderNo(), giftFlow.getActNo(), (int)((double)giftFlow.getGiftNum().intValue() * gift.getProductUnitPrice()), giftFlow.getRoleId());
            } else if ("cash".equals(gift.getGiftType())) {
                NewDaiJinQuanClient.giveOut(giftFlow.getActNo(), giftFlow.getUserId(), giftFlow.getFlowId() + "_giftflow" + SignUtil.sign(giftFlow.getThirdOrderNo(), giftFlow.getUserId()).substring(0, 5), gift.getGiftType(), (long)(gift.getProductUnitPrice() * 100.0));
            } else if ("bonus".equals(gift.getGiftType())) {
                String userName = UserUtility.getUserNameByUserId(giftFlow.getUserId());
                BonusClient.recharge(giftFlow.getUserId(), userName, (int)(gift.getProductUnitPrice() * (double)giftFlow.getGiftNum().intValue()), giftFlow.getFlowId() + "_giftflow" + SignUtil.sign(giftFlow.getThirdOrderNo(), giftFlow.getUserId()).substring(0, 5), sdfdate.format(new Date()), giftFlow.getActNo());
            } else if ("niuxgift".equals(gift.getGiftType())) {
                GiftPackage giftPackage = FacadeFactory.INSTANCE.getBaseSo().findById(GiftPackage.class, gift.getGiftLot());
                if (giftPackage == null) {
                    throw new RuntimeException("\u6ca1\u6709\u914d\u7f6e\u793c\u5305\u4fe1\u606f\uff01");
                }
                GiftRecord giftRecord = new GiftRecord();
                giftRecord.setGiftId(gift.getGiftId());
                giftRecord.setUserId(giftFlow.getUserId());
                giftRecord.setActNo(giftFlow.getActNo());
                giftRecord.setDealTime(giftFlow.getDealTime());
                giftRecord.setExpireDate(GiftFlowSo.calExpireDate(giftPackage.getExpireDays()));
                giftRecord.setFailCause("");
                giftRecord.setGameId(giftFlow.getGameId());
                giftRecord.setGiftNum(1.0);
                giftRecord.setGiftStatus("WAIT");
                giftRecord.setIsShow(true);
                giftRecord.setMobile("");
                giftRecord.setParentRecordId(0L);
                giftRecord.setRecordTime(giftFlow.getDealTime());
                giftRecord.setRoleId(giftFlow.getRoleId());
                giftRecord.setSerialNumber(giftFlow.getSerialNum());
                giftRecord.setServerId(giftFlow.getServerId());
                giftRecord.setThirdRecordId(giftFlow.getThirdOrderNo());
                giftRecord.setXunleiVipType("UNKOWN");
                giftRecord.setShowLocNo(StringUtils.isEmpty(giftFlow.getShowLocNo()) ? "myproduct" : giftFlow.getShowLocNo());
                FacadeFactory.INSTANCE.getUseGiftPackageBo().addGiftPackageDetail(giftRecord);
            } else if ("fortune".equals(gift.getGiftType())) {
                FortuneRecord fortuneRecord = new FortuneRecord();
                fortuneRecord.setActNo(giftFlow.getActNo());
                fortuneRecord.setFortunePoint(gift.getProductUnitPrice().longValue());
                fortuneRecord.setRecordType("ADD");
                fortuneRecord.setThirdOrderNo(giftFlow.getThirdOrderNo());
                fortuneRecord.setUserId(giftFlow.getUserId());
                FacadeFactory.INSTANCE.getFortuneBo().addFortuneRecord(fortuneRecord);
            } else if ("gift".equals(gift.getGiftType())) {
                String gameId = giftFlow.getGameId();
                gameId = gameId.length() > 5 ? gameId.substring(gameId.length() - 5) : gameId;
                String userName = UserUtility.getUserNameByUserId(giftFlow.getUserId());
                String tempserialNum = CardClient.getCardCode22(gameId, giftFlow.getServerId(), gift.getGiftType(), gift.getGiftLot(), Long.valueOf(giftFlow.getUserId()), userName, true);
                if (StringUtil.isEmpty(tempserialNum, new String[0])) {
                    throw new Exception("\u793c\u5305\u83b7\u53d6\u5931\u8d25");
                }
                giftFlow.setSerialNum(tempserialNum);
            } else if ("bjtyhy".equals(gift.getGiftType())) {
                VipClient.rechargeBaiJinVipByDay(giftFlow.getUserId(), gift.getProductUnitPrice().intValue(), giftFlow.getFlowId() + "_gf", giftFlow.getActNo());
            } else if ("baijinvip".equals(gift.getGiftType())) {
                VipClient.rechargeBaiJinVipByMonth(giftFlow.getUserId(), gift.getProductUnitPrice().intValue(), giftFlow.getFlowId() + "_gf", giftFlow.getActNo());
            } else if (!"product".equals(gift.getGiftType())) {
                if ("lotterychance".equals(gift.getGiftType())) {
                    FreeLotteryChance lotteryChance = new FreeLotteryChance();
                    lotteryChance.setActNo(giftFlow.getActNo());
                    lotteryChance.setUserId(Long.parseLong(giftFlow.getUserId()));
                    lotteryChance.setUsedFlag(false);
                    lotteryChance.setSourceFrom(giftFlow.getActNo() + " release Gift");
                    lotteryChance.setRecordTime(sdftime.format(new Date()));
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(1, 1);
                    lotteryChance.setExpiredDate(sdfdate.format(calendar.getTime()));
                    FacadeFactory.INSTANCE.getBaseSo().addObject(lotteryChance);
                } else if ("jinzuanvip".equals(gift.getGiftType())) {
                    GiftFlowSo.releaseJinZuanVip(giftFlow, gift);
                } else if ("QCoin".equals(gift.getGiftType())) {
                    GiftFlowSo.releaseQCoin(giftFlow, gift, qqAcount);
                } else {
                    throw new RuntimeException("\u975e\u6cd5gift\u7c7b\u578b");
                }
            }
            giftFlow.setFlowStatus("S");
            if (StringUtils.isNotEmpty(giftFlow.getFailCause())) {
                giftFlow.setFailCause("");
            }
        }
        catch (Exception e) {
            logger.error("dealGift ERROR: ", e);
            giftFlow.setFailCause(e.toString());
            giftFlow.setFlowStatus("F");
        }
        giftFlow.setDealTime(sdftime.format(new Date()));
        FacadeFactory.INSTANCE.getBaseSo().updateObjectById(giftFlow);
        return giftFlow;
    }

    private static void releaseJinZuanVip(GiftFlow giftFlow, Gift gift) {
        String actNo = giftFlow.getActNo();
        String userId = giftFlow.getUserId();
        int timeType = 2;
        if ("\u65e5".equals(gift.getProductUnit())) {
            timeType = 1;
        } else if ("\u6708".equals(gift.getProductUnit())) {
            timeType = 2;
        } else if ("\u5e74".equals(gift.getProductUnit())) {
            timeType = 3;
        }
        int numValue = gift.getProductUnitPrice().intValue();
        if (numValue <= 0) {
            logger.error("releaseJinZuanVip numValue:{} is invalid", numValue);
            throw new RuntimeException("releaseJinZuanVip numValue:" + numValue + " is invalid");
        }
        String resp = JinZuanPayClient.FreeCharge(actNo, Long.parseLong(userId), timeType, numValue);
        logger.info("JinZuanPayClient.FreeCharge response: " + resp);
        JsonObject resultJson = new JsonParser().parse(resp).getAsJsonObject();
        int code = resultJson.get("rtn").getAsInt();
        if (code != 0) {
            String msg = resultJson.get("data").getAsString();
            logger.error("\u91d1\u94bb\u5145\u503c\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + msg);
            throw new RuntimeException("\u91d1\u94bb\u5145\u503c\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + msg);
        }
    }

    private static void releaseQCoin(GiftFlow giftFlow, Gift gift, String qqAcount) {
        String userId;
        String userName;
        int bugAmount;
        if (StringUtils.isEmpty(qqAcount)) {
            logger.error("\u53d1\u653eQ\u5e01\u5931\u8d25\uff0c\u539f\u56e0\uff1aqqAcount\u4e3a\u7a7a");
            throw new RuntimeException("\u53d1\u653eQ\u5e01\u5931\u8d25\uff0c\u539f\u56e0\uff1aqqAcount\u4e3a\u7a7a");
        }
        String actNo = giftFlow.getActNo();
        String resp = QCoinClient.releaseQQCoin(actNo, bugAmount = gift.getProductUnitPrice().intValue(), qqAcount, userName = UserUtility.getUserNameByUserId(userId = giftFlow.getUserId()), userId);
        JsonObject resultJson = new JsonParser().parse(resp).getAsJsonObject();
        int code = resultJson.get("rtn").getAsInt();
        if (code != 0) {
            String msg = resultJson.get("rtnMsg").getAsString();
            logger.error("Q\u5e01\u5145\u503c\u5931\u8d25\uff0c\u5145\u503c\u9519\u8bef\u7801\uff1a" + msg);
            throw new RuntimeException("Q\u5e01\u5145\u503c\u5931\u8d25\uff0c\u5145\u503c\u9519\u8bef\u7801\uff1a" + msg);
        }
    }

    private static GiftFlow findGiftFlow(String actNo, String thirdOrderNo) {
        GiftFlow query = new GiftFlow();
        query.setActNo(actNo);
        query.setThirdOrderNo(thirdOrderNo);
        return FacadeFactory.INSTANCE.getBaseSo().findObject(query);
    }

    private static String calExpireDate(int days) {
        long now = System.currentTimeMillis();
        long expiretime = now + 86400000L * (long)days;
        return sdfdate.format(new Date(expiretime));
    }

    private static void checkGiftGameInfoValid(Gift gift, String gameId, String serverId, String roleId) throws NiuExceptionAndCode {
        boolean isNeedSelectRole;
        if (!gift.getIsGameGift().booleanValue()) {
            return;
        }
        if ("niuxgift".equals(gift.getGiftType())) {
            return;
        }
        if ("".equals(gameId)) {
            throw new NiuExceptionAndCode("2004", "\u6e38\u620f\u4e3a\u7a7a");
        }
        if (!"".equals(gift.getGameId()) && gameId.equals(gift.getGameId())) {
            throw new NiuExceptionAndCode("2004", "\u6e38\u620f\u4e0d\u4e00\u81f4");
        }
        GamePayInfo getGamePayInfo = GiftFlowSo.getGamePayInfo(gift.getGameId());
        boolean isNeedSelectServer = getGamePayInfo == null || getGamePayInfo.getFormType().contains("s");
        boolean bl = isNeedSelectRole = getGamePayInfo == null || getGamePayInfo.getFormType().contains("r");
        if (isNeedSelectServer && "".equals(serverId)) {
            throw new NiuExceptionAndCode("2005", "\u533a\u670d\u4e3a\u7a7a");
        }
        if (isNeedSelectRole && "".equals(roleId)) {
            throw new NiuExceptionAndCode("2006", "\u89d2\u8272\u4e3a\u7a7a");
        }
    }

    private static GamePayInfo getGamePayInfo(String gameId) {
        GamePayInfo query = new GamePayInfo();
        query.setGameid(gameId);
        return FacadeFactory.INSTANCE.getBaseSo().findObject(query);
    }
}

