/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.so.bonus;

import com.xunlei.channel.util.UserUtility;
import com.xunlei.channel.vo.VIPInfo;
import com.xunlei.niux.center.thirdclient.BonusClient;
import com.xunlei.niux.center.thirdclient.CardClient;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.client.daijinquan.DaiJinQuanClient;
import com.xunlei.niux.client.gameinfo.UserGameLevelQuery;
import com.xunlei.niux.client.xiaojinku.GiveOutVip;
import com.xunlei.niux.client.xiubi.XiuBiClient;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.vipgame.bt.bonus.BonusProductBT;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import com.xunlei.niux.data.vipgame.vo.bonus.ExchangeTrans;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;

public class ExchangeTransSo {
    private static Logger logger = Log.getLogger(ExchangeTransSo.class.getName());
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static String daijinquanbizno = EnvPropertyUtil.loadProperty("niux", "daijinquanbizno");
    private static String daijinquanbizpwd = EnvPropertyUtil.loadProperty("niux", "daijinquanbizpwd");
    public String userId;
    public String userName;
    public String productNo;
    public String serverId;
    public String gameId;
    private int productNum;
    private long bonusNum;
    public boolean isOldTrans = false;
    public boolean isbackserialnum = false;
    public String serialnum = "";
    private String errorCode = "";
    public String sessionId = "";

    public void exchange() {
        BonusProduct bonusProduct = BonusProductBT.checkProductEnoughExchange(this.productNo);
        BonusProductBT.checkProductDayEnough(bonusProduct.getProductNo(), sdf.format(new Date()), bonusProduct.getEverydayMaxNum());
        this.productNum = "serialnum".equals(bonusProduct.getExchangeType()) ? 1 : bonusProduct.getBaseUnitNum();
        this.bonusNum = this.calBonusNum(bonusProduct, this.productNum);
        BonusClient.checkBonusEnough(this.userId, (int)this.bonusNum);
        this.checkGameLevel(this.sessionId, this.userName, this.gameId, this.serverId, bonusProduct);
        ExchangeTrans trans = this.initExchangeTrans(bonusProduct);
        trans = FacadeFactory.INSTANCE.getExchangeTransBo().insert(trans);
        this.isOldTrans = trans.getSeqId() != null && trans.getSeqId() != 0L;
        this.checkOldTransStop(this.isOldTrans, trans);
        trans = this.cosumeBonus(trans);
        trans = this.giveOutProduct(trans);
        trans = this.returnBonus(trans);
        trans = this.checkSuccess(trans);
        this.isbackserialnum = "2".equals(trans.getExchangeDirect());
        this.serialnum = trans.getSerialNumber();
    }

    public void checkOldTransStop(boolean isOldTrans, ExchangeTrans trans) {
        if (!isOldTrans) {
            return;
        }
        if ("2".equals(trans.getExchangeStatus()) || "3".equals(trans.getExchangeStatus())) {
            return;
        }
        throw new NiuRuntimeException("1032", "\u6709\u8ba2\u5355\u6b63\u5728\u5904\u7406\uff0c\u8bf7\u7a0d\u540e\u5728\u63d0\u4ea4");
    }

    private long calBonusNum(BonusProduct bonusProduct, int productNum) {
        VIPInfo vipInfo = UserUtility.getVIPInfoByUserId(this.userId);
        return "1".equals(vipInfo.getIsVIP()) ? bonusProduct.getVipPrice() : bonusProduct.getPrice();
    }

    public ExchangeTrans initExchangeTrans(BonusProduct bonusProduct) {
        ExchangeTrans trans = new ExchangeTrans();
        trans.setUserId(this.userId);
        trans.setUserName(this.userName);
        trans.setServerId(this.serverId);
        trans.setBonusNum((int)this.bonusNum);
        trans.setProductNum(this.productNum);
        trans.setProductNo(this.productNo);
        return trans;
    }

    public ExchangeTrans cosumeBonus(ExchangeTrans pTrans) {
        if (!"0".equals(pTrans.getExchangeStatus())) {
            return pTrans;
        }
        String code = BonusClient.consume(pTrans.getUserId(), pTrans.getUserName(), pTrans.getBonusNum(), pTrans.getExchangeNo(), pTrans.getBalanceDate(), "nxjifenduihuan", pTrans.getGameId());
        boolean flag = "00".equals(code);
        ExchangeTrans trans = FacadeFactory.INSTANCE.getExchangeTransBo().updateBonusConsumeStatus(pTrans, flag);
        if (flag) {
            return trans;
        }
        throw new NiuRuntimeException(code, "\u79ef\u5206\u6263\u9664\u5931\u8d25");
    }

    public ExchangeTrans giveOutProduct(ExchangeTrans pTrans) {
        boolean flag;
        block8: {
            if (!"1".equals(pTrans.getExchangeStatus())) {
                return pTrans;
            }
            flag = true;
            try {
                if ("1".equals(pTrans.getExchangeDirect())) {
                    GiveOutVip.giveOut(Long.valueOf(pTrans.getUserId()), pTrans.getExchangeNo(), pTrans.getProductType(), pTrans.getProductNum());
                    break block8;
                }
                if ("2".equals(pTrans.getExchangeDirect())) {
                    String gameId = pTrans.getGameId();
                    gameId = gameId.length() > 5 ? gameId.substring(gameId.length() - 5) : gameId;
                    String tempserialNum = CardClient.getCardCode22(gameId, pTrans.getServerId(), pTrans.getProductType(), pTrans.getProductLot(), Long.valueOf(pTrans.getUserId()), pTrans.getUserName(), true);
                    pTrans.setSerialNumber(tempserialNum);
                    flag = !StringUtil.isEmpty(tempserialNum);
                    break block8;
                }
                if ("3".equals(pTrans.getExchangeDirect())) {
                    DaiJinQuanClient.giveOut(pTrans.getUserId(), pTrans.getExchangeNo(), pTrans.getProductType(), pTrans.getProductNum().intValue(), daijinquanbizno, daijinquanbizpwd);
                    break block8;
                }
                if ("4".equals(pTrans.getExchangeDirect())) {
                    XiuBiClient.giveXiuBi(Long.valueOf(pTrans.getUserId()));
                    break block8;
                }
                throw new RuntimeException("\u672a\u77e5\u4ea4\u6613\u65b9\u5411");
            }
            catch (NiuRuntimeException e) {
                flag = false;
                this.errorCode = e.code;
                logger.error("\u8ba2\u5355[" + pTrans.getExchangeNo() + "]\u53d1\u9001\u4ea7\u54c1\u51fa\u73b0\u5f02\u5e38", e);
            }
            catch (Exception e) {
                flag = false;
                logger.error("\u8ba2\u5355[" + pTrans.getExchangeNo() + "]\u53d1\u9001\u4ea7\u54c1\u51fa\u73b0\u5f02\u5e38", e);
            }
        }
        return FacadeFactory.INSTANCE.getExchangeTransBo().updateProductGiveOutStatus(pTrans, flag);
    }

    public ExchangeTrans returnBonus(ExchangeTrans pTrans) {
        if (!"4".equals(pTrans.getExchangeStatus())) {
            return pTrans;
        }
        if (!"1".equals(pTrans.getBonusConsumeStatus())) {
            return pTrans;
        }
        try {
            BonusClient.returnconsume(pTrans.getUserId(), pTrans.getBonusNum(), pTrans.getExchangeNo(), pTrans.getBalanceDate(), "nxjifenduihuan", pTrans.getGameId());
            return FacadeFactory.INSTANCE.getExchangeTransBo().updateBonusReturnSuccess(pTrans);
        }
        catch (Exception e) {
            logger.error("\u8ba2\u5355[" + pTrans.getExchangeNo() + "]\u9000\u8fd8\u79ef\u5206\u5931\u8d25", e);
            return pTrans;
        }
    }

    private ExchangeTrans checkSuccess(ExchangeTrans pTrans) {
        if (this.errorCode != null && !"".equals(this.errorCode) && !"99".equals(this.errorCode)) {
            throw new NiuRuntimeException(this.errorCode, "\u9886\u53d6\u5931\u8d25");
        }
        if ("2".equals(pTrans.getExchangeStatus())) {
            return pTrans;
        }
        if ("4".equals(pTrans.getExchangeStatus())) {
            throw new NiuRuntimeException("02", "\u9886\u53d6\u5931\u8d25\uff01\u6263\u9664\u79ef\u5206\u540e\u7eed\u4f1a\u9000\u8fd8\uff01");
        }
        if ("3".equals(pTrans.getExchangeStatus()) && "3".equals(pTrans.getBonusConsumeStatus())) {
            throw new NiuRuntimeException("03", "\u9886\u53d6\u5931\u8d25\uff01\u6263\u9664\u79ef\u5206\u5df2\u9000\u8fd8\uff01");
        }
        if ("1".equals(pTrans.getExchangeStatus())) {
            throw new NiuRuntimeException("04", "\u9886\u53d6\u7684\u5956\u54c1\u6b63\u5728\u53d1\u653e\u4e2d");
        }
        throw new NiuRuntimeException("99", "\u672a\u77e5\u9519\u8bef");
    }

    private void checkGameLevel(String sessionId, String userName, String gameId, String serverId, BonusProduct bp) {
        if (bp.getMinGameLevel() == null || bp.getMinGameLevel() <= 0) {
            logger.debug(userName + "\u4e0d\u9650\u7b49\u7ea7");
            return;
        }
        int minLevel = UserGameLevelQuery.queryUserGameLevel(sessionId, userName, gameId, serverId);
        if (minLevel < bp.getMinGameLevel()) {
            throw new NiuRuntimeException("1031", "\u7b49\u7ea7\u4e0d\u591f");
        }
        logger.debug(userName + "\u7b49\u7ea7" + minLevel);
    }
}

