/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.so.bonus;

import com.xunlei.channel.util.UserUtility;
import com.xunlei.channel.vo.VIPInfo;
import com.xunlei.niux.center.enums.MemberShipType;
import com.xunlei.niux.center.thirdclient.BonusClient;
import com.xunlei.niux.center.thirdclient.CardClient;
import com.xunlei.niux.center.thirdclient.vip.VipClient;
import com.xunlei.niux.center.util.LogReportUtil;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.client.chouma.ChouMaClient;
import com.xunlei.niux.client.daijinquan.DaiJinQuanClient;
import com.xunlei.niux.client.gameinfo.UserGameLevelQuery;
import com.xunlei.niux.client.jinzuan.MemberInfoClient;
import com.xunlei.niux.client.xiubi.XiuBiClient;
import com.xunlei.niux.client.yuanbao.YuanBaoClient;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.vip.bo.UserVipBo;
import com.xunlei.niux.data.vip.facade.FacadeFactory;
import com.xunlei.niux.data.vip.vo.UserVip;
import com.xunlei.niux.data.vipgame.bt.bonus.BonusProductBT;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusExchange;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;

public class ExchangeProductSo {
    private static Logger logger = Log.getLogger(ExchangeProductSo.class.getName());
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static String daijinquanbizno = EnvPropertyUtil.loadProperty("niux", "daijinquanbizno");
    private static String daijinquanbizpwd = EnvPropertyUtil.loadProperty("niux", "daijinquanbizpwd");

    public BonusExchange deal(BonusExchange exchange, String gameLevelServerId, String sessionId, MemberShipType memberType) {
        BonusProduct bonusProduct = BonusProductBT.checkProductEnoughExchange(exchange.getProductNo());
        BonusProductBT.checkProductDayEnough(bonusProduct.getProductNo(), sdf.format(new Date()), bonusProduct.getEverydayMaxNum());
        int productNum = "serialnum".equals(bonusProduct.getExchangeType()) ? 1 : bonusProduct.getBaseUnitNum();
        long bonusNum = this.calBonusNum(bonusProduct, exchange.getUserId());
        if (bonusProduct.getIsQuFenServer() != null && bonusProduct.getIsQuFenServer().booleanValue() && "".equals(exchange.getServerId())) {
            throw new NiuRuntimeException("1057", "\u672a\u9009\u533a");
        }
        if (bonusProduct.getIsQuFenServer().booleanValue() && bonusProduct.getIsSelectRole() != null && bonusProduct.getIsSelectRole().booleanValue() && "".equals(exchange.getRoleId())) {
            throw new NiuRuntimeException("1058", "\u672a\u9009\u89d2\u8272");
        }
        if ("10".equals(bonusProduct.getExchangeDirect()) && exchange.getBonusNum() != null && exchange.getBonusNum() > 0) {
            BonusClient.checkBonusEnough(exchange.getUserId(), (int)bonusNum);
        }
        if (bonusProduct.getMinJinKaLevel() != null && bonusProduct.getMinJinKaLevel() > 0) {
            if (memberType == MemberShipType.JinKa) {
                this.checkJinKaLevel(exchange.getUserId(), bonusProduct);
            } else if (memberType == MemberShipType.JinZuan) {
                this.checkJinZuanLevel(exchange.getUserId(), bonusProduct);
            }
        }
        if (memberType == MemberShipType.JinKa && bonusProduct.getIsNeedBaiJinVip() != null && bonusProduct.getIsNeedBaiJinVip().booleanValue()) {
            this.checkIsBaiJinVip(exchange.getUserId(), sessionId);
        }
        this.checkGameLevel(sessionId, exchange.getUserName(), exchange.getGameId(), gameLevelServerId, bonusProduct);
        BonusExchange bonusexchange = new BonusExchange();
        bonusexchange.setUserId(exchange.getUserId());
        bonusexchange.setUserName(exchange.getUserName());
        bonusexchange.setServerId(exchange.getServerId());
        bonusexchange.setBonusNum((int)bonusNum);
        bonusexchange.setProductNum(productNum);
        bonusexchange.setExchangeIp(exchange.getExchangeIp());
        bonusexchange.setGameId(bonusProduct.getGameId());
        bonusexchange.setExchangeDirect(bonusProduct.getExchangeDirect());
        bonusexchange.setProductNo(exchange.getProductNo());
        bonusexchange.setExchangePlatform(exchange.getExchangePlatform());
        bonusexchange.setRoleId(exchange.getRoleId());
        bonusexchange = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBonusExchangeBo().insert(bonusexchange);
        bonusexchange = this.exchange(bonusexchange);
        return bonusexchange;
    }

    public BonusExchange exchange(BonusExchange bonusExchange) {
        bonusExchange = this.kouChuProduct(bonusExchange);
        bonusExchange = this.giveOutProduct(bonusExchange);
        bonusExchange = this.returnProduct(bonusExchange);
        return bonusExchange;
    }

    private long calBonusNum(BonusProduct bonusProduct, String userId) {
        VIPInfo vipInfo = UserUtility.getVIPInfoByUserId(userId);
        return "1".equals(vipInfo.getIsVIP()) ? bonusProduct.getVipPrice() : bonusProduct.getPrice();
    }

    private void checkGameLevel(String sessionId, String userName, String gameId, String serverId, BonusProduct bp) {
        if (bp.getMinGameLevel() == null || bp.getMinGameLevel() <= 0) {
            return;
        }
        int minLevel = UserGameLevelQuery.queryUserGameLevel(sessionId, userName, gameId, serverId);
        if (minLevel < bp.getMinGameLevel()) {
            throw new NiuRuntimeException("1031", "\u7b49\u7ea7\u4e0d\u591f");
        }
    }

    private BonusExchange kouChuProduct(BonusExchange exchange) {
        boolean isSuccess;
        block8: {
            if (!"0".equals(exchange.getExchangeStatus())) {
                return exchange;
            }
            isSuccess = true;
            String productType = "10".equals(exchange.getExchangeDirect()) ? "bonus" : exchange.getProductType();
            try {
                if ("bonus".equals(productType)) {
                    String code = "00";
                    if (exchange.getBonusNum() > 0) {
                        code = BonusClient.consume(exchange.getUserId(), exchange.getUserName(), exchange.getBonusNum(), exchange.getExchangeNo(), exchange.getBalanceDate(), exchange.getExchangePlatform(), exchange.getGameId());
                    }
                    boolean bl = isSuccess = "00".equals(code);
                    if (!isSuccess) {
                        exchange.setRemark("\u79ef\u5206\u6263\u9664\u5931\u8d25");
                        exchange.setFailCause(code);
                    }
                    break block8;
                }
                if ("chouma".equals(productType)) {
                    ChouMaClient.consumeChip(exchange.getUserId(), exchange.getProductNum());
                    break block8;
                }
                throw new NiuRuntimeException("99", "\u975e\u6cd5\u4ea7\u54c1\u7c7b\u578b[" + productType + "]");
            }
            catch (NiuRuntimeException e) {
                isSuccess = false;
                exchange.setFailCause(e.code);
                exchange.setRemark(e.getMessage());
            }
            catch (Exception e) {
                isSuccess = false;
                exchange.setFailCause("99");
                exchange.setRemark(e.getMessage());
            }
        }
        exchange = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBonusExchangeBo().updateKouChuProductResult(exchange, isSuccess);
        return exchange;
    }

    private BonusExchange giveOutProduct(BonusExchange exchange) {
        boolean isSuccess;
        block12: {
            if (!"1".equals(exchange.getExchangeStatus())) {
                return exchange;
            }
            isSuccess = true;
            String productType = "11".equals(exchange.getExchangeDirect()) ? "bonus" : exchange.getProductType();
            try {
                if ("bonus".equals(productType)) {
                    if (exchange.getBonusNum() > 0) {
                        BonusClient.recharge(exchange.getUserId(), exchange.getUserName(), exchange.getBonusNum(), exchange.getExchangeNo(), exchange.getBalanceDate(), exchange.getExchangePlatform());
                    }
                    break block12;
                }
                if ("gift".equals(productType)) {
                    String gameId = exchange.getGameId();
                    gameId = gameId.length() > 5 ? gameId.substring(gameId.length() - 5) : gameId;
                    String tempserialNum = CardClient.getCardCode22(gameId, exchange.getServerId(), exchange.getProductType(), exchange.getProductLot(), Long.valueOf(exchange.getUserId()), exchange.getUserName(), true);
                    exchange.setSerialNumber(tempserialNum);
                    isSuccess = !StringUtil.isEmpty(tempserialNum);
                    break block12;
                }
                if ("xiubi".equals(productType)) {
                    XiuBiClient.giveXiuBi(Long.valueOf(exchange.getUserId()));
                    break block12;
                }
                if ("cash".equals(productType)) {
                    DaiJinQuanClient.giveOut(exchange.getUserId(), exchange.getExchangeNo(), exchange.getProductType(), exchange.getProductNum().intValue(), daijinquanbizno, daijinquanbizpwd);
                    break block12;
                }
                if ("chouma".equals(productType)) {
                    ChouMaClient.rechargeChip(exchange.getUserId(), exchange.getProductNum());
                    break block12;
                }
                if ("yuanbao".equals(productType)) {
                    YuanBaoClient.giveOutYuanBao(exchange.getUserName(), exchange.getGameId(), exchange.getServerId(), exchange.getExchangeNo(), exchange.getExchangePlatform(), exchange.getProductNum(), exchange.getRoleId());
                    break block12;
                }
                throw new NiuRuntimeException("99", "\u975e\u6cd5\u4ea7\u54c1\u7c7b\u578b[" + productType + "]");
            }
            catch (NiuRuntimeException e) {
                isSuccess = false;
                exchange.setFailCause(e.code);
                exchange.setRemark(e.getMessage());
            }
            catch (Exception e) {
                isSuccess = false;
                exchange.setFailCause("99");
                exchange.setRemark(e.getMessage());
            }
        }
        if (isSuccess) {
            this.writeLog(exchange);
        }
        exchange = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBonusExchangeBo().updateExchangeProductResult(exchange, isSuccess);
        return exchange;
    }

    public BonusExchange returnProduct(BonusExchange exchange) {
        if (!"4".equals(exchange.getExchangeStatus())) {
            return exchange;
        }
        try {
            if (exchange.getBonusNum() > 0) {
                BonusClient.returnconsume(exchange.getUserId(), exchange.getBonusNum(), exchange.getExchangeNo(), exchange.getBalanceDate(), exchange.getExchangePlatform(), exchange.getGameId());
            }
            return com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBonusExchangeBo().updateReturnProductResult(exchange, true);
        }
        catch (Exception e) {
            logger.error("\u8ba2\u5355[" + exchange.getExchangeNo() + "]\u9000\u8fd8\u79ef\u5206\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage());
            return exchange;
        }
    }

    public void checkJinKaLevel(String userId, BonusProduct product) {
        UserVipBo userVipBo = FacadeFactory.INSTANCE.getUserVipBo();
        UserVip userVip = userVipBo.find(Long.parseLong(userId));
        if (userVip == null || userVip.getVipLervelNum() == null || userVip.getVipLervelNum() < product.getMinJinKaLevel()) {
            throw new NiuRuntimeException("1046", "useId[" + userId + "]\u91d1\u5361\u7b49\u7ea7\u4e0d\u591f");
        }
    }

    public void checkJinZuanLevel(String userId, BonusProduct product) {
        int level = MemberInfoClient.getJinZuanLevel(userId);
        if (level < product.getMinJinKaLevel()) {
            throw new NiuRuntimeException("1046", "useId[" + userId + "]\u91d1\u94bb\u7b49\u7ea7\u4e0d\u591f");
        }
    }

    public void writeLog(BonusExchange exchange) {
        LogReportUtil.LogReport logReport = new LogReportUtil.LogReport();
        logReport.actId = exchange.getExchangePlatform();
        logReport.bonusNum = exchange.getBonusNum();
        logReport.gameId = exchange.getGameId();
        logReport.logTime = new Date();
        logReport.productId = exchange.getProductNo();
        logReport.operatorId = "10".equals(exchange.getExchangeDirect()) ? "6" : "7";
        logReport.userId = exchange.getUserId();
        logReport.num1 = 1;
        LogReportUtil.report(logReport);
    }

    private void checkIsBaiJinVip(String uid, String sessionid) {
        try {
            Map<String, String> resultMap = VipClient.getVipInfo(uid, sessionid);
            String vipType = resultMap.get("vas_type");
            vipType = vipType == null ? "" : vipType;
            String isVip = resultMap.get("isvip");
            String string = isVip = isVip == null ? "" : isVip;
            if ("1".equals(isVip)) {
                return;
            }
            if ("2".equals(isVip)) {
                throw new NiuRuntimeException("1048", "userId[" + uid + "]\u8fc5\u96f7\u767d\u91d1\u4f1a\u5458\u5df2\u6682\u505c");
            }
            throw new NiuRuntimeException("1047", "userId[" + uid + "]\u975e\u8fc5\u96f7\u767d\u91d1\u4f1a\u5458");
        }
        catch (NiuRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NiuRuntimeException("1047", "\u67e5\u8be2userId[" + uid + "]\u662f\u5426\u767d\u91d1\u4f1a\u5458\u51fa\u5e2d\u5f02\u5e38");
        }
    }
}

