/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.so.bonus;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.center.thirdclient.BonusClient;
import com.xunlei.niux.center.thirdclient.CardClient;
import com.xunlei.niux.client.chouma.ChouMaClient;
import com.xunlei.niux.client.daijinquan.DaiJinQuanClient;
import com.xunlei.niux.client.xiubi.XiuBiClient;
import com.xunlei.niux.client.yuanbao.YuanBaoClient;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.bonus.AuctionProduct;
import com.xunlei.niux.data.vipgame.vo.bonus.AuctionRecord;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;

public class AuctionRecordSo {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static String daijinquanbizno = EnvPropertyUtil.loadProperty("niux", "daijinquanbizno");
    private static String daijinquanbizpwd = EnvPropertyUtil.loadProperty("niux", "daijinquanbizpwd");
    private static Logger logger = Log.getLogger(AuctionRecordSo.class.getName());

    public void auction(AuctionRecord record) {
        AuctionProduct product = FacadeFactory.INSTANCE.getAuctionProductBo().findOne(record.getAuctionProductId());
        FacadeFactory.INSTANCE.getAuctionRecordBo().checkProductCanAuctionUseTheBonusNum(product, record.getBonusNum());
        this.checkBonusEnoughAuction(record.getUserId(), record.getAuctionProductId(), record.getBonusNum());
        record = FacadeFactory.INSTANCE.getAuctionRecordBo().insertAuctionRecord(record);
        String code = this.consumeBonusAndUpdateResult(record);
        this.returnNotBidAuctionRecord(record.getAuctionProductId());
        if ("00".equals(code)) {
            return;
        }
        throw new NiuRuntimeException(code, "\u7ade\u62cd\u5931\u8d25");
    }

    private void returnNotBidAuctionRecord(long auctionProductId) {
        try {
            AuctionRecord ar = new AuctionRecord();
            ar.setAuctionProductId(auctionProductId);
            ar.setBonusStatus("3");
            Page page = new Page();
            page.setPageNo(1);
            page.setPageSize(100);
            List<AuctionRecord> arList = FacadeFactory.INSTANCE.getAuctionRecordBo().finds(ar, page);
            for (AuctionRecord auctionRecord : arList) {
                this.returnNotBidAuctionRecord(auctionRecord);
            }
        }
        catch (Exception e) {
            logger.error("\u7ade\u62cd\u4ea7\u54c1[" + auctionProductId + "]\u9000\u8fd8\u4e3a\u4e2d\u6807\u7684\u4ea7\u54c1\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    private void returnNotBidAuctionRecord(AuctionRecord auctionRecord) {
        if (auctionRecord == null || !"3".equals(auctionRecord.getBonusStatus())) {
            return;
        }
        try {
            BonusClient.returnconsume(auctionRecord.getUserId(), auctionRecord.getThisBonusNum(), auctionRecord.getAuctionNo(), auctionRecord.getAuctionTime().substring(0, 10), auctionRecord.getActNo(), auctionRecord.getGameId());
            auctionRecord.setBonusStatus("4");
            FacadeFactory.INSTANCE.getAuctionRecordBo().update(auctionRecord);
        }
        catch (Exception e) {
            logger.error("\u7ade\u62cd\u8ba2\u5355[" + auctionRecord.getAuctionNo() + "]\u9000\u5355\u5931\u8d25", e);
        }
    }

    private String consumeBonusAndUpdateResult(AuctionRecord record) {
        String code = "";
        String msg = "";
        try {
            code = BonusClient.consume(record.getUserId(), record.getUserName(), record.getThisBonusNum(), record.getAuctionNo(), record.getAuctionTime().substring(0, 10), record.getActNo(), record.getGameId());
        }
        catch (Exception e) {
            code = "99";
            msg = e.getMessage();
            logger.error("\u7ade\u62cd\u8ba2\u5355[" + record.getAuctionNo() + "]\u6263\u9664\u79ef\u5206\u5931\u8d25", e);
        }
        boolean isSuccess = "00".equals(code);
        FacadeFactory.INSTANCE.getAuctionRecordBo().updateConsumeBonusResult(record.getAuctionNo(), isSuccess, msg);
        return code;
    }

    private void checkBonusEnoughAuction(String userId, long auctionProductId, int bonusNum) {
        AuctionRecord userlateAuctionRecord = FacadeFactory.INSTANCE.getAuctionRecordBo().getUserLastValidAndBiddedAuctionRecord(userId, auctionProductId);
        int lockBonusNum = userlateAuctionRecord == null || userlateAuctionRecord.getBonusNum() == null ? 0 : userlateAuctionRecord.getBonusNum();
        BonusClient.UserBonus userBonus = BonusClient.queryBonus(userId);
        int canAuctionBonusNum = lockBonusNum;
        if (userBonus != null) {
            canAuctionBonusNum += userBonus.getBonusNum().intValue();
        }
        if (bonusNum <= canAuctionBonusNum) {
            return;
        }
        throw new NiuRuntimeException("1054", "\u79ef\u5206\u4e0d\u591f\u7ade\u62cd");
    }

    public static boolean checkAuctionEnd(AuctionProduct product) {
        String now = sdf.format(new Date());
        return now.compareTo(product.getEndAuctionTime()) > 0;
    }

    public static AuctionRecord giveOutProduct(AuctionRecord auctionRecord, AuctionProduct product) {
        String productType = auctionRecord.getProductType();
        if ("gift".equals(productType)) {
            String gameId = auctionRecord.getGameId();
            gameId = gameId.length() > 5 ? gameId.substring(gameId.length() - 5) : gameId;
            String tempserialNum = CardClient.getCardCode22(gameId, auctionRecord.getServerId(), auctionRecord.getProductType(), auctionRecord.getProductLot(), Long.valueOf(auctionRecord.getUserId()), auctionRecord.getUserName(), true);
            auctionRecord.setSerialNum(tempserialNum);
        } else if ("xiubi".equals(productType)) {
            XiuBiClient.giveXiuBi(Long.valueOf(auctionRecord.getUserId()));
        } else if ("cash".equals(productType)) {
            DaiJinQuanClient.giveOut(auctionRecord.getUserId(), auctionRecord.getAuctionNo(), auctionRecord.getProductType(), product.getBaseUnitNum().longValue(), daijinquanbizno, daijinquanbizpwd);
        } else if ("chouma".equals(productType)) {
            ChouMaClient.rechargeChip(auctionRecord.getUserId(), product.getBaseUnitNum().intValue());
        } else if ("yuanbao".equals(productType)) {
            YuanBaoClient.giveOutYuanBao(auctionRecord.getUserName(), auctionRecord.getGameId(), auctionRecord.getServerId(), auctionRecord.getRoleId(), auctionRecord.getAuctionNo(), auctionRecord.getActNo(), product.getBaseUnitNum().intValue());
        } else {
            throw new NiuRuntimeException("99", "\u975e\u6cd5\u4ea7\u54c1\u7c7b\u578b[" + productType + "]");
        }
        auctionRecord.setGiveOutProductStatus("2");
        FacadeFactory.INSTANCE.getAuctionRecordBo().update(auctionRecord);
        return auctionRecord;
    }
}

