/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.serviceutils;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.data.vip.bo.UserVipBo;
import com.xunlei.niux.data.vip.facade.FacadeFactory;
import com.xunlei.niux.data.vip.vo.UserVip;
import com.xunlei.niux.data.vipgame.bo.CustomerGradeBo;
import com.xunlei.niux.data.vipgame.vo.CustomerGrade;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class JinKaUtils {
    public static int getJinKaLevelNum(long userId) {
        String cacheKey;
        CacheManager cacheManager = CacheManager.GetInstance();
        Object cacheResult = cacheManager.get(cacheKey = cacheManager.generateCacheKey(JinKaUtils.class, "JinKaLevel" + String.valueOf(userId)));
        if (cacheResult != null) {
            int jinKaLevel = Integer.parseInt(cacheResult.toString());
            return jinKaLevel;
        }
        UserVipBo userVipBo = FacadeFactory.INSTANCE.getUserVipBo();
        UserVip userVip = userVipBo.find(userId);
        int jinKaLevel = userVip == null ? 0 : userVip.getVipLervelNum();
        cacheManager.put(cacheKey, jinKaLevel, 10L);
        return jinKaLevel;
    }

    public static String getJinKaRebateRatio(long userId) {
        int jinKaLevel = JinKaUtils.getJinKaLevelNum(userId);
        List<CustomerGrade> customerGradeList = JinKaUtils.getCustomerGradeList();
        String rebateRatio = "";
        if (CollectionUtils.isEmpty(customerGradeList)) {
            return "";
        }
        for (CustomerGrade cGrad : customerGradeList) {
            if (cGrad.getVipGrade() != jinKaLevel) continue;
            rebateRatio = cGrad.getRecent();
            break;
        }
        return rebateRatio;
    }

    private static List<CustomerGrade> getCustomerGradeList() {
        String cacheKey;
        CacheManager cacheManager = CacheManager.GetInstance();
        Object cacheResult = cacheManager.get(cacheKey = cacheManager.generateCacheKey(CustomerGrade.class, "CustomerGradeList"));
        if (cacheResult != null) {
            List cglist = (List)cacheResult;
            return cglist;
        }
        CustomerGradeBo customerGradeBo = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getCustomerGradeBo();
        List<CustomerGrade> cglist = customerGradeBo.find(new CustomerGrade(), new Page());
        cacheManager.put(cacheKey, cglist, 1440L);
        return null;
    }
}

