/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.serviceutils;

import com.xunlei.niux.center.util.DateUtil;
import com.xunlei.niux.center.util.UserUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.gift.GiftPackage;
import com.xunlei.niux.data.vipgame.vo.gift.GiftRecord;
import org.apache.commons.lang.StringUtils;

public class GiftUtils {
    public static GiftRecord releaseGift(String actNo, long giftId, String giftType, long userId, int limitCount, int jinKaLevelLimit) throws RuntimeException {
        GiftRecord result = null;
        if (StringUtils.isEmpty(actNo) || giftId <= 0L || userId <= 0L) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff1aactNo=" + actNo + ", giftId=" + giftId + ",userId=" + userId);
        }
        int count = GiftUtils.alreadyGotGiftCount(actNo, giftId, userId);
        if (limitCount > 0 && count >= limitCount) {
            throw new RuntimeException("\u5df2\u7ecf\u9886\u8fc7\u793c\u5305\uff0c\u4e0d\u80fd\u518d\u9886\u53d6\u4e86\uff01");
        }
        int jinKaLevel = UserUtil.getJinKaLevelNum(userId);
        if (jinKaLevelLimit > 0 && jinKaLevel <= jinKaLevelLimit) {
            throw new RuntimeException("\u62b1\u6b49\uff0c\u60a8\u7684VIP\u7b49\u7ea7\u4e0d\u591f\uff01");
        }
        Gift gift = FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, giftId);
        if (gift == null) {
            throw new RuntimeException("\u793c\u54c1\u4e0d\u5b58\u5728\uff1agiftId\uff1a" + giftId);
        }
        if (StringUtils.isNotEmpty(giftType) && !gift.getGiftType().equals(giftType)) {
            throw new RuntimeException("\u793c\u54c1\u7684\u7c7b\u578b\u4e0d\u662f\uff1a" + giftType);
        }
        GiftRecord detailGiftRecord = new GiftRecord();
        detailGiftRecord.setActNo(actNo);
        detailGiftRecord.setGameId("");
        detailGiftRecord.setGiftId(giftId);
        detailGiftRecord.setGiftNum(1.0);
        detailGiftRecord.setRoleId("");
        detailGiftRecord.setServerId("");
        detailGiftRecord.setThirdRecordId(giftId + "_" + userId + "_" + actNo);
        detailGiftRecord.setUserId(String.valueOf(userId));
        detailGiftRecord.setIsShow(true);
        GiftPackage giftPackage = FacadeFactory.INSTANCE.getBaseSo().findById(GiftPackage.class, gift.getGiftLot());
        if (giftPackage != null) {
            detailGiftRecord.setExpireDate(DateUtil.calExpireDate(giftPackage.getExpireDays()));
        }
        FacadeFactory.INSTANCE.getUseGiftPackageBo().addGiftPackageDetail(detailGiftRecord);
        result = detailGiftRecord;
        return result;
    }

    public static int alreadyGotGiftCount(String actNo, long giftId, Long userId) {
        if (StringUtils.isEmpty(actNo) || giftId <= 0L || userId <= 0L) {
            return 0;
        }
        GiftRecord query = new GiftRecord();
        query.setActNo(actNo);
        query.setUserId(String.valueOf(userId));
        query.setGiftId(giftId);
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(query);
        return count;
    }
}

