/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.vip;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.util.SignUtil;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.data.vip.bo.UserVipBo;
import com.xunlei.niux.data.vip.facade.FacadeFactory;
import com.xunlei.niux.data.vip.vo.UserVip;
import com.xunlei.niux.data.vip.vo.VipLevel;
import com.xunlei.niux.data.vipgame.bo.CustomerGradeBo;
import com.xunlei.niux.data.vipgame.vo.CustomerGrade;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class VipInfoNewCmd
extends DefaultCmd {
    private static String ipLists = EnvPropertyUtil.loadProperty("VipClient", "ipLists");
    private static List<String> ipList = new ArrayList<String>();
    private static final String pass = "x83yjm3jmk7k-e2a";
    private static Map<Integer, VipLevel> vipLevels;

    @CmdMapper(value={"/vip/getVipInfoNew.do"})
    public Object getVipInfo(XLHttpRequest request, XLHttpResponse response) {
        this.initVipLevels();
        try {
            String ip = request.getRemoteIP();
            if (!ipList.contains(ip)) {
                return this.error("ip error");
            }
            String uid = request.getParameter("uid");
            String sign = request.getParameter("sign");
            String time = request.getParameter("time");
            if (StringUtil.isEmpty(uid, sign, time)) {
                return this.error("\u7f3a\u5c11\u53c2\u6570");
            }
            long timeL = Long.parseLong(time);
            if (Math.abs(System.currentTimeMillis() / 1000L - timeL) > 900L) {
                return this.error("\u5931\u6548\u7684\u8bf7\u6c42");
            }
            String s = SignUtil.sign(uid + time, pass);
            if (!s.equals(sign)) {
                return this.error("\u7b7e\u540d\u4e0d\u6b63\u786e");
            }
            UserVipBo userVipBo = FacadeFactory.INSTANCE.getUserVipBo();
            UserVip userVip = userVipBo.find(Long.parseLong(uid));
            if (userVip == null) {
                return this.error("uid:" + uid + "  not exist");
            }
            int vipNum = userVip.getVipLervelNum();
            int money = userVip.getPayMoney().intValue();
            CustomerGradeBo customerGradeBo = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getCustomerGradeBo();
            ArrayList<Integer> params = new ArrayList<Integer>();
            params.add(vipNum);
            List list = customerGradeBo.findBySql(CustomerGrade.class, "select * from customergrade where vipGrade = ?", params);
            if (list.size() == 0) {
                return this.error("vipNum:" + vipNum + "  error");
            }
            String recent = ((CustomerGrade)list.get(0)).getRecent();
            NumberFormat format = NumberFormat.getPercentInstance();
            format.setMinimumFractionDigits(2);
            float num = format.parse(recent).floatValue();
            Integer nextLevelMoney = 0;
            if (vipNum < vipLevels.size()) {
                int levelMoney = vipLevels.get(vipNum + 1).getMinMoney();
                nextLevelMoney = levelMoney - money;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("uid", uid);
            map.put("vip", vipNum);
            map.put("recent", Float.valueOf(num));
            map.put("money", money);
            map.put("nextLevelMoney", nextLevelMoney);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (Exception e) {
            return this.error("\u63a5\u53e3\u5f02\u5e38:" + e.getMessage());
        }
    }

    private void initVipLevels() {
        if (vipLevels == null) {
            List<VipLevel> list = FacadeFactory.INSTANCE.getVipLevelBo().find(new VipLevel());
            vipLevels = new HashMap<Integer, VipLevel>();
            for (VipLevel level : list) {
                vipLevels.put(level.getLevelNum(), level);
            }
        }
    }

    private String error(String errmsg) {
        return JsonObjectUtil.getRtnAndDataJsonObject(1, errmsg, null);
    }

    static {
        ipList = StringUtil.getListFromString(ipLists, ",");
    }
}

