/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.vip;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.client.util.StringUtil;
import com.xunlei.niux.data.vip.bo.UserVipBo;
import com.xunlei.niux.data.vip.facade.FacadeFactory;
import com.xunlei.niux.data.vip.vo.UserVip;
import com.xunlei.niux.data.vipgame.bo.CustomerGradeBo;
import com.xunlei.niux.data.vipgame.vo.CustomerGrade;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class VipInfoCmd
extends DefaultCmd {
    private static List<String> ipList = new ArrayList<String>();
    private static String ipLists = EnvPropertyUtil.loadProperty("VipClient", "ipLists");

    @CmdMapper(value={"/vip/getVipInfo.do"})
    public Object getVipInfo(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        try {
            String ip = request.getRemoteIP();
            if (!ipList.contains(ip)) {
                return this.error("ip error");
            }
            String uid = request.getParameter("uid");
            if (StringUtil.isEmpty(uid, new String[0])) {
                return this.error("\u7f3a\u5c11\u53c2\u6570");
            }
            UserVipBo userVipBo = FacadeFactory.INSTANCE.getUserVipBo();
            UserVip userVip = userVipBo.find(Long.parseLong(uid));
            if (userVip == null) {
                return this.error("uid:" + uid + "  not exist");
            }
            int vipNum = userVip.getVipLervelNum();
            CustomerGradeBo customerGradeBo = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getCustomerGradeBo();
            ArrayList<Integer> params = new ArrayList<Integer>();
            params.add(vipNum);
            List list = customerGradeBo.findBySql(CustomerGrade.class, "select * from customergrade where vipGrade = ?", params);
            if (list.size() == 0) {
                return this.error("vipNum:" + vipNum + "  error");
            }
            String recent = ((CustomerGrade)list.get(0)).getRecent();
            NumberFormat format = NumberFormat.getPercentInstance();
            format.setMinimumFractionDigits(2);
            float num = format.parse(recent).floatValue();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("uid", uid);
            map.put("vip", vipNum);
            map.put("recent", Float.valueOf(num));
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (Exception e) {
            return this.error("\u63a5\u53e3\u5f02\u5e38:" + e.getMessage());
        }
    }

    private String error(String errmsg) {
        return JsonObjectUtil.getRtnAndDataJsonObject(1, errmsg, null);
    }

    static {
        ipList = StringUtil.getListFromString(ipLists, ",");
    }
}

