/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.vip;

import com.xunlei.channel.util.UserUtility;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.so.gift.GiftFlowSo;
import com.xunlei.niux.center.util.SignUtil;
import com.xunlei.niux.client.gameinfo.UserGameLevelQuery;
import com.xunlei.niux.client.recharge.RechargeClient;
import com.xunlei.niux.common.exception.NiuExceptionAndCode;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.gift.GiftFlow;
import com.xunlei.niux.data.vipgame.vo.lottery.FreeLotteryChance;
import com.xunlei.niux.data.vipgame.vo.vip.JinKaTask;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class JinKaTaskCmd
extends DefaultCmd {
    private static final SimpleDateFormat sdfShort = new SimpleDateFormat("yyyy-MM-dd");
    private static final String LEVELING_ACTNO = "jinkalevelingtask";
    private static final String RECHARGE_ACTNO = "jinkarechargetask";
    private static final String TASKTYPE_LEVELING = "LEVELING";
    private static final String TASKTYPE_RECHARGE = "RECHARGE";
    private static String actcallbackkey = EnvPropertyUtil.loadProperty("niux", "actcallbackkey");

    @CmdMapper(value={"/jinka/gettasks.do"})
    public Object getTasks(XLHttpRequest request, XLHttpResponse response) {
        Map<String, Object> tomorrowLevelingTaskMap;
        Map<String, Object> todayLevelingTaskMap;
        Map<String, Object> tomorrowRechargeTaskMap;
        boolean isLogined = request.getParameterBoolean("isLogined", false);
        MainParam mainParam = null;
        if (isLogined) {
            mainParam = this.getMainParamSafe(request, response, true);
        }
        long nowLong = System.currentTimeMillis();
        long tomorrowLong = nowLong + 86400000L;
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>();
        Map<String, Object> todayRechargeTaskMap = JinKaTaskCmd.getTaskMapByDate(sdfShort.format(new Date(nowLong)), TASKTYPE_RECHARGE, mainParam);
        if (todayRechargeTaskMap != null) {
            resultMap.put("todayRechargeTask", todayRechargeTaskMap);
        }
        if ((tomorrowRechargeTaskMap = JinKaTaskCmd.getTaskMapByDate(sdfShort.format(new Date(tomorrowLong)), TASKTYPE_RECHARGE, null)) != null) {
            resultMap.put("tomorrowRechargeTask", tomorrowRechargeTaskMap);
        }
        if ((todayLevelingTaskMap = JinKaTaskCmd.getTaskMapByDate(sdfShort.format(new Date(nowLong)), TASKTYPE_LEVELING, mainParam)) != null) {
            resultMap.put("todayLevelingTask", todayLevelingTaskMap);
        }
        if ((tomorrowLevelingTaskMap = JinKaTaskCmd.getTaskMapByDate(sdfShort.format(new Date(tomorrowLong)), TASKTYPE_LEVELING, null)) != null) {
            resultMap.put("tomorrowLevelingTask", tomorrowLevelingTaskMap);
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    private static Map<String, Object> getTaskMapByDate(String taskDate, String taskType, MainParam mainParam) {
        JinKaTask task = JinKaTaskCmd.getTaskByDate(taskDate, taskType);
        if (task == null) {
            return null;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Gift gift = FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, task.getGiftId());
        Games game = JinKaTaskCmd.getGamesById(task.getGameId());
        GameServers server = JinKaTaskCmd.getGameServer(task.getGameId(), task.getFenQuNum());
        resultMap.put("taskId", task.getTaskId());
        resultMap.put("giftId", task.getGiftId());
        resultMap.put("giftName", gift == null ? "" : gift.getGiftName());
        resultMap.put("gameId", task.getGameId());
        resultMap.put("gameName", game.getGameName());
        resultMap.put("minRoleNum", task.getMinRoleNum());
        resultMap.put("fenQuNum", server == null ? "" : server.getFenQuNum());
        resultMap.put("fenQuName", server == null ? "" : server.getFenQuName());
        resultMap.put("taskType", task.getTaskType());
        resultMap.put("minRechargeMoney", task.getMinRechargeMoney());
        JinKaTaskCmd.setTaskStatus(task, mainParam, resultMap);
        return resultMap;
    }

    public static GameServers getGameServer(String gameId, String fenQuNum) {
        if (fenQuNum == null || "".equals(fenQuNum)) {
            return null;
        }
        GameServers query = new GameServers();
        query.setGameId(gameId);
        query.setFenQuNum(Integer.valueOf(fenQuNum));
        return FacadeFactory.INSTANCE.getBaseSo().findObject(query);
    }

    private static void setTaskStatus(JinKaTask task, MainParam mainParam, Map<String, Object> resultMap) {
        if (mainParam == null) {
            return;
        }
        if (task.getTaskType().equals(TASKTYPE_LEVELING)) {
            JinKaTaskCmd.setLevelingTaskStatus(task, mainParam, resultMap);
        } else {
            JinKaTaskCmd.setRechargeTaskStatus(task, mainParam, resultMap);
        }
    }

    private static void setLevelingTaskStatus(JinKaTask task, MainParam mainParam, Map<String, Object> resultMap) {
        String taskGiftFlowNo = mainParam.getUserid() + "_" + task.getGameId() + "_" + task.getFenQuNum() + "_" + task.getMinRoleNum();
        GiftFlow flow = JinKaTaskCmd.getGiftFlow(taskGiftFlowNo, LEVELING_ACTNO);
        if (flow != null) {
            resultMap.put("status", "2");
            return;
        }
        GameServers server = JinKaTaskCmd.getGameServer(task.getGameId(), task.getFenQuNum());
        int roleLevelNum = JinKaTaskCmd.getGameRoleLevelNum(mainParam.getSessionid(), String.valueOf(mainParam.getUserid()), task.getGameId(), server.getServerId());
        if (roleLevelNum >= task.getMinRoleNum()) {
            resultMap.put("status", "1");
            return;
        }
        resultMap.put("status", "0");
        resultMap.put("curRoleLevelNum", roleLevelNum);
    }

    private static int getGameRoleLevelNum(String sessionId, String userId, String gameId, String serverId) {
        String userName = UserUtility.getUserNameByUserId(userId);
        try {
            int roleLevelNum = UserGameLevelQuery.queryUserGameLevel(sessionId, userName, gameId, serverId);
            return roleLevelNum;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static void setRechargeTaskStatus(JinKaTask task, MainParam mainParam, Map<String, Object> resultMap) {
        String taskGiftFlowNo = mainParam.getUserid() + "_" + task.getGameId() + "_" + task.getTaskDate().replace("-", "");
        GiftFlow flow = JinKaTaskCmd.getGiftFlow(taskGiftFlowNo, RECHARGE_ACTNO);
        if (flow != null) {
            resultMap.put("status", "2");
            return;
        }
        int rechargeMoney = RechargeClient.queryRechargeMoney(String.valueOf(mainParam.getUserid()), RECHARGE_ACTNO, task.getGameId(), "", task.getTaskDate(), task.getTaskDate(), "0");
        if (rechargeMoney >= task.getMinRechargeMoney()) {
            resultMap.put("status", "1");
            return;
        }
        resultMap.put("status", "0");
        resultMap.put("curRechargeMoney", rechargeMoney);
    }

    private static JinKaTask getTaskByDate(String taskDate, String taskType) {
        JinKaTask query = new JinKaTask();
        query.setTaskDate(taskDate);
        query.setTaskType(taskType);
        return FacadeFactory.INSTANCE.getBaseSo().findObject(query);
    }

    private static Games getGamesById(String gameId) {
        Games queryGames = new Games();
        queryGames.setGameId(gameId);
        return FacadeFactory.INSTANCE.getBaseSo().findObject(queryGames);
    }

    private static GiftFlow getGiftFlow(String thirdOrderNo, String actNo) {
        GiftFlow queryGiftFlow = new GiftFlow();
        queryGiftFlow.setActNo(actNo);
        queryGiftFlow.setThirdOrderNo(thirdOrderNo);
        return FacadeFactory.INSTANCE.getBaseSo().findObject(queryGiftFlow);
    }

    @CmdMapper(value={"/jinka/gettaskgift.do"})
    public Object getTaskGift(XLHttpRequest request, XLHttpResponse response) {
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        long taskId = request.getParameterLong("taskId");
        String gameId = request.getParameter("gameId", "");
        String serverId = request.getParameter("serverId", "");
        String roleId = request.getParameter("roleId", "");
        long nowlong = System.currentTimeMillis();
        String nowShort = sdfShort.format(new Date(nowlong));
        JinKaTask task = FacadeFactory.INSTANCE.getBaseSo().findById(JinKaTask.class, taskId);
        if (!task.getTaskDate().equals(nowShort)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "taskId[" + taskId + "]\u975e\u4eca\u65e5\u4efb\u52a1", null);
        }
        String actNo = task.getTaskType().equals(TASKTYPE_LEVELING) ? LEVELING_ACTNO : RECHARGE_ACTNO;
        String thirdOrderNo = "";
        thirdOrderNo = task.getTaskType().equals(TASKTYPE_LEVELING) ? mainParam.getUserid() + "_" + task.getGameId() + "_" + task.getFenQuNum() + "_" + task.getMinRoleNum() : mainParam.getUserid() + "_" + task.getGameId() + "_" + task.getTaskDate().replace("-", "");
        GiftFlow flow = JinKaTaskCmd.getGiftFlow(thirdOrderNo, RECHARGE_ACTNO);
        if (flow != null) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u91cd\u590d\u63d0\u4ea4\u8ba2\u5355");
        }
        if (task.getTaskType().equals(TASKTYPE_LEVELING)) {
            GameServers server = JinKaTaskCmd.getGameServer(task.getGameId(), task.getFenQuNum());
            int roleLevelNum = JinKaTaskCmd.getGameRoleLevelNum(mainParam.getSessionid(), String.valueOf(mainParam.getUserid()), task.getGameId(), server.getServerId());
            if (roleLevelNum < task.getMinRoleNum()) {
                return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7528\u6237[" + mainParam.getUserid() + "]\u89d2\u8272\u7b49\u7ea7\u4e0d\u591f", null);
            }
        } else {
            int rechargeMoney = RechargeClient.queryRechargeMoney(String.valueOf(mainParam.getUserid()), RECHARGE_ACTNO, task.getGameId(), "", task.getTaskDate(), task.getTaskDate(), "0");
            if (rechargeMoney < task.getMinRechargeMoney()) {
                return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7528\u6237[" + mainParam.getUserid() + "]\u5145\u503c\u4e0d\u591f", null);
            }
        }
        GiftFlow giftFlow = new GiftFlow();
        giftFlow.setActNo(actNo);
        giftFlow.setGameId(gameId);
        giftFlow.setServerId(serverId);
        giftFlow.setRoleId(roleId);
        giftFlow.setGiftId(task.getGiftId());
        giftFlow.setUserId(String.valueOf(mainParam.getUserid()));
        giftFlow.setGiftNum(1);
        giftFlow.setThirdOrderNo(thirdOrderNo);
        try {
            giftFlow = GiftFlowSo.addFlow(giftFlow, true);
            this.addFreeLotteryChance(giftFlow.getUserId(), thirdOrderNo);
        }
        catch (NiuExceptionAndCode e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(Integer.valueOf(e.code), e.getMessage(), "");
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, giftFlow);
    }

    @CmdMapper(value={"/jinka/addLotteryChance.do"})
    public Object addLotteryChance(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String actNo = request.getParameter("actno", "");
        String payOrderNo = request.getParameter("orderid", "");
        String userId = request.getParameter("userid", "");
        String gameId = request.getParameter("gameid", "");
        String serverId = request.getParameter("serverid", "");
        String totalMoneyStr = request.getParameter("totalmoney");
        double totalMoney = request.getParameterDouble("totalmoney");
        double payMoney = request.getParameterDouble("payMoney");
        long timestamp = request.getParameterLong("time");
        String sign = request.getParameter("sign", "");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (System.currentTimeMillis() / 1000L - timestamp > 300L) {
            resultMap.put("code", 1);
            resultMap.put("msg", "\u56de\u8c03\u94fe\u63a5\u65e0\u6548");
            return JsonObjectUtil.getDataJsonObject(resultMap);
        }
        if ("".equals(payOrderNo) || "".equals(userId) || "".equals(gameId) || "".equals(sign)) {
            resultMap.put("code", 1);
            resultMap.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            return JsonObjectUtil.getDataJsonObject(resultMap);
        }
        if (totalMoney < payMoney || payMoney <= 0.0) {
            resultMap.put("code", 1);
            resultMap.put("msg", "\u652f\u4ed8\u91d1\u989d\u9519\u8bef");
            return JsonObjectUtil.getDataJsonObject(resultMap);
        }
        String newSign = SignUtil.sign(actNo + payOrderNo + userId + gameId + serverId + totalMoneyStr + timestamp, actcallbackkey);
        if (!newSign.equals(sign)) {
            resultMap.put("code", 1);
            resultMap.put("msg", "\u7b7e\u540d\u9519\u8bef");
            return JsonObjectUtil.getDataJsonObject(resultMap);
        }
        gameId = gameId.length() == 5 ? "0" + gameId : gameId;
        this.addFreeLotteryChance(userId, payOrderNo);
        return JsonObjectUtil.getDataJsonObject(resultMap);
    }

    private void addFreeLotteryChance(String userId, String sourceFrom) {
        String lotteryAct = "lottery0001";
        String date = sdfShort.format(new Date());
        FreeLotteryChance queryfreeLotteryChance = new FreeLotteryChance();
        queryfreeLotteryChance.setActNo(lotteryAct);
        queryfreeLotteryChance.setUserId(Long.valueOf(userId));
        queryfreeLotteryChance.setExpiredDate(date);
        FreeLotteryChance freeLotteryChance = FacadeFactory.INSTANCE.getBaseSo().findObject(queryfreeLotteryChance);
        if (freeLotteryChance != null) {
            return;
        }
        freeLotteryChance = new FreeLotteryChance();
        freeLotteryChance.setActNo(lotteryAct);
        freeLotteryChance.setExpiredDate(date);
        freeLotteryChance.setRecordTime(sdf_time.format(new Date()));
        freeLotteryChance.setSourceFrom(sourceFrom);
        freeLotteryChance.setUsedFlag(false);
        freeLotteryChance.setUserId(Long.valueOf(userId));
        FacadeFactory.INSTANCE.getBaseSo().addObject(freeLotteryChance);
    }
}

