/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.vicclub;

import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerDetailQuery;
import com.xunlei.niux.data.vipgame.vo.CustomerInfo;
import com.xunlei.niux.data.vipgame.vo.vic.PersonInfo;
import com.xunlei.niux.data.vipgame.vo.vicclub.VicClubChooseLog;
import com.xunlei.niux.data.vipgame.vo.vicclub.VicClubCustomerService;
import com.xunlei.niux.data.vipgame.vo.vicclub.VicClubStarRecord;
import com.xunlei.niux.data.vipgame.vo.vicclub.VicClubUserInfo;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import com.xunlei.util.Log;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class VicClubCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(VicClubCmd.class.getName());
    private static Map<String, String> sayMap = new HashedMap();

    @CmdMapper(value={"/vicclub/addUserInfo.do"})
    public Object addUserInfo(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String uid = mainParam.getUserid() + "";
            String realname = request.getParameter("realname");
            String sex = request.getParameter("sex");
            String qq = request.getParameter("qq");
            String birthday = request.getParameter("birthday");
            String place = request.getParameter("place");
            String mobile = request.getParameter("mobile");
            String captcha = request.getParameter("captcha");
            if (StringUtils.isEmpty(realname) || StringUtils.isEmpty(sex) || StringUtils.isEmpty(qq) || StringUtils.isEmpty(birthday) || StringUtils.isEmpty(place) || StringUtils.isEmpty(mobile)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
            }
            BaseSo baseSo = FacadeFactory.INSTANCE.getBaseSo();
            CustomerDetailQuery queryCdq = new CustomerDetailQuery();
            queryCdq.setUid(uid);
            CustomerDetailQuery cdq = baseSo.findObject(queryCdq);
            if (cdq == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, "uid\u4fe1\u606f\u5f02\u5e38");
            }
            cdq.setContactNumber(mobile);
            baseSo.updateObjectById(cdq);
            VicClubUserInfo queryVcui = new VicClubUserInfo();
            queryVcui.setUid(uid);
            if (baseSo.countObject(queryVcui) > 0) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u60a8\u5df2\u63d0\u4ea4\u4fe1\u606f");
            }
            VicClubUserInfo vicClubUserInfo = new VicClubUserInfo();
            vicClubUserInfo.setRealname(realname);
            vicClubUserInfo.setSex(sex);
            vicClubUserInfo.setQq(qq);
            vicClubUserInfo.setBirthday(birthday);
            vicClubUserInfo.setPlace(place);
            vicClubUserInfo.setMobile(mobile);
            vicClubUserInfo.setUid(uid);
            vicClubUserInfo.setInputTime(VicClubCmd.now());
            baseSo.addObject(vicClubUserInfo);
            CustomerInfo query = new CustomerInfo();
            query.setUid(uid);
            CustomerInfo customerInfo = baseSo.findObject(query);
            boolean isNewCi = false;
            if (customerInfo == null) {
                customerInfo = new CustomerInfo();
                customerInfo.setUid(uid);
                isNewCi = true;
            }
            customerInfo.setSex(sex);
            customerInfo.setUsername(realname);
            customerInfo.setQq(qq);
            customerInfo.setBirthday(birthday);
            customerInfo.setArea(place);
            customerInfo.setPhone(mobile);
            customerInfo.setCheckPhone(true);
            customerInfo.setCheckFlag(true);
            if (isNewCi) {
                baseSo.addObject(customerInfo);
            } else {
                baseSo.updateObjectById(customerInfo);
            }
            PersonInfo query1 = new PersonInfo();
            query1.setUid(mainParam.getUserid());
            PersonInfo personInfo = baseSo.findObject(query1);
            boolean isNewPi = false;
            if (personInfo == null) {
                personInfo = new PersonInfo();
                personInfo.setUid(mainParam.getUserid());
                isNewPi = true;
            }
            personInfo.setSex(sex);
            personInfo.setRealName(realname);
            personInfo.setQqNumber(qq);
            personInfo.setBirthday(birthday);
            personInfo.setPlaceProvince(place.split("-")[0]);
            personInfo.setPlaceCity(place.split("-")[1]);
            personInfo.setMobileNumber(mobile);
            if (isNewPi) {
                baseSo.addObject(personInfo);
            } else {
                baseSo.updateObjectById(personInfo);
            }
            return JsonObjectUtil.getOnlyOkJson();
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/vicclub/giveStar.do"})
    public Object giveStar(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String uid = mainParam.getUserid() + "";
            String formUser = request.getParameter("fromMan");
            String toCustomerService = request.getParameter("toMan");
            String starProStr = request.getParameter("starPro");
            String starServiceStr = request.getParameter("starService");
            String sayid = request.getParameter("say");
            if (StringUtils.isEmpty(formUser) || StringUtils.isEmpty(toCustomerService) || StringUtils.isEmpty(starProStr) || StringUtils.isEmpty(starServiceStr) || StringUtils.isEmpty(sayid)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
            }
            BaseSo baseSo = FacadeFactory.INSTANCE.getBaseSo();
            CustomerDetailQuery queryCdq = new CustomerDetailQuery();
            queryCdq.setUid(uid);
            CustomerDetailQuery cdq = baseSo.findObject(queryCdq);
            if (cdq == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, "uid\u4fe1\u606f\u5f02\u5e38");
            }
            BigDecimal startPro = new BigDecimal(starProStr);
            BigDecimal starService = new BigDecimal(starServiceStr);
            BigDecimal avgStar = startPro.add(starService).divide(new BigDecimal(2));
            BigDecimal star = avgStar.subtract(avgStar.remainder(new BigDecimal(0.5))).setScale(1, 1);
            VicClubCustomerService queryVccs = new VicClubCustomerService();
            queryVccs.setUserName(toCustomerService);
            VicClubCustomerService vicClubCustomerService = baseSo.findObject(queryVccs);
            if (vicClubCustomerService == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u65e0\u5bf9\u5e94\u4e13\u5c5e");
            }
            vicClubCustomerService.setStar(star);
            baseSo.updateObjectById(vicClubCustomerService);
            VicClubStarRecord queryRecord = new VicClubStarRecord();
            queryRecord.setUid(uid);
            if (baseSo.countObject(queryRecord) > 0) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u91cd\u590d\u6253\u5206");
            }
            VicClubStarRecord vicClubStarRecord = new VicClubStarRecord();
            vicClubStarRecord.setFormUser(formUser);
            vicClubStarRecord.setToCustomerService(toCustomerService);
            vicClubStarRecord.setStarPro(startPro);
            vicClubStarRecord.setStarService(starService);
            String say = sayMap.get(sayid);
            if (say == null) {
                say = "-";
            }
            vicClubStarRecord.setSay(say);
            vicClubStarRecord.setUid(uid);
            vicClubStarRecord.setInputTime(VicClubCmd.now());
            baseSo.addObject(vicClubStarRecord);
            return JsonObjectUtil.getOnlyOkJson();
        }
        catch (NumberFormatException e1) {
            logger.error("NumberFormatException:", e1);
            return JsonObjectUtil.getRtnAndDataJsonObject(98, "\u53c2\u6570\u503c\u5f02\u5e38");
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/vicclub/getService.do"})
    public Object getService(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String uid = mainParam.getUserid() + "";
            ArrayList result = new ArrayList();
            BaseSo baseSo = FacadeFactory.INSTANCE.getBaseSo();
            CustomerDetailQuery queryCdq = new CustomerDetailQuery();
            queryCdq.setUid(uid);
            CustomerDetailQuery cdq = baseSo.findObject(queryCdq);
            if (cdq == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, "uid\u4fe1\u606f\u5f02\u5e38");
            }
            if (StringUtils.isEmpty(cdq.getCustomerService())) {
                return JsonObjectUtil.getRtnAndDataJsonObject(0, this.getAllService());
            }
            VicClubCustomerService query = new VicClubCustomerService();
            query.setUserName(cdq.getCustomerService());
            VicClubCustomerService vicClubCustomerService = baseSo.findObject(query);
            if (vicClubCustomerService == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(0, this.getAllService());
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("zsid", vicClubCustomerService.getSeqid());
            map.put("nickName", vicClubCustomerService.getNickName());
            map.put("ability", vicClubCustomerService.getAbility());
            map.put("picOne", vicClubCustomerService.getPicOne());
            map.put("picTwo", vicClubCustomerService.getPicTwo());
            map.put("qq", vicClubCustomerService.getQq());
            map.put("star", vicClubCustomerService.getStar());
            map.put("userName", vicClubCustomerService.getUserName());
            result.add(map);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, result);
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    private Object getAllService() {
        ArrayList result = new ArrayList();
        List<VicClubCustomerService> vccsList = FacadeFactory.INSTANCE.getBaseSo().findObjects(new VicClubCustomerService(), new Page());
        for (VicClubCustomerService vccs : vccsList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("zsid", vccs.getSeqid());
            map.put("nickName", vccs.getNickName());
            map.put("ability", vccs.getAbility());
            map.put("picOne", vccs.getPicOne());
            map.put("picTwo", vccs.getPicTwo());
            map.put("qq", vccs.getQq());
            map.put("star", vccs.getStar());
            map.put("userName", vccs.getUserName());
            result.add(map);
        }
        return result;
    }

    @CmdMapper(value={"/vicclub/getStarRecord.do"})
    public Object getStarRecord(XLHttpRequest request, XLHttpResponse response) {
        try {
            String num = request.getParameter("num");
            String sql = "select * from vic_club_star_record order by inputTime desc ";
            if (StringUtils.isNotEmpty(num)) {
                try {
                    Integer.valueOf(num);
                }
                catch (NumberFormatException e) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
                }
                sql = sql + " limit " + num;
            } else {
                sql = sql + " limit 20";
            }
            ArrayList data = new ArrayList();
            List list = FacadeFactory.INSTANCE.getBaseSo().executeQuery(VicClubStarRecord.class, sql, new ArrayList());
            for (VicClubStarRecord vicClubStarRecord : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fromMan", vicClubStarRecord.getFormUser());
                map.put("toMan", vicClubStarRecord.getToCustomerService());
                map.put("say", vicClubStarRecord.getSay());
                data.add(map);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/vicclub/setService.do"})
    public Object setService(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String uid = mainParam.getUserid() + "";
            String seqidStr = request.getParameter("zsid");
            if (StringUtils.isEmpty(seqidStr)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
            }
            CustomerDetailQuery queryCdq = new CustomerDetailQuery();
            queryCdq.setUid(uid);
            CustomerDetailQuery cdq = FacadeFactory.INSTANCE.getBaseSo().findObject(queryCdq);
            if (cdq == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, "uid\u4fe1\u606f\u5f02\u5e38");
            }
            Long seqid = Long.valueOf(seqidStr);
            VicClubCustomerService query = new VicClubCustomerService();
            query.setSeqid(seqid);
            VicClubCustomerService vicClubCustomerService = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if (vicClubCustomerService == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u65e0\u4e13\u5c5e");
            }
            VicClubChooseLog log = new VicClubChooseLog();
            log.setUid(uid);
            log.setChooseDate(DateUtil.formatNow("yyyy-MM-dd"));
            if (FacadeFactory.INSTANCE.getBaseSo().countObject(log) > 0) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u4eca\u65e5\u5df2\u7ecf\u9009\u62e9");
            }
            log.setChooseCustomerService(vicClubCustomerService.getNickName());
            FacadeFactory.INSTANCE.getBaseSo().addObject(log);
            return JsonObjectUtil.getOnlyOkJson();
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/vicclub/hasUserInfo.do"})
    public Object hasUserInfo(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String uid = mainParam.getUserid() + "";
            BaseSo baseSo = FacadeFactory.INSTANCE.getBaseSo();
            CustomerDetailQuery queryCdq = new CustomerDetailQuery();
            queryCdq.setUid(uid);
            CustomerDetailQuery cdq = baseSo.findObject(queryCdq);
            if (cdq == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, "uid\u4fe1\u606f\u5f02\u5e38");
            }
            CustomerInfo query = new CustomerInfo();
            query.setUid(uid);
            CustomerInfo customerInfo = baseSo.findObject(query);
            if (customerInfo == null) {
                return JsonObjectUtil.getOnlyOkJson();
            }
            PersonInfo query1 = new PersonInfo();
            query1.setUid(mainParam.getUserid());
            PersonInfo personInfo = baseSo.findObject(query1);
            if (personInfo == null) {
                return JsonObjectUtil.getOnlyOkJson();
            }
            VicClubUserInfo queryVcui = new VicClubUserInfo();
            queryVcui.setUid(uid);
            if (baseSo.countObject(queryVcui) == 0) {
                return JsonObjectUtil.getOnlyOkJson();
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("realname", personInfo.getRealName());
            map.put("sex", personInfo.getSex());
            map.put("qq", personInfo.getQqNumber());
            map.put("birthday", personInfo.getBirthday());
            map.put("place", customerInfo.getArea());
            map.put("mobile", personInfo.getMobileNumber());
            return JsonObjectUtil.getRtnAndDataJsonObject(1, map);
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    static {
        sayMap.put("1", "\u798f\u5229\u80fd\u53d1\u80fd\u5feb\u4e00\u70b9\u5417\uff1f");
        sayMap.put("2", "\u68d2\u68d2\u54d2~\u6211\u7231\u4f60~");
        sayMap.put("3", "\u80fd\u7231\u6211\u591a\u4e00\u70b9\u5417\uff1f");
        sayMap.put("4", "\u80fd\u6e29\u67d4\u70b9\u5417\uff1f");
        sayMap.put("5", "\u4eb2\uff0c\u54b1\u89c1\u4e2a\u9762\u5427~");
        sayMap.put("6", "\u8fd8\u4e0d\u9519\uff0c\u7279\u6743\u6211\u6700\u5927\uff01");
    }
}

