/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.user;

import com.xunlei.channel.util.UserUtility;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_sec;
import com.xunlei.util.Log;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class UserCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(UserCmd.class);

    @CmdMapper(value={"/user/queryuserinfo.do"})
    public Object queryUserInfo(XLHttpRequest request, XLHttpResponse response) {
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        Resp_getuserinfo_sec userinfo = UserUtility.getUserInfoProxyByUserid(String.valueOf(mainParam.getUserid()));
        String name = userinfo == null || userinfo.getTruename() == null ? "" : userinfo.getTruename();
        String idCard = userinfo == null || userinfo.getIdcardno() == null ? "" : userinfo.getIdcardno();
        logger.info(mainParam.getUserid() + "getuserinfo before convert name:" + name + ",idCard:" + idCard);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            String isoStr = new String(name.getBytes("gbk"), "ISO-8859-1");
            name = new String(isoStr.getBytes("ISO-8859-1"), "utf-8");
            logger.info(mainParam.getUserid() + "getuserinfo after convert name:" + name + ",idCard:" + idCard);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(name + "trans gbk to utf8 exception", e);
        }
        resultMap.put("name", name);
        resultMap.put("idCard", idCard.length() > 0 ? idCard.substring(0, 4) + "*******" + idCard.substring(idCard.length() - 4) : idCard);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u6210\u529f", resultMap);
    }

    @CmdMapper(value={"/user/updateuserinfo.do"})
    public Object updateUserInfo(XLHttpRequest request, XLHttpResponse response) {
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String trueName = request.getParameter("trueName", "");
        String idCardNo = request.getParameter("idCard", "");
        String proxyUrl = request.getParameter("proxyUrl", "");
        String requestType = request.getParameter("requestType", "");
        if (trueName.length() == 0 || idCardNo.length() == 0) {
            if (proxyUrl.length() > 0) {
                proxyUrl = proxyUrl.indexOf("?") < 0 ? proxyUrl + "?" : proxyUrl;
                response.redirect(proxyUrl + "requestType=" + requestType + "&rtnData=" + JsonObjectUtil.getRtnAndDataJsonObject(13, "", null));
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(13, "", null);
        }
        try {
            ProxyFactory.getInstance().getUserInfoProxy().setuserinfo(String.valueOf(mainParam.getUserid()), (byte)2, "idcardno", idCardNo, "truename", trueName);
            logger.info("setuserinfo userId:" + String.valueOf(mainParam.getUserid()) + ",idcardno:" + idCardNo + ",trueName:" + trueName);
            if (proxyUrl.length() > 0) {
                proxyUrl = proxyUrl.indexOf("?") < 0 ? proxyUrl + "?" : proxyUrl;
                response.redirect(proxyUrl + "requestType=" + requestType + "&rtnData=" + JsonObjectUtil.getRtnAndDataJsonObject(0, "", null));
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, "", null);
        }
        catch (Exception e) {
            if (proxyUrl.length() > 0) {
                proxyUrl = proxyUrl.indexOf("?") < 0 ? proxyUrl + "?" : proxyUrl;
                response.redirect(proxyUrl + "requestType=" + requestType + "&rtnData=" + JsonObjectUtil.getRtnAndDataJsonObject(99, "", null));
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "", null);
        }
    }
}

