/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.tourist;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.dto.tourist.TouristGameWebConfigDTO;
import com.xunlei.niux.center.enums.ResultCode;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.tourist.TouristGameWebConfig;
import com.xunlei.util.Log;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class TouristConfigCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(TouristConfigCmd.class);

    @CmdMapper(value={"/tourist/getTouristGameWebConfig.do"})
    public Object getTouristGameWebConfig(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String channelId = request.getParameter("channelid");
        String gameId = request.getParameter("gameid");
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty(gameId) || StringUtils.isEmpty(channelId)) {
            sb.append(ResultCode.resultContent.get(ResultCode.INVALIDPARAM));
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.INVALIDPARAM, sb.toString());
        }
        TouristGameWebConfig config = this.getTouristGameWebConfig(gameId, channelId);
        if (config == null) {
            sb.append(ResultCode.resultContent.get(ResultCode.NODATAFOUND));
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.NODATAFOUND, sb.toString());
        }
        TouristGameWebConfigDTO touristGameWebConfigDTO = new TouristGameWebConfigDTO();
        BeanUtils.copyProperties(config, touristGameWebConfigDTO);
        Map<String, Object> data = touristGameWebConfigDTO.toMap();
        data.put("totalCount", this.getTotalNum());
        return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SUCCESS, data);
    }

    private TouristGameWebConfig getTouristGameWebConfig(String gameId, String channelId) {
        TouristGameWebConfig result = null;
        TouristGameWebConfig query = new TouristGameWebConfig();
        query.setGameId(gameId);
        query.setIsValid(true);
        Page page = new Page();
        page.addOrder("seqid", OrderType.DESC);
        List<TouristGameWebConfig> touristGameWebConfigList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
        if (CollectionUtils.isEmpty(touristGameWebConfigList)) {
            return result;
        }
        HashMap<String, TouristGameWebConfig> configMap = new HashMap<String, TouristGameWebConfig>();
        for (TouristGameWebConfig config : touristGameWebConfigList) {
            if (configMap.containsKey(config.getChannelId())) continue;
            configMap.put(config.getChannelId(), config);
        }
        if (configMap.containsKey(channelId)) {
            result = (TouristGameWebConfig)configMap.get(channelId);
        } else if (configMap.containsKey("")) {
            result = (TouristGameWebConfig)configMap.get("");
        }
        return result;
    }

    private int getTotalNum() {
        long time = System.currentTimeMillis() / 1000L;
        int pre = (int)(time / 10000L);
        int post = (int)(time % 10000L);
        int result = (int)((double)pre * 0.043 + (double)post * 0.0143);
        return result;
    }
}

