/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.tourist;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.xunlei.channel.util.UserUtility;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.business.thread.BusinessThread;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.enums.ResultCode;
import com.xunlei.niux.center.thirdclient.BonusClient;
import com.xunlei.niux.center.util.HttpClientUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.tourist.TouristBindGetBonusRecrod;
import com.xunlei.util.Log;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class TouristBindActCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(TouristBindActCmd.class);
    protected static SimpleDateFormat sdf_date = new SimpleDateFormat("yyyy-MM-dd");
    private static String url = "http://websvr.niu.xunlei.com/bindWEBYK.webGameLogin?";
    private static List<Long> userList = new ArrayList<Long>();
    private static final int bonusNum = 10;
    private static final String actNo = "TouristBind";

    @CmdMapper(value={"/touristbind/doTouristBindAct.do"})
    public Object doTouristBindAct(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        long userId = mainParam.getUserid();
        String channelId = request.getParameter("channelid");
        String gameId = request.getParameter("gameid");
        String serverId = request.getParameter("serverid");
        String roleId = request.getParameter("roleid", "");
        String username = request.getParameter("username");
        String webYKId = request.getParameter("webYKId");
        String password = request.getParameter("password");
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty(gameId) || StringUtils.isEmpty(username) || StringUtils.isEmpty(webYKId) || StringUtils.isEmpty(password)) {
            sb.append(ResultCode.resultContent.get(ResultCode.INVALIDPARAM) + "&channelid=" + channelId + "&gameid=" + gameId + "&username=" + username + "&webYKId=" + webYKId + "&password=" + password);
            logger.error(sb.toString());
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.INVALIDPARAM, sb.toString());
        }
        String YK_url = url + "&username=" + username + "&webYKId=" + webYKId + "&password=" + password;
        String responetext = "";
        try {
            logger.info("YKBind URL:{}", (Object)YK_url);
            responetext = HttpClientUtil.getHtml(YK_url);
            logger.info("YKBind result:{}", (Object)responetext);
        }
        catch (Exception e) {
            sb.append("url:(" + url + ") execute error:" + e);
            logger.error("url:(" + url + ") execute error!", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.INVALIDURL, ResultCode.resultContent.get(ResultCode.INVALIDURL) + sb.toString());
        }
        Map resultMap = null;
        if (responetext.contains("\"code\":0")) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("channelId", channelId);
            paramMap.put("gameId", gameId);
            paramMap.put("serverId", serverId);
            paramMap.put("roleId", roleId);
            paramMap.put("userId", userId);
            BusinessThread businessThread = new BusinessThread(paramMap);
            FutureTask futureTask = new FutureTask(businessThread);
            Thread thread = new Thread(futureTask);
            thread.start();
            try {
                resultMap = (Map)futureTask.get();
            }
            catch (InterruptedException e) {
                logger.error("get future result InterruptedException;", e);
            }
            catch (ExecutionException e) {
                logger.error("get future result ExecutionException;", e);
            }
        }
        Gson gson = new Gson();
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Map data = (Map)gson.fromJson(responetext, type);
        if (MapUtils.isNotEmpty(resultMap)) {
            data.putAll(resultMap);
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SUCCESS, data);
    }

    @CmdMapper(value={"/touristbind/getfirstBindBonus.do"})
    public Object getfirstBindBonus(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        long userId = mainParam.getUserid();
        String userIdStr = String.valueOf(userId);
        if (userList.contains(userId)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u5df2\u7ecf\u83b7\u53d6\u8fc7\u79ef\u5206!");
        }
        if (this.isUserHasRecord(userId)) {
            userList.add(userId);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u5df2\u7ecf\u83b7\u53d6\u8fc7\u79ef\u5206!");
        }
        String userName = UserUtility.getUserNameByUserId(userIdStr);
        Date now = new Date();
        try {
            String transNo = "TBind_" + now.getTime();
            BonusClient.recharge(userIdStr, userName, 10, transNo, sdf_date.format(now), actNo);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u79ef\u5206\u5931\u8d25,\u539f\u56e0\uff1a", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u83b7\u53d6\u79ef\u5206\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage());
        }
        new Thread(new AddRecordThread(userId)).start();
        userList.add(userId);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u83b7\u53d6\u79ef\u5206\u6210\u529f");
    }

    private boolean isUserHasRecord(Long userId) {
        TouristBindGetBonusRecrod query = new TouristBindGetBonusRecrod();
        query.setUserId(userId);
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(query);
        return count > 0;
    }

    class AddRecordThread
    implements Runnable {
        private long userId;

        AddRecordThread(long userId) {
            this.userId = userId;
        }

        @Override
        public void run() {
            TouristBindGetBonusRecrod bindGetBonusRecrod = new TouristBindGetBonusRecrod();
            bindGetBonusRecrod.setUserId(this.userId);
            bindGetBonusRecrod.setRecordTime(new Date());
            FacadeFactory.INSTANCE.getBaseSo().addObject(bindGetBonusRecrod);
        }
    }
}

