/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.tasks;

import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.tasks.TaskReleaseGiftThread;
import com.xunlei.niux.center.serviceutils.GameUtils;
import com.xunlei.niux.center.util.DateUtil;
import com.xunlei.niux.client.gameinfo.UserGameLoginDays;
import com.xunlei.niux.client.util.MapEasyUtils;
import com.xunlei.niux.data.vipgame.dto.tasks.TaskGameConfigDTO;
import com.xunlei.niux.data.vipgame.dto.tasks.UserTaskRecordDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.tasks.TaskDutyConfig;
import com.xunlei.niux.data.vipgame.vo.tasks.TaskGameConfig;
import com.xunlei.niux.data.vipgame.vo.tasks.UserTaskRecord;
import com.xunlei.util.Log;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class UserTaskCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(UserTaskCmd.class);
    private static final int TaskPeriod = 5;

    @CmdMapper(value={"/usertask/getUserTasks.do"})
    public Object getUserTasks(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        Long userId = mainParam.getUserid();
        try {
            List<UserTaskRecordDTO> userTaskRecordDTOList = this.getAllUserTaskRecords(userId.toString());
            if (CollectionUtils.isEmpty(userTaskRecordDTOList)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u6ca1\u6709\u7528\u6237\u9886\u53d6\u7684\u4efb\u52a1\u4fe1\u606f");
            }
            Map<Integer, TaskDutyConfig> taskDutyConfigMap = FacadeFactory.INSTANCE.getTaskDutyConfigBo().getAllTaskDutyConfig();
            for (UserTaskRecordDTO recordDTO : userTaskRecordDTOList) {
                ArrayList<Boolean> rewardStatusList = new ArrayList<Boolean>();
                rewardStatusList.add(recordDTO.getReward1Status());
                rewardStatusList.add(recordDTO.getReward2Status());
                rewardStatusList.add(recordDTO.getReward3Status());
                rewardStatusList.add(recordDTO.getReward4Status());
                recordDTO.setRewardStatusList(rewardStatusList);
                ArrayList<TaskDutyConfig> taskDutyList = new ArrayList<TaskDutyConfig>();
                taskDutyList.add(taskDutyConfigMap.get(recordDTO.getTask1ref()));
                taskDutyList.add(taskDutyConfigMap.get(recordDTO.getTask2ref()));
                taskDutyList.add(taskDutyConfigMap.get(recordDTO.getTask3ref()));
                taskDutyList.add(taskDutyConfigMap.get(recordDTO.getTask4ref()));
                recordDTO.setTaskDutyList(taskDutyList);
            }
            ArrayList result = new ArrayList();
            for (UserTaskRecordDTO recordDTO : userTaskRecordDTOList) {
                HashMap<String, Object> userTaskMap = new HashMap<String, Object>();
                userTaskMap.put("seqId", recordDTO.getSeqId());
                userTaskMap.put("taskConfSeqId", recordDTO.getTaskConfSeqId());
                userTaskMap.put("gameId", recordDTO.getGameId());
                userTaskMap.put("serverId", recordDTO.getServerId());
                userTaskMap.put("picUrl", recordDTO.getPicUrl());
                userTaskMap.put("expireTime", recordDTO.getExpireTime());
                userTaskMap.put("gameNo", recordDTO.getGameNo());
                userTaskMap.put("fenQuNum", recordDTO.getFenQuNum());
                if (StringUtils.isEmpty(recordDTO.getFenQuNickName())) {
                    userTaskMap.put("fenQuNickName", recordDTO.getFenQuName());
                } else {
                    userTaskMap.put("fenQuNickName", recordDTO.getFenQuNickName());
                }
                ArrayList taskDutyMapList = new ArrayList();
                if (CollectionUtils.isNotEmpty(recordDTO.getTaskDutyList())) {
                    // empty if block
                }
                List<TaskDutyConfig> taskDutyList = recordDTO.getTaskDutyList();
                List<Boolean> rewardList = recordDTO.getRewardStatusList();
                for (int i = 0; i < taskDutyList.size(); ++i) {
                    TaskDutyConfig dutyConfig = taskDutyList.get(i);
                    if (dutyConfig == null) continue;
                    HashMap<String, Object> taskMap = new HashMap<String, Object>();
                    taskMap.put("dutyDesc", dutyConfig.getDutyDesc());
                    taskMap.put("giftId", dutyConfig.getRewardGiftId());
                    taskMap.put("rewardDesc", dutyConfig.getRewardDesc());
                    taskMap.put("rewardStatus", rewardList.get(i) != false ? 1 : 0);
                    taskDutyMapList.add(taskMap);
                }
                userTaskMap.put("tasks", taskDutyMapList);
                result.add(userTaskMap);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.error("getUserTasks Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(-100, "\u7f51\u7edc\u9519\u8bef\uff01");
        }
    }

    public List<UserTaskRecordDTO> getAllUserTaskRecords(String userId) {
        List<UserTaskRecordDTO> dtoList = FacadeFactory.INSTANCE.getUserTaskRecordBo().getAllUserTaskRecord(userId);
        if (CollectionUtils.isEmpty(dtoList)) {
            return dtoList;
        }
        for (UserTaskRecordDTO dto : dtoList) {
            GameServers gameServer = this.getGameServerByGameIdAndServerId(dto.getGameId(), dto.getServerId());
            if (gameServer == null) continue;
            dto.setFenQuNum(gameServer.getFenQuNum());
            dto.setFenQuNickName(gameServer.getFenQuNickName());
            dto.setFenQuName(gameServer.getFenQuName());
        }
        return dtoList;
    }

    public GameServers getGameServerByGameIdAndServerId(String gameId, String serverId) {
        GameServers gameserver = null;
        String cacheKey = gameId + "_" + serverId;
        CacheManager cacheManager = CacheManager.GetInstance();
        Object object = cacheManager.get(cacheKey);
        if (object == null) {
            GameServers query = new GameServers();
            query.setGameId(gameId);
            query.setServerId(serverId);
            List<GameServers> serverList = FacadeFactory.INSTANCE.getGameServersBo().find(query, new Page());
            if (CollectionUtils.isNotEmpty(serverList)) {
                gameserver = serverList.get(0);
            }
            if (gameserver != null) {
                cacheManager.put(cacheKey, gameserver, 120L);
            }
        } else {
            gameserver = (GameServers)object;
        }
        return gameserver;
    }

    @CmdMapper(value={"/usertask/receiveTask.do"})
    public Object receiveTask(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        Long userId = mainParam.getUserid();
        String seqIdStr = request.getParameter("seqId");
        String serverId = request.getParameter("serverId");
        long seqId = Long.parseLong(seqIdStr);
        if (StringUtils.isEmpty(seqIdStr) || StringUtils.isEmpty(serverId)) {
            logger.error("request:{} \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object)request.getUrl());
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            TaskGameConfig taskGameConfig = FacadeFactory.INSTANCE.getBaseSo().findById(TaskGameConfig.class, seqId);
            if (taskGameConfig == null) {
                logger.error("\u6ca1\u6709\u7f16\u53f7{} \u5bf9\u5e94\u7684\u914d\u7f6e\u4fe1\u606f\uff01", seqId);
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u6ca1\u6709\u8be5\u7f16\u53f7\u5bf9\u5e94\u7684\u914d\u7f6e\u4fe1\u606f\uff01");
            }
            if (!this.isValidateOpenedGameServerId(taskGameConfig.getGameId(), serverId)) {
                logger.error("\u6e38\u620f{}\u533a\u670d{}\u4e0d\u662f\u6709\u6548\u5df2\u5f00\u533a\u7684\u533a\u670d\uff0c\u6216\u9886\u53d6\u65f6\u95f4\u5df2\u8fc7\u671f\uff01");
                return JsonObjectUtil.getRtnAndDataJsonObject(-3, "\u4e0d\u662f\u6709\u6548\u7684\u6e38\u620f\u533a\u670d\u4fe1\u606f,\u6216\u9886\u53d6\u65f6\u95f4\u5df2\u8fc7\u671f");
            }
            if (!taskGameConfig.getGameId().startsWith("05") && this.isUserHasTakedTheTask(seqId, serverId, userId.toString())) {
                logger.error("\u5df2\u7ecf\u9886\u53d6\u8fc7\u8be5\u6e38\u620f{}\u533a\u670d{}\u7684\u4efb\u52a1", (Object)taskGameConfig.getGameId(), (Object)serverId);
                return JsonObjectUtil.getRtnAndDataJsonObject(-4, "\u5df2\u7ecf\u9886\u53d6\u8fc7\u8be5\u6e38\u620f\u533a\u670d\u7684\u4efb\u52a1");
            }
            Date now = new Date();
            UserTaskRecord userTaskRecord = new UserTaskRecord();
            userTaskRecord.setTaskConfSeqId(seqId);
            userTaskRecord.setServerId(serverId);
            userTaskRecord.setUserId(userId.toString());
            userTaskRecord.setRecordTime(DateUtil.formatByDefault(now));
            userTaskRecord.setExpireTime(DateUtil.formatByDefault(DateUtil.getEndTime(now, "day", 5)));
            userTaskRecord.setReward1Status(false);
            userTaskRecord.setReward2Status(false);
            userTaskRecord.setReward3Status(false);
            userTaskRecord.setReward4Status(false);
            FacadeFactory.INSTANCE.getBaseSo().addObject(userTaskRecord);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u9886\u53d6\u4efb\u52a1\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("receiveTask Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(-100, "\u7f51\u7edc\u9519\u8bef");
        }
    }

    private boolean isValidateOpenedGameServerId(String gameId, String serverId) throws Exception {
        return FacadeFactory.INSTANCE.getGameServersBo().isValidOpenedGameServerAndCanUserReceiveTask(gameId, serverId);
    }

    public boolean isUserHasTakedTheTask(long configSeqId, String serverId, String userId) {
        UserTaskRecord query = new UserTaskRecord();
        query.setTaskConfSeqId(configSeqId);
        query.setServerId(serverId);
        query.setUserId(userId);
        List<UserTaskRecord> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
        return !CollectionUtils.isEmpty(list);
    }

    @CmdMapper(value={"/usertask/receiveReward.do"})
    public Object receiveReward(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        Long userId = mainParam.getUserid();
        String seqIdStr = request.getParameter("seqId");
        String taskId = request.getParameter("taskId");
        String giftId = request.getParameter("giftId");
        String serverId = request.getParameter("serverId");
        if (StringUtils.isEmpty(taskId) || StringUtils.isEmpty(giftId) || StringUtils.isEmpty(seqIdStr)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        long seqId = Long.parseLong(seqIdStr);
        UserTaskRecord userTaskRecord = FacadeFactory.INSTANCE.getUserTaskRecordBo().getUserTaskRecordByUserIdAndSeqIdAndServerId(seqId, userId.toString(), serverId);
        if (userTaskRecord == null) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u7528\u6237\u672a\u9886\u53d6\u6b64\u4efb\u52a1\uff01");
        }
        try {
            Date now = new Date();
            if (now.after(DateUtil.parseByDefault(userTaskRecord.getExpireTime()))) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-9, "\u4efb\u52a1\u5df2\u8fc7\u671f\uff01");
            }
        }
        catch (ParseException e) {
            logger.error("ExpireTime ParseException:", e);
        }
        Map<Long, TaskGameConfigDTO> allTaskGameConfigDTOMap = this.getAllTaskGameConfigMap();
        TaskGameConfigDTO taskGameConfigDTO = allTaskGameConfigDTOMap.get(userTaskRecord.getTaskConfSeqId());
        if (taskGameConfigDTO == null) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-3, "\u6e38\u620f\u4efb\u52a1\u914d\u7f6e\u6570\u636e\u672a\u914d\u7f6e");
        }
        boolean isRewarded = false;
        TaskDutyConfig curTaskConfig = null;
        if (taskId.equals("1")) {
            isRewarded = userTaskRecord.getReward1Status();
            curTaskConfig = taskGameConfigDTO.getTask1();
        } else if (taskId.equals("2")) {
            isRewarded = userTaskRecord.getReward2Status();
            curTaskConfig = taskGameConfigDTO.getTask2();
        } else if (taskId.equals("3")) {
            isRewarded = userTaskRecord.getReward3Status();
            curTaskConfig = taskGameConfigDTO.getTask3();
        } else if (taskId.equals("4")) {
            isRewarded = userTaskRecord.getReward4Status();
            curTaskConfig = taskGameConfigDTO.getTask4();
        } else {
            return JsonObjectUtil.getRtnAndDataJsonObject(-4, "taskId\u65e0\u6548\uff01");
        }
        if (isRewarded) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-5, "\u5df2\u9886\u53d6\u6b64\u5956\u52b1");
        }
        if (curTaskConfig == null) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-6, "\u65e0\u4efb\u52a1\u8be6\u60c5\u6570\u636e\uff01");
        }
        Gift gift = FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, giftId);
        if (!curTaskConfig.getRewardGiftId().equals(giftId) || gift == null) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-7, "\u5956\u54c1Id\u4e0d\u6b63\u786e\u6216\u8005\u5956\u54c1\u57fa\u672c\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        try {
            Map<String, Object> result = this.getDutyReward(mainParam.getSessionid(), curTaskConfig, userId.toString(), userTaskRecord, taskId);
            logger.info("getDutyReward result:" + result);
            int code = Integer.parseInt(result.get("code").toString());
            if (code != 0) {
                String msg = result.get("data").toString();
                return JsonObjectUtil.getRtnAndDataJsonObject(code, msg);
            }
        }
        catch (Exception e) {
            logger.error("getDutyReward Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(-10, "\u9886\u53d6\u5956\u54c1\u5931\u8d25\uff01");
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("giftType", gift.getGiftType());
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    @CmdMapper(value={"/usertask/hasUserReceivedReward.do"})
    public Object hasUserReceivedReward(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        Long userId = mainParam.getUserid();
        String seqIdStr = request.getParameter("seqId");
        String serverId = request.getParameter("serverId");
        if (StringUtils.isEmpty(seqIdStr) || StringUtils.isEmpty(serverId)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        long seqId = Long.parseLong(seqIdStr);
        UserTaskRecord userTaskRecord = FacadeFactory.INSTANCE.getUserTaskRecordBo().getUserTaskRecordByUserIdAndSeqIdAndServerId(seqId, userId.toString(), serverId);
        if (userTaskRecord == null) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u7528\u6237\u672a\u9886\u53d6\u6b64\u4efb\u52a1\uff01");
        }
        Map<Long, TaskGameConfigDTO> allTaskGameConfigDTOMap = this.getAllTaskGameConfigMap();
        TaskGameConfigDTO taskGameConfigDTO = allTaskGameConfigDTOMap.get(userTaskRecord.getTaskConfSeqId());
        if (taskGameConfigDTO == null) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-3, "\u6e38\u620f\u4efb\u52a1\u914d\u7f6e\u6570\u636e\u672a\u914d\u7f6e");
        }
        boolean isTask1Rewarded = userTaskRecord.getReward1Status();
        boolean isTask2Rewarded = userTaskRecord.getReward2Status();
        boolean isTask3Rewarded = userTaskRecord.getReward3Status();
        boolean isTask4Rewarded = userTaskRecord.getReward4Status();
        HashMap<String, Boolean> rewardStatusMap = new HashMap<String, Boolean>();
        rewardStatusMap.put("task1", isTask1Rewarded);
        rewardStatusMap.put("task2", isTask2Rewarded);
        rewardStatusMap.put("task3", isTask3Rewarded);
        rewardStatusMap.put("task4", isTask4Rewarded);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, rewardStatusMap);
    }

    private Map<Long, TaskGameConfigDTO> getAllTaskGameConfigMap() {
        HashMap<Long, TaskGameConfigDTO> allTaskGameConfigMap = null;
        String cacheKey = UserTaskCmd.class + "AllTaskGameConfigMap";
        CacheManager cacheManager = CacheManager.GetInstance();
        Object object = cacheManager.get(cacheKey);
        if (object == null) {
            allTaskGameConfigMap = new HashMap<Long, TaskGameConfigDTO>();
            List<TaskGameConfigDTO> allTaskGameConfigList = FacadeFactory.INSTANCE.getTaskGameConfigBo().getAllTaskGameConfigDTOList();
            for (TaskGameConfigDTO configDTO : allTaskGameConfigList) {
                allTaskGameConfigMap.put(configDTO.getSeqId(), configDTO);
            }
            if (MapUtils.isNotEmpty(allTaskGameConfigMap)) {
                cacheManager.put(cacheKey, allTaskGameConfigMap, 10L);
            }
        } else {
            allTaskGameConfigMap = (HashMap<Long, TaskGameConfigDTO>)object;
        }
        return allTaskGameConfigMap;
    }

    private Map<String, Object> getDutyReward(String sessionId, TaskDutyConfig dutyConfig, String userId, UserTaskRecord userTaskRecord, String taskId) {
        int val = 0;
        if (dutyConfig.getDutyType() == 1) {
            val = GameUtils.getGameRoleLevelNum(sessionId, userId, dutyConfig.getGameId(), userTaskRecord.getServerId());
        } else if (dutyConfig.getDutyType() == 2) {
            try {
                String fromDate = DateUtil.format(DateUtil.parseByDefault(userTaskRecord.getRecordTime()), "yyyyMMdd");
                String toDate = DateUtil.format(DateUtil.parseByDefault(userTaskRecord.getExpireTime()), "yyyyMMdd");
                val = UserGameLoginDays.UserLonggestLoginDays(userId, fromDate, toDate, dutyConfig.getGameId(), userTaskRecord.getServerId());
            }
            catch (ParseException e) {
                logger.error("getDutyReward ParseException:", e);
                val = 0;
            }
        }
        if (val < dutyConfig.getDutyValue()) {
            return MapEasyUtils.generateMap(-8, "\u4efb\u52a1\u672a\u5b8c\u6210");
        }
        this.releaseGift(dutyConfig, userId, userTaskRecord, taskId);
        return MapEasyUtils.generateMap(0, "success");
    }

    private void releaseGift(TaskDutyConfig dutyConfig, String userId, UserTaskRecord userTaskRecord, String taskId) {
        new Thread(new TaskReleaseGiftThread(dutyConfig, userId, userTaskRecord, taskId)).start();
    }
}

