/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.tasks;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xunlei.niux.client.jinzuan.CommonActivityClient;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.tasks.TaskDutyConfig;
import com.xunlei.niux.data.vipgame.vo.tasks.UserTaskRecord;
import com.xunlei.niux.data.vipgame.vo.tasks.UserTaskReleaseGiftRecord;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import org.slf4j.Logger;

public class TaskReleaseGiftThread
implements Runnable {
    private static Logger logger = Log.getLogger(TaskReleaseGiftThread.class);
    private static final String actNo = "taskcenteract";
    private TaskDutyConfig dutyConfig;
    private String userId;
    private UserTaskRecord userTaskRecord;
    private String taskId;
    private static String taskGameBonusPlus = EnvPropertyUtil.loadProperty("bonus", "taskgamebonusplus", "off");
    private static String taskGameBonusPlusStartTime = EnvPropertyUtil.loadProperty("bonus", "taskgamebonusplus_starttime");
    private static String taskGameBonusPlusEndTime = EnvPropertyUtil.loadProperty("bonus", "taskgamebonusplus_endtime");
    private static String taskGameBonusPlusMultiple = EnvPropertyUtil.loadProperty("bonus", "taskgamebonusplus_multiple", "1");

    public TaskReleaseGiftThread(TaskDutyConfig dutyConfig, String userId, UserTaskRecord userTaskRecord, String taskId) {
        this.dutyConfig = dutyConfig;
        this.userId = userId;
        this.userTaskRecord = userTaskRecord;
        this.taskId = taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String gameid = this.dutyConfig.getGameId();
        String giftId = this.dutyConfig.getRewardGiftId();
        String serverId = this.userTaskRecord.getServerId();
        this.updateRewardStatus(this.userTaskRecord, this.taskId);
        FacadeFactory.INSTANCE.getBaseSo().updateObjectById(this.userTaskRecord);
        UserTaskReleaseGiftRecord releaseGiftRecord = null;
        try {
            releaseGiftRecord = new UserTaskReleaseGiftRecord();
            releaseGiftRecord.setUserTaskRecordId(this.userTaskRecord.getSeqId());
            releaseGiftRecord.setUserId(this.userId);
            releaseGiftRecord.setGameId(gameid);
            releaseGiftRecord.setServerId(serverId);
            releaseGiftRecord.setTaskId(this.taskId);
            releaseGiftRecord.setGiftId(giftId);
            releaseGiftRecord.setReleaseStatus(false);
            String result = this.isTaskGameBonusPlusValid() ? CommonActivityClient.getGift(actNo, null, this.userId, giftId, "", false, Integer.parseInt(taskGameBonusPlusMultiple)) : CommonActivityClient.getGift(actNo, null, this.userId, giftId, "", false);
            logger.info("actNo:taskcenteract,userId:" + this.userId + ",giftId:" + giftId + " getGift result:" + result);
            JsonObject jsonResult = new JsonParser().parse(result).getAsJsonObject();
            int code = jsonResult.get("rtn").getAsInt();
            if (code != 0) {
                String msg = jsonResult.get("data").getAsString();
                logger.error("getGift ERROR:" + msg);
                throw new RuntimeException("getGift ERROR Code:" + code);
            }
            releaseGiftRecord.setReleaseStatus(true);
        }
        catch (Exception e) {
            logger.error("\u6e38\u620f\u79ef\u5206\u4efb\u52a1\u53d1\u653e\u5956\u54c1\u51fa\u9519\uff0c" + e);
        }
        finally {
            if (releaseGiftRecord != null) {
                FacadeFactory.INSTANCE.getBaseSo().addObject(releaseGiftRecord);
            }
        }
    }

    private boolean isTaskGameBonusPlusValid() throws Exception {
        if ("on".equals(taskGameBonusPlus)) {
            return DateUtil.isCurTimeInRange(taskGameBonusPlusStartTime, taskGameBonusPlusEndTime);
        }
        return false;
    }

    private void updateRewardStatus(UserTaskRecord userTaskRecord, String taskId) {
        if (taskId.equals("1")) {
            userTaskRecord.setReward1Status(true);
        } else if (taskId.equals("2")) {
            userTaskRecord.setReward2Status(true);
        } else if (taskId.equals("3")) {
            userTaskRecord.setReward3Status(true);
        } else if (taskId.equals("4")) {
            userTaskRecord.setReward4Status(true);
        }
    }
}

