/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.sqact;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.sqact.SqLotteryActPrize;
import com.xunlei.niux.center.thirdclient.CardClient;
import com.xunlei.niux.center.util.ActivityConstant;
import com.xunlei.niux.center.util.ActivityUtil;
import com.xunlei.niux.center.util.DateUtil;
import com.xunlei.niux.center.util.HttpClientUtil;
import com.xunlei.niux.center.util.Message;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.center.util.VipUtil;
import com.xunlei.niux.data.active.facade.FacadeFactory;
import com.xunlei.niux.data.active.vo.SqLotteryActLog;
import com.xunlei.niux.data.vipgame.vo.Activity;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class SqLotteryActCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(SqLotteryActCmd.class);
    private static final int POINT_SIZE = 1000;
    private static String sqGlodUrl = EnvPropertyUtil.loadProperty("niux", "sq_gold_url");

    @CmdMapper(value={"/sqlettery/actisinvalid.do"})
    public Object isinvalid(XLHttpRequest request, XLHttpResponse response) {
        int status = ActivityUtil.getActStatus(ActivityConstant.SQ_LOTTERY_ACT_NO);
        if (status <= 0) {
            return this.error(Message.ACT_PREPARE);
        }
        if (status >= 2) {
            return this.error(Message.ACT_END);
        }
        return JsonObjectUtil.getOnlyOkJson();
    }

    @CmdMapper(value={"/sqlettery/myPrize.do"})
    public Object myPrize(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            long userid = mainParam.getUserid();
            SqLotteryActLog sqLotteryActLog = new SqLotteryActLog();
            sqLotteryActLog.setUserid(userid);
            Page page = new Page();
            page.addOrder("lotterytime", OrderType.DESC);
            ArrayList prizeList = new ArrayList();
            for (SqLotteryActLog temp : FacadeFactory.INSTANCE.getSqLotteryActBo().find(sqLotteryActLog, page)) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("prizetype", temp.getPrizetype());
                map.put("prizecode", temp.getPrizecode());
                prizeList.add(map);
            }
            HashMap result = new HashMap();
            result.put("prizeList", prizeList);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            return this.error(Message.ERROR);
        }
    }

    @CmdMapper(value={"/sqlettery/prizeList.do"})
    public Object prizeList(XLHttpRequest request, XLHttpResponse response) {
        try {
            SqLotteryActLog sqLotteryActLog = new SqLotteryActLog();
            Page page = new Page(1, 10);
            page.addOrder("lotterytime", OrderType.DESC);
            ArrayList prizeList = new ArrayList();
            for (SqLotteryActLog temp : FacadeFactory.INSTANCE.getSqLotteryActBo().find(sqLotteryActLog, page)) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("username", temp.getUsername());
                map.put("prizename", temp.getPrizename());
                prizeList.add(map);
            }
            HashMap result = new HashMap();
            result.put("prizeList", prizeList);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.error("\u62bd\u5956\u63a5\u53e3\u5f02\u5e38", e);
            return this.error("\u7f51\u7edc\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CmdMapper(value={"/sqlettery/getPrize.do"})
    public Object getPrize(XLHttpRequest request, XLHttpResponse response) {
        int status = ActivityUtil.getActStatus(ActivityConstant.SQ_LOTTERY_ACT_NO);
        if (status <= 0) {
            return this.error(Message.ACT_PREPARE);
        }
        if (status >= 2) {
            return this.error(Message.ACT_END);
        }
        String serverid = request.getParameter("serverid");
        if (StringUtil.isEmpty(serverid)) {
            return this.error("\u7f3a\u5c11\u53c2\u6570");
        }
        try {
            String useridStr;
            MainParam mainParam = this.getMainParam(request, response, true);
            long userid = mainParam.getUserid();
            String string = useridStr = String.valueOf(userid).intern();
            synchronized (string) {
                Date today = DateUtil.parseByDefault(DateUtil.formatNow("yyyy-MM-dd") + " 00:00:00");
                if (this.countLotteryTimesByDate(userid, today) >= 30) {
                    return this.error(Message.getMessage("SQ_ACT_MAX_TIMES_LIMINT"));
                }
                int point = this.getPoint(mainParam, serverid);
                if (point < 100) {
                    return this.error(Message.getMessage("SQ_ACT_MAX_TIMES_FIRST"));
                }
                int times = (point - 100) / 1000 + 1;
                int countTimes = this.countLotteryTimes(mainParam.getUserid(), serverid);
                if ((times -= countTimes) > 0) {
                    SqLotteryActPrize prize = SqLotteryActPrize.getPrize();
                    String code = null;
                    String username = mainParam.getUserAccount();
                    if (!prize.isVip()) {
                        code = this.getCode(prize, userid, username);
                        if (code == null) {
                            code = this.getCode(SqLotteryActPrize.EXPERICE, userid, username);
                            if (code != null) {
                                prize = SqLotteryActPrize.EXPERICE;
                            } else {
                                code = this.getCode(SqLotteryActPrize.SERVEN, userid, username);
                                if (code == null) {
                                    return this.error(Message.getMessage("ERROR"));
                                }
                            }
                        }
                    } else if (this.countLotteryTimesByType(userid, prize.getPrizeType()) >= 4) {
                        code = this.getCode(SqLotteryActPrize.EXPERICE, userid, username);
                        if (code != null) {
                            prize = SqLotteryActPrize.EXPERICE;
                        } else {
                            return this.error(Message.getMessage("ERROR"));
                        }
                    }
                    if (prize.isVip() && !VipUtil.senderCash(String.valueOf(userid), "act_052", "777ef1c2-3f0f-4a66-ac1b-ab8c4497f0f3")) {
                        return this.error(Message.getMessage("ERROR"));
                    }
                    this.logPrize(userid, prize, serverid, URLDecoder.decode(request.getCookieValue("usernick", ""), "UTF-8"), code);
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("prizeType", prize.getPrizeType());
                    data.put("lotteryNum", times - 1);
                    if (code != null) {
                        data.put("code", code);
                    }
                    return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
                }
                return this.error(Message.getMessage("SQ_ACT_MAX_TIMES_NONE"));
            }
        }
        catch (Exception e) {
            logger.error("\u795e\u66f2\u62bd\u5956\u6d3b\u52a8\u5f02\u5e38", e);
            return this.error(Message.ERROR);
        }
    }

    private void logPrize(long userid, SqLotteryActPrize prize, String serverid, String userName, String code) {
        SqLotteryActLog lotteryLog = new SqLotteryActLog();
        lotteryLog.setUserid(userid);
        lotteryLog.setLotterytime(new Date());
        lotteryLog.setPrizetype(prize.getPrizeType());
        lotteryLog.setPrizename(prize.getPrizeName());
        lotteryLog.setServerid(serverid);
        lotteryLog.setUsername(userName);
        lotteryLog.setPrizecode(code);
        FacadeFactory.INSTANCE.getSqLotteryActBo().insert(lotteryLog);
    }

    private String getCode(SqLotteryActPrize prize, long userid, String username) {
        return CardClient.getCardCode("00069", "1", "gift", prize.getBatid(), userid, username, true);
    }

    private int countLotteryTimes(long userid) {
        return this.countLotteryTimes(userid, null, null);
    }

    private int countLotteryTimesByType(long userid, String prizeType) {
        return this.countLotteryTimes(userid, null, prizeType);
    }

    private int countLotteryTimesByDate(long userid, Date date) {
        return this.countLotteryTimes(userid, date, null);
    }

    private int countLotteryTimes(long userid, Date fromDate, String prizeType) {
        SqLotteryActLog lotteryActLog = new SqLotteryActLog();
        lotteryActLog.setUserid(userid);
        lotteryActLog.setFromLotterytime(fromDate);
        lotteryActLog.setPrizetype(prizeType);
        return FacadeFactory.INSTANCE.getSqLotteryActBo().count(lotteryActLog);
    }

    private int countLotteryTimes(long userid, String serverid) {
        SqLotteryActLog lotteryActLog = new SqLotteryActLog();
        lotteryActLog.setUserid(userid);
        lotteryActLog.setServerid(serverid);
        return FacadeFactory.INSTANCE.getSqLotteryActBo().count(lotteryActLog);
    }

    private int getPoint(MainParam mainParam, String serverid) {
        try {
            Activity activity = ActivityUtil.getActivityByActNo(ActivityConstant.SQ_LOTTERY_ACT_NO);
            if (activity == null) {
                throw new NullPointerException("\u83b7\u53d6\u6d3b\u52a8\u4e3aNULL");
            }
            long startTime = DateUtil.parseByDefault(activity.getStarttime()).getTime() / 1000L;
            long endTime = DateUtil.parseByDefault("2013-09-05 23:59:59").getTime() / 1000L;
            ObjectMapper mapper = new ObjectMapper();
            String url = String.format(sqGlodUrl, mainParam.getSessionid(), mainParam.getUserAccount(), serverid, startTime, endTime);
            String result = HttpClientUtil.get(url);
            Map map = mapper.readValue(result, Map.class);
            if ("0".equals(map.get("statues").toString())) {
                return Integer.valueOf(map.get("result").toString());
            }
            logger.warn("\u67e5\u8be2\u795e\u66f2\u94bb\u77f3\u6570\u9519\u8bef:{}", (Object)result);
            return 0;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u795e\u66f2\u94bb\u77f3\u6570\u5f02\u5e38", e);
            return 0;
        }
    }

    private String error(String errmsg) {
        return JsonObjectUtil.getRtnAndDataJsonObject(1, errmsg, null);
    }
}

