/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.report;

import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.proxy.JRedisProxy;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.util.Log;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.lang.StringUtils;
import org.jboss.netty.handler.codec.http.FileUpload;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.InterfaceHttpData;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class UploadFileCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(UploadFileCmd.class.getName());
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat sdf2 = new SimpleDateFormat("yyyyMMdd");
    private static SimpleDateFormat sdf3 = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private static final String SYNCPICCOMMOND = "/usr/local/bin/rsync_tempuploadfile_to_t05102.sh";
    public static final String UPLOAD_FILE_PATH = "/data/tempuploadfile/report/";
    public static final String UPLOAD_FILE_URL = "http://files.niu.xunlei.com";
    private static Set<String> fileType = new HashSet<String>();

    @CmdMapper(value={"/report/uploadfile.do"})
    public Object uploadFile(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            Integer hasUploadTimes;
            response.setHeader("Access-Control-Allow-Origin", "http://act.niu.xunlei.com");
            response.setHeader("Access-Control-Allow-Credentials", "true");
            response.setInnerContentType(XLHttpResponse.ContentType.plain);
            if (request.getMethod().equals(HttpMethod.OPTIONS)) {
                return JsonObjectUtil.getOnlyOkJson();
            }
            if (request.getMethod().equals(HttpMethod.GET)) {
                return JsonObjectUtil.getOnlyRtnJson(1);
            }
            MainParam mainParam = null;
            try {
                mainParam = this.getMainParam(request, response, true);
            }
            catch (Throwable e) {
                result.put("msg", "\u8bf7\u767b\u5f55");
                return JsonObjectUtil.getRtnAndDataJsonObject(1, result);
            }
            long userid = mainParam.getUserid();
            logger.info("[UPLOAD]userid:" + userid + ", HEADERS:" + request.getHeaders());
            List<InterfaceHttpData> datas = request.getHttpPostRequestDecoder().getBodyHttpDatas();
            if (datas.isEmpty()) {
                result.put("msg", "\u8bf7\u6c42\u7c7b\u578b\u5f02\u5e38");
                return JsonObjectUtil.getRtnAndDataJsonObject(2, result);
            }
            logger.info("###################dates:" + datas.toString());
            if (datas.get(0).getHttpDataType() != InterfaceHttpData.HttpDataType.FileUpload) {
                result.put("msg", "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
                return JsonObjectUtil.getRtnAndDataJsonObject(3, result);
            }
            int numOfReport = FacadeFactory.INSTANCE.getBaseSo().count("SELECT COUNT(1) FROM cheating_report WHERE providerUserId=? AND TO_DAYS(reportTime)=TO_DAYS(NOW())", new String[]{userid + ""});
            if (numOfReport >= 3) {
                result.put("msg", "\u4e00\u5929\u6700\u591a\u7533\u8bf7\u4e09\u6b21");
                return JsonObjectUtil.getRtnAndDataJsonObject(4, result);
            }
            String key = "NIUXREPORTUPLOADVIDEOTIMES_" + sdf2.format(new Date()) + "_" + userid;
            try {
                String tmpTimes = JRedisProxy.getInstance().get(key);
                hasUploadTimes = StringUtils.isEmpty(tmpTimes) || "nil".equals(tmpTimes) ? Integer.valueOf(0) : Integer.valueOf(tmpTimes);
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u4e0a\u4f20\u6b21\u6570\u5f02\u5e38", e);
                result.put("msg", "\u670d\u52a1\u5f02\u5e38");
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, result);
            }
            if (hasUploadTimes >= 5) {
                result.put("msg", "\u4e00\u5929\u6700\u591a\u4e0a\u4f205\u6b21\u89c6\u9891\uff0c\u8bf7\u660e\u5929\u518d\u8bd5\u5457~");
                return JsonObjectUtil.getRtnAndDataJsonObject(5, result);
            }
            String msg = this.writeHttpData(datas.get(0), userid);
            if (!msg.startsWith("http")) {
                result.put("msg", msg);
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, result);
            }
            String uploadKey = Md5Encrypt.md5(msg);
            hasUploadTimes = hasUploadTimes + 1;
            if (!JRedisProxy.getInstance().set(key, hasUploadTimes + "", 86400)) {
                logger.error("\u65e0\u6cd5\u5728Redis\u4e2d\u4fdd\u5b58\u4fe1\u606f\uff01msg=" + msg);
                result.put("msg", "\u670d\u52a1\u5f02\u5e38");
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, result);
            }
            JRedisProxy.getInstance().set(uploadKey, msg, 86400);
            logger.info("########UploadFileCmd Completed######## \nDATA:" + datas.get(0).toString() + "\nuserid=" + userid + "\nrtn key=" + uploadKey + ", value=" + msg + "\n##############END##################");
            result.put(datas.get(0).getName(), uploadKey);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            result.put("msg", "\u4e0a\u4f20\u5931\u8d25");
            logger.error("\u4e0a\u4f20\u51fa\u73b0\u5f02\u5e38", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, result);
        }
    }

    private String writeHttpData(InterfaceHttpData data, long userid) {
        String errMsg = "-1";
        try {
            logger.info("####\u6587\u4ef6\u4e0a\u4f20\u5f00\u59cb####" + data.toString() + ", updateFilePath:" + UPLOAD_FILE_PATH + ", userid:" + userid);
            FileUpload fileUpload = (FileUpload)data;
            if (this.notAllowType(fileUpload.getContentType(), fileUpload.getFilename())) {
                logger.error("\u975e\u6cd5\u4e0a\u4f20\u7c7b\u578b: userid:" + userid + ", file:" + data.toString());
                errMsg = "\u975e\u6cd5\u4e0a\u4f20\u7c7b\u578b";
                return errMsg;
            }
            if (this.overLimitedSize(fileUpload.length())) {
                logger.error("\u4e0a\u4f20\u6587\u4ef6\u6700\u592710M: userid:" + userid + ", file:" + data.toString());
                errMsg = "\u4e0a\u4f20\u6587\u4ef6\u6700\u59274M";
                return errMsg;
            }
            if (fileUpload.isCompleted()) {
                String type = fileUpload.getFilename().substring(fileUpload.getFilename().indexOf("."));
                String newFileName = "CHEATINGREPORT" + userid + "_" + sdf3.format(new Date());
                File destZip = new File(UPLOAD_FILE_PATH + newFileName + ".zip");
                if (destZip.exists()) {
                    destZip.delete();
                }
                ZipFile zipFile = new ZipFile(destZip.getAbsolutePath());
                ZipParameters parameters = new ZipParameters();
                parameters.setCompressionMethod(8);
                parameters.setCompressionLevel(5);
                parameters.setFileNameInZip(userid + "" + System.currentTimeMillis() + type);
                parameters.setSourceExternalStream(true);
                zipFile.addFile(fileUpload.getFile(), parameters);
                if (this.sync(destZip.getAbsolutePath(), newFileName + ".zip")) {
                    String url = "http://files.niu.xunlei.com/report/" + newFileName + ".zip";
                    logger.info("\u4e0a\u4f20\u5b8c\u6210:" + url);
                    errMsg = url;
                } else {
                    logger.info("\u4e0a\u4f20\u5931\u8d25:\u540c\u6b65\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5f02\u5e38\uff01data:" + data.toString() + ", userid:" + userid);
                    errMsg = "\u670d\u52a1\u5668\u5f02\u5e38sy";
                }
                destZip.delete();
            } else {
                errMsg = "\u8bf7\u7a0d\u540e\u4e0a\u4f20";
            }
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38" + data.toString() + ", userid:" + userid, e);
            errMsg = "\u670d\u52a1\u5668\u5f02\u5e38";
        }
        return errMsg;
    }

    private boolean overLimitedSize(long length) {
        return length > 0xA00000L;
    }

    private boolean notAllowType(String contentType, String fileName) {
        logger.info("contentType=" + contentType + ", " + fileName.substring(fileName.indexOf(".") + 1));
        return !contentType.startsWith("video") && !fileType.contains(fileName.substring(fileName.indexOf(".") + 1));
    }

    private boolean sync(String filePathName, String fileName) throws Exception {
        String cmd = "/usr/local/bin/rsync_tempuploadfile_to_t05102.sh " + filePathName + " report/" + fileName;
        logger.info("[SYNC]exec:" + cmd);
        int r = Runtime.getRuntime().exec(cmd).waitFor();
        logger.info("[SYNC]result:" + r);
        return 0 == r;
    }

    static {
        fileType.add("wma");
        fileType.add("WMA");
        fileType.add("rm");
        fileType.add("RM");
        fileType.add("rmb");
        fileType.add("RMB");
        fileType.add("rmvb");
        fileType.add("RMVB");
        fileType.add("mpg");
        fileType.add("MPG");
        fileType.add("mpeg");
        fileType.add("MPEG");
        fileType.add("mov");
        fileType.add("MOV");
        fileType.add("mp4");
        fileType.add("MP4");
        fileType.add("m4v");
        fileType.add("M4V");
        fileType.add("flv");
        fileType.add("FLV");
        fileType.add("avi");
        fileType.add("AVI");
        fileType.add("mkv");
        fileType.add("MKV");
        fileType.add("vob");
        fileType.add("VOB");
        fileType.add("3gp");
        fileType.add("3GP");
        fileType.add("f4v");
        fileType.add("F4V");
        fileType.add("swf");
        fileType.add("SWF");
    }
}

