/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.report;

import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.thirdclient.report.ReportInfo;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.util.Log;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

@Service
public class ReportCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(ReportCmd.class.getName());
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static String SIGNKEY = "6feij9f0-8aa7-41bf-bcd1-74e45617dd9b5";

    @CmdMapper(value={"/report/report.do"})
    public Object report(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        HashMap<String, String> result = new HashMap<String, String>();
        String callback = "callback";
        try {
            Date time;
            MainParam mainParam = this.getMainParam(request, response, true);
            callback = request.getParameter("callback", "callback");
            String gameid = request.getParameter("gameid", "");
            String serverid = request.getParameter("serverid", "");
            String rolename = request.getParameter("rolename", "");
            String reason = request.getParameter("reason", "");
            String user = mainParam.getUserid() + "";
            if (StringUtils.isEmpty(gameid) || StringUtils.isEmpty(serverid) || StringUtils.isEmpty(rolename) || StringUtils.isEmpty(user)) {
                logger.info("report parameter not valid.gameid" + gameid + ",serverid:" + serverid + ",rolename:" + rolename + ",user:" + user);
                result.put("code", "1");
                result.put("msg", "\u53c2\u6570\u9519\u8bef");
                return callback + "(" + JsonObjectUtil.getRtnAndDataJsonObject(0, result) + ")";
            }
            String ip = request.getHeader("X-Real-IP");
            if (StringUtils.isEmpty(ip)) {
                ip = request.getRemoteIP();
            }
            if (!this.checkUserCanReport(user, time = new Date(), 10, 1)) {
                logger.error("[report]report too many times for ip:" + ip + ",time:" + time + ",intervals:" + 30 + "S,times:" + 10);
                result.put("code", "3");
                result.put("msg", "\u4e3e\u62a5\u6b21\u6570\u53d7\u9650");
                return callback + "(" + JsonObjectUtil.getRtnAndDataJsonObject(0, result) + ")";
            }
            try {
                rolename = URLDecoder.decode(rolename, "utf8");
            }
            catch (Exception e) {
                logger.error("[report]url decode rolename:" + rolename, e);
            }
            ReportInfo report = new ReportInfo();
            report.setGameid(gameid);
            report.setServerid(serverid);
            report.setRolename(rolename);
            report.setReason(reason);
            report.setUser(user);
            report.setIp(ip);
            report.setReason(reason);
            report.setStatus(0);
            report.setTime(sdf.format(time));
            FacadeFactory.INSTANCE.getBaseSo().addObject(report);
            result.put("code", "0");
            result.put("msg", "\u4e3e\u62a5\u6210\u529f");
        }
        catch (NiuRuntimeException e) {
            result.put("code", "99");
            result.put("msg", e.getMessage());
        }
        catch (DataIntegrityViolationException e) {
            result.put("code", "4");
            result.put("msg", "\u60a8\u5df2\u4e3e\u62a5\u8fc7\u8be5\u73a9\u5bb6");
            logger.error("\u60a8\u5df2\u4e3e\u62a5\u8fc7\u8be5\u73a9\u5bb6", e);
        }
        catch (Exception e) {
            result.put("code", "99");
            result.put("msg", "\u4e3e\u62a5\u5931\u8d25");
            logger.error("\u4e3e\u62a5\u51fa\u73b0\u5f02\u5e38", e);
        }
        return callback + "(" + JsonObjectUtil.getRtnAndDataJsonObject(0, result) + ")";
    }

    @CmdMapper(value={"/report/reportAPI.do"})
    public Object reportAPI(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            Date time;
            String gameid = request.getParameter("gameid", "");
            String serverid = request.getParameter("serverid", "");
            String rolename = request.getParameter("rolename", "");
            String reason = request.getParameter("reason", "");
            String user = request.getParameter("user", "");
            String sign = request.getParameter("sign", "");
            if (StringUtils.isEmpty(gameid) || StringUtils.isEmpty(serverid) || StringUtils.isEmpty(rolename) || StringUtils.isEmpty(user) || StringUtils.isEmpty(sign)) {
                logger.info("report parameter not valid.gameid" + gameid + ",serverid:" + serverid + ",rolename:" + rolename + ",user:" + user);
                result.put("code", "1");
                result.put("msg", "\u53c2\u6570\u9519\u8bef");
                return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
            }
            String signStr = gameid + serverid + rolename + user + SIGNKEY;
            logger.info("[reportBox]signStr:" + gameid + serverid + rolename + user);
            String newSign = Md5Encrypt.md5(signStr);
            if (!newSign.equals(sign)) {
                logger.info("[reportBox]token not valid");
                result.put("code", "2");
                result.put("msg", "\u7b7e\u540d\u9519\u8bef");
                return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
            }
            String ip = request.getHeader("X-Real-IP");
            if (StringUtils.isEmpty(ip)) {
                ip = request.getRemoteIP();
            }
            if (!this.checkIpCanReport(ip, time = new Date(), 10, 1)) {
                logger.error("[report]report too many times for ip:" + ip + ",time:" + time + ",intervals:" + 30 + "S,times:" + 10);
                result.put("code", "3");
                result.put("msg", "\u4e3e\u62a5\u6b21\u6570\u53d7\u9650");
                return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
            }
            try {
                rolename = URLDecoder.decode(rolename, "utf8");
            }
            catch (Exception e) {
                logger.error("[report]url decode rolename:" + rolename, e);
            }
            ReportInfo report = new ReportInfo();
            report.setGameid(gameid);
            report.setServerid(serverid);
            report.setRolename(rolename);
            report.setReason(reason);
            report.setUser(user);
            report.setIp(ip);
            report.setStatus(0);
            report.setTime(sdf.format(time));
            FacadeFactory.INSTANCE.getBaseSo().addObject(report);
            result.put("code", "0");
            result.put("msg", "\u4e3e\u62a5\u6210\u529f");
        }
        catch (NiuRuntimeException e) {
            result.put("code", "99");
            result.put("msg", e.getMessage());
        }
        catch (DataIntegrityViolationException e) {
            result.put("code", "4");
            result.put("msg", "\u60a8\u5df2\u4e3e\u62a5\u8fc7\u8be5\u73a9\u5bb6");
            logger.error("\u60a8\u5df2\u4e3e\u62a5\u8fc7\u8be5\u73a9\u5bb6", e);
        }
        catch (Exception e) {
            result.put("code", "99");
            result.put("msg", "\u4e3e\u62a5\u5931\u8d25");
            logger.error("\u4e3e\u62a5\u51fa\u73b0\u5f02\u5e38", e);
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
    }

    private boolean checkUserCanReport(String user, Date time, int intervals, int maxTimes) {
        if (user == null || "".equals(user)) {
            return true;
        }
        if (time == null) {
            return true;
        }
        if (intervals <= 0) {
            return true;
        }
        if (maxTimes < 1) {
            return true;
        }
        String beginTime = sdf.format(time.getTime() - (long)(intervals * 1000));
        String endTime = sdf.format(time.getTime() + (long)(intervals * 1000));
        Object[] args = new Object[]{beginTime, endTime, user, maxTimes};
        String sql = "select count(*) from report where time >= ? and time <= ? and user = ? limit ?";
        int countTimes = FacadeFactory.INSTANCE.getBaseSo().count(sql, args);
        return countTimes < maxTimes;
    }

    private boolean checkIpCanReport(String ip, Date time, int intervals, int maxTimes) {
        if (ip == null || "".equals(ip)) {
            return true;
        }
        if (time == null) {
            return true;
        }
        if (intervals <= 0) {
            return true;
        }
        if (maxTimes < 1) {
            return true;
        }
        if ("119.145.40.161".equals(ip)) {
            return true;
        }
        String beginTime = sdf.format(time.getTime() - (long)(intervals * 1000));
        String endTime = sdf.format(time.getTime() + (long)(intervals * 1000));
        Object[] args = new Object[]{beginTime, endTime, ip, maxTimes};
        String sql = "select count(*) from report where time >= ? and time <= ? and ip = ? limit ?";
        int countTimes = FacadeFactory.INSTANCE.getBaseSo().count(sql, args);
        return countTimes < maxTimes;
    }
}

