/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.report;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.proxy.JRedisProxy;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CheatingReport;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class CheatingReportCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(CheatingReportCmd.class.getName());
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @CmdMapper(value={"/report/savecheating.do"})
    public Object saveCheating(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String videoUrl;
            MainParam mainParam = this.getMainParam(request, response, true);
            String providerGameId = request.getParameter("wdyx");
            String providerServerId = request.getParameter("wdqf");
            String providerRoleName = request.getParameter("wdjsm");
            String providerUserId = mainParam.getUserid() + "";
            String reportTime = DateUtil.formatNowByDefault();
            String cheaterGameId = request.getParameter("bjbwjyx");
            String cheaterRoleName = request.getParameter("bjbwjjsm");
            String cheaterServerId = request.getParameter("bjbwjqf");
            String timeOfCheating = request.getParameter("sywgsj");
            String descOfCheating = request.getParameter("wgms");
            String videoOfCheating = request.getParameter("wgsp");
            String urlOfCheating = request.getParameter("hwglj");
            if (StringUtils.isEmpty(providerGameId) || StringUtils.isEmpty(providerServerId) || StringUtils.isEmpty(providerRoleName) || StringUtils.isEmpty(providerUserId) || StringUtils.isEmpty(cheaterGameId) || StringUtils.isEmpty(cheaterRoleName) || StringUtils.isEmpty(cheaterServerId) || StringUtils.isEmpty(timeOfCheating) || StringUtils.isEmpty(descOfCheating) || StringUtils.isEmpty(videoOfCheating) && StringUtils.isEmpty(urlOfCheating)) {
                logger.error("[saveCheating]" + request.getParameters());
                result.put("msg", "\u53c2\u6570\u9519\u8bef");
                return JsonObjectUtil.getRtnAndDataJsonObject(1, result);
            }
            int numOfReport = FacadeFactory.INSTANCE.getBaseSo().count("SELECT COUNT(1) FROM cheating_report WHERE providerUserId=? AND TO_DAYS(reportTime)=TO_DAYS(NOW())", new String[]{providerUserId + ""});
            if (numOfReport >= 3) {
                result.put("msg", "\u6bcf\u5929\u5929\u6700\u591a\u7533\u8bf7\u4e09\u6b21");
                return JsonObjectUtil.getRtnAndDataJsonObject(2, result);
            }
            CheatingReport cheatingReport = new CheatingReport();
            cheatingReport.setProviderGameId(providerGameId);
            cheatingReport.setProviderServerId(providerServerId);
            cheatingReport.setProviderRoleName(providerRoleName);
            cheatingReport.setProviderUserId(providerUserId);
            cheatingReport.setReportTime(reportTime);
            cheatingReport.setCheaterGameId(cheaterGameId);
            cheatingReport.setCheaterServerId(cheaterServerId);
            cheatingReport.setCheaterRoleName(cheaterRoleName);
            cheatingReport.setTimeOfCheating(timeOfCheating);
            cheatingReport.setDescOfCheating(descOfCheating);
            try {
                if (StringUtils.isEmpty(videoOfCheating)) {
                    videoUrl = "";
                } else {
                    String url = JRedisProxy.getInstance().get(videoOfCheating);
                    if (StringUtils.isEmpty(url) || "nil".equals(url)) {
                        result.put("msg", "\u6570\u636e\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u89c6\u9891");
                        return JsonObjectUtil.getRtnAndDataJsonObject(3, result);
                    }
                    videoUrl = url;
                }
            }
            catch (Exception e) {
                videoUrl = "-1";
            }
            cheatingReport.setVideoOfCheating(videoUrl);
            cheatingReport.setUrlOfCheating(urlOfCheating == null ? "" : urlOfCheating);
            cheatingReport.setLockSeconds(-1L);
            cheatingReport.setStatus(1);
            FacadeFactory.INSTANCE.getBaseSo().addObject(cheatingReport);
            return JsonObjectUtil.getOnlyOkJson();
        }
        catch (Exception e) {
            logger.error("\u4e3e\u62a5\u51fa\u73b0\u5f02\u5e38", e);
            result.put("msg", "\u6570\u636e\u5f02\u5e38");
            return JsonObjectUtil.getRtnAndDataJsonObject(99, result);
        }
    }

    @CmdMapper(value={"/report/findcheating.do"})
    public Object findCheating(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String providerUserId = mainParam.getUserid() + "";
            if (StringUtils.isEmpty(providerUserId)) {
                logger.error("[findCheating]" + request.getParameters());
                result.put("msg", "\u53c2\u6570\u9519\u8bef");
                return JsonObjectUtil.getRtnAndDataJsonObject(1, result);
            }
            CheatingReport cheatingReport = new CheatingReport();
            cheatingReport.setProviderUserId(providerUserId);
            Page page = new Page();
            page.addOrder("reportTime", OrderType.DESC);
            List<CheatingReport> cheatingReportList = FacadeFactory.INSTANCE.getBaseSo().findObjects(cheatingReport, page);
            ArrayList dataList = new ArrayList();
            for (CheatingReport cr : cheatingReportList) {
                String cljg;
                HashMap<String, String> dataMap = new HashMap<String, String>();
                dataMap.put("tjsj", cr.getReportTime());
                dataMap.put("bjbrjsm", cr.getCheaterRoleName());
                switch (cr.getStatus()) {
                    case 1: {
                        cljg = "\u672a\u5904\u7406";
                        break;
                    }
                    case 2: {
                        cljg = "\u5df2\u5c01\u7981";
                        break;
                    }
                    case 3: {
                        cljg = "\u4e0d\u5c01\u7981";
                        break;
                    }
                    case 4: {
                        cljg = "\u4e0d\u5904\u7406";
                        break;
                    }
                    default: {
                        cljg = "\u672a\u77e5";
                    }
                }
                dataMap.put("cljg", cljg);
                dataList.add(dataMap);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, dataList);
        }
        catch (Exception e) {
            logger.error("\u4e3e\u62a5\u51fa\u73b0\u5f02\u5e38", e);
            result.put("msg", "\u6570\u636e\u5f02\u5e38");
            return JsonObjectUtil.getRtnAndDataJsonObject(99, result);
        }
    }
}

