/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.rebate;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.channel.util.UserUtility;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.thirdclient.JinZuanClient;
import com.xunlei.niux.center.thirdclient.SmsClient;
import com.xunlei.niux.center.util.SignUtil;
import com.xunlei.niux.client.yuanbao.YuanBaoClient;
import com.xunlei.niux.common.exception.NiuExceptionAndCode;
import com.xunlei.niux.common.util.Arith;
import com.xunlei.niux.data.vip.facade.FacadeFactory;
import com.xunlei.niux.data.vip.vo.UserRebateInfo;
import com.xunlei.niux.data.vip.vo.UserRebateRecord;
import com.xunlei.niux.data.vip.vo.UserRebateUseRecord;
import com.xunlei.niux.data.vipgame.vo.CustomerInfo;
import com.xunlei.niux.data.vipgame.vo.GamePayInfo;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.easyutils.commonutils.OrderNoUtil;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class UserRebateCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(UserRebateCmd.class.getName());
    private static SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
    private static String rebateKey = EnvPropertyUtil.loadProperty("viprebate", "rebateKey");
    private static String rebateIps = EnvPropertyUtil.loadProperty("viprebate", "rebateIps");

    @CmdMapper(value={"/rebate/addrebaterecord.do"})
    public Object addRebateRecord(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String actNo = request.getParameter("actno", "");
        String payOrderNo = request.getParameter("orderid", "");
        String userId = request.getParameter("userid", "");
        String gameId = request.getParameter("gameid", "");
        String serverId = request.getParameter("serverid", "");
        String totalMoneyStr = request.getParameter("totalmoney");
        String payMoneyStr = request.getParameter("payMoney");
        double totalMoney = request.getParameterDouble("totalmoney");
        double payMoney = request.getParameterDouble("payMoney");
        double vipfate = request.getParameterDouble("vipfate");
        long timestamp = request.getParameterLong("time");
        String roleId = request.getParameter("roleid", "");
        String roleName = "";
        String sign = request.getParameter("sign", "");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String ip = UserRebateCmd.getClientIp(request);
        if (!rebateIps.contains("|" + ip + "|")) {
            resultMap.put("code", 1);
            resultMap.put("msg", "ip[" + ip + "]\u975e\u6cd5");
            return JsonObjectUtil.getDataJsonObject(resultMap);
        }
        if (System.currentTimeMillis() / 1000L - timestamp > 300L) {
            resultMap.put("code", 1);
            resultMap.put("msg", "\u56de\u8c03\u94fe\u63a5\u65e0\u6548");
            return JsonObjectUtil.getDataJsonObject(resultMap);
        }
        if (!actNo.equals("niuxzfzx") && !"daojupay".equals(actNo)) {
            resultMap.put("code", 1);
            resultMap.put("msg", "\u6d3b\u52a8\u7f16\u53f7\u9519\u8bef");
            return JsonObjectUtil.getDataJsonObject(resultMap);
        }
        if ("".equals(payOrderNo) || "".equals(userId) || "".equals(gameId) || "".equals(sign)) {
            resultMap.put("code", 1);
            resultMap.put("msg", "\u53c2\u6570\u4e3a\u7a7a");
            return JsonObjectUtil.getDataJsonObject(resultMap);
        }
        if (totalMoney < payMoney || payMoney <= 0.0) {
            resultMap.put("code", 1);
            resultMap.put("msg", "\u652f\u4ed8\u91d1\u989d\u9519\u8bef");
            return JsonObjectUtil.getDataJsonObject(resultMap);
        }
        if (vipfate < 0.0) {
            resultMap.put("code", 1);
            resultMap.put("msg", "\u8fd4\u5229\u6bd4\u7387\u9519\u8bef");
            return JsonObjectUtil.getDataJsonObject(resultMap);
        }
        String newSign = SignUtil.sign(actNo + payOrderNo + userId + gameId + serverId + totalMoneyStr + payMoneyStr + vipfate + timestamp, rebateKey);
        if (!newSign.equals(sign)) {
            resultMap.put("code", 1);
            resultMap.put("msg", "\u7b7e\u540d\u9519\u8bef");
            return JsonObjectUtil.getDataJsonObject(resultMap);
        }
        gameId = gameId.length() == 5 ? "0" + gameId : gameId;
        UserRebateRecord queryUserRebateRecord = new UserRebateRecord();
        queryUserRebateRecord.setPayOrderNo(payOrderNo);
        queryUserRebateRecord = FacadeFactory.INSTANCE.getBaseBo().findObject(queryUserRebateRecord);
        if (queryUserRebateRecord != null && userId.equals(queryUserRebateRecord.getUserId())) {
            resultMap.put("code", 0);
            resultMap.put("msg", "\u91cd\u590d\u8ba2\u5355");
            return JsonObjectUtil.getDataJsonObject(resultMap);
        }
        if (queryUserRebateRecord != null && !userId.equals(queryUserRebateRecord.getUserId())) {
            resultMap.put("code", 1);
            resultMap.put("msg", "\u91cd\u590d\u5f02\u5e38\u8ba2\u5355\uff08\u5206\u5c5e\u4e0d\u540c\u7684\u7528\u6237\uff09");
            return JsonObjectUtil.getDataJsonObject(resultMap);
        }
        int rebateMoney = (int)Arith.mul(payMoney, vipfate);
        try {
            UserRebateRecord rebateRecord = new UserRebateRecord();
            rebateRecord.setUserId(userId);
            rebateRecord.setServerId(serverId);
            rebateRecord.setRoleId(roleId);
            rebateRecord.setRoleName(roleName);
            rebateRecord.setRebateNo(OrderNoUtil.getOrderNo());
            rebateRecord.setRebateMoney(rebateMoney);
            rebateRecord.setPayOrderNo(payOrderNo);
            rebateRecord.setPayOrderMoney(Double.valueOf(payMoney).intValue());
            rebateRecord.setJinKaVipLevel(0);
            rebateRecord.setGameId(gameId);
            String serverName = this.getServerName(gameId, serverId);
            if (serverName.equals("")) {
                logger.error("\u53d6\u4e0d\u5230\u5206\u533a\u4fe1\u606f\uff1agameId:" + gameId + ",serverid=" + serverId);
            }
            rebateRecord.setServerName(serverName);
            FacadeFactory.INSTANCE.getUserRebateBo().addRebateRecord(rebateRecord);
            resultMap.put("code", 0);
            resultMap.put("msg", "success");
            return JsonObjectUtil.getDataJsonObject(resultMap);
        }
        catch (Exception e) {
            logger.error("\u7528\u6237[" + userId + "]\u652f\u4ed8\u8ba2\u5355[" + payOrderNo + "]\u8fd4\u5229\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage(), e);
            resultMap.put("code", 1);
            resultMap.put("msg", e.getMessage());
            return JsonObjectUtil.getDataJsonObject(resultMap);
        }
    }

    private String getServerName(String gameId, String serverId) {
        return "".equals(serverId) ? "" : this.getFenQuName(gameId, serverId);
    }

    @CmdMapper(value={"/rebate/userebate.do"})
    @Deprecated
    public Object useRebate(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        String rebateNos = request.getParameter("rebateNos", "");
        String gameId = request.getParameter("gameId", "");
        String serverId = request.getParameter("serverId", "");
        String roleId = request.getParameter("roleId", "");
        String roleName = request.getParameter("roleName", "");
        int useMoney = request.getParameterInteger("useMoney");
        String cusrname = request.getCookieValue("usrname");
        if (useMoney == 0) {
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u4f7f\u7528\u91d1\u989d\u4e3a\u96f6", null);
        }
        try {
            this.checkGiftGameInfoValid(gameId, serverId, roleId);
            String[] rebateNoArray = rebateNos.split("\\|");
            int useMoneyTemp = this.calRebateUseMoney(rebateNoArray, userId);
            if (useMoney != useMoneyTemp) {
                return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u91d1\u989d\u975e\u6cd5", null);
            }
            UserRebateUseRecord rebateUseRecord = new UserRebateUseRecord();
            rebateUseRecord.setGameId(gameId);
            rebateUseRecord.setServerId(serverId);
            rebateUseRecord.setRoleId(roleId);
            rebateUseRecord.setUseRecordNo(OrderNoUtil.getOrderNo());
            rebateUseRecord.setUserId(userId);
            rebateUseRecord.setUseMoney(useMoneyTemp);
            rebateUseRecord.setRoleName(roleName);
            String serverName = this.getServerName(gameId, serverId);
            if (serverName.equals("")) {
                logger.error("\u53d6\u4e0d\u5230\u5206\u533a\u4fe1\u606f\uff1agameId:" + gameId + ",serverid=" + serverId);
            }
            rebateUseRecord.setServerName(serverName);
            if (("000001".equals(gameId) || "000004".equals(gameId)) && rebateUseRecord.getUseMoney() < 10) {
                return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u6e38\u620f[" + gameId + "]\u91d1\u989d\u975e\u6cd5", null);
            }
            rebateUseRecord.setUseMoney(rebateUseRecord.getUseMoney());
            FacadeFactory.INSTANCE.getUserRebateBo().addRebateUseRecord(rebateUseRecord, rebateNoArray);
            rebateUseRecord = this.giveOutGameYuanBao(rebateUseRecord);
            if ("S".equals(rebateUseRecord.getUseStatus())) {
                return JsonObjectUtil.getRtnAndDataJsonObject(0, "success", null);
            }
            FacadeFactory.INSTANCE.getUserRebateBo().updateFailUseRecord(rebateUseRecord.getUserId(), rebateUseRecord.getUseRecordNo());
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u53d1\u653e\u5931\u8d25", null);
        }
        catch (Exception e) {
            logger.error("\u7528\u6237[" + userId + "]\u4f7f\u7528\u8fd4\u5229[" + rebateNos + "]\u51fa\u73b0\u5f02\u5e38", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u4f7f\u7528\u5931\u8d25", null);
        }
    }

    @CmdMapper(value={"/rebate/userebatenew.do"})
    @Deprecated
    public Object useRebatenew(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        String rebateNos = request.getParameter("rebateNos", "");
        String gameId = request.getParameter("gameId", "");
        String serverId = request.getParameter("serverId", "");
        String roleId = request.getParameter("roleId", "");
        String roleName = request.getParameter("roleName", "");
        int useMoney = request.getParameterInteger("useMoney");
        String cusrname = request.getCookieValue("usrname");
        try {
            if (useMoney == 0) {
                return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u4f7f\u7528\u91d1\u989d\u4e3a\u96f6", null);
            }
            this.checkGiftGameInfoValid(gameId, serverId, roleId);
            String[] rebateNoArray = rebateNos.split("\\|");
            int useMoneyTemp = this.calRebateUseMoney(rebateNoArray, userId);
            if (useMoney != useMoneyTemp) {
                return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u91d1\u989d\u975e\u6cd5", null);
            }
            UserRebateUseRecord rebateUseRecord = new UserRebateUseRecord();
            rebateUseRecord.setGameId(gameId);
            rebateUseRecord.setServerId(serverId);
            rebateUseRecord.setRoleId(roleId);
            rebateUseRecord.setUseRecordNo(OrderNoUtil.getOrderNo());
            rebateUseRecord.setUserId(userId);
            rebateUseRecord.setUseMoney(useMoneyTemp);
            rebateUseRecord.setRoleName(roleName);
            String serverName = this.getServerName(gameId, serverId);
            if (serverName.equals("")) {
                logger.error("\u53d6\u4e0d\u5230\u5206\u533a\u4fe1\u606f\uff1agameId:" + gameId + ",serverid=" + serverId);
            }
            rebateUseRecord.setServerName(serverName);
            if (("000001".equals(gameId) || "000004".equals(gameId)) && rebateUseRecord.getUseMoney() < 10) {
                return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u6e38\u620f[" + gameId + "]\u91d1\u989d\u975e\u6cd5", null);
            }
            rebateUseRecord.setUseMoney(rebateUseRecord.getUseMoney());
            FacadeFactory.INSTANCE.getUserRebateBo().addRebateUseRecord(rebateUseRecord, rebateNoArray);
            rebateUseRecord = this.giveOutGameYuanBao(rebateUseRecord);
            if ("S".equals(rebateUseRecord.getUseStatus())) {
                CustomerInfo customer;
                CustomerInfo info = new CustomerInfo();
                info.setUid(userId);
                List<CustomerInfo> infolist = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getCustomerInfoBo().find(info, new Page());
                if (infolist != null && infolist.size() > 0 && (customer = infolist.get(0)) != null && !StringTools.isEmpty(customer.getPhone())) {
                    Games games = new Games();
                    games.setGameId(gameId);
                    List<Games> gamelist = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getGamesBo().findGames(games, new Page());
                    if (gamelist == null || gamelist.size() == 0) {
                        return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u8be5\u6e38\u620f\u4e0d\u5b58\u5728", null);
                    }
                    Games game = gamelist.get(0);
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("\u5c0a\u8d35\u7684\u91d1\u5361\u7528\u6237\uff0c\u60a8\u597d\uff1a\u60a8\u4e8e").append(UserRebateCmd.now()).append("\u5728\u725bx\u5e73\u53f0\u91d1\u5361\u4e13\u533a\u6210\u529f\u63d0\u53d6\u8fd4\u5229\uff1a").append(rebateUseRecord.getUseMoney()).append("\u5143\uff0c\u8fd4\u5229\u4f7f\u7528\u6e38\u620f\uff1a").append(game.getGameName());
                    SmsClient.sendSms(customer.getPhone(), buffer.toString());
                }
                return JsonObjectUtil.getRtnAndDataJsonObject(0, "success", null);
            }
            FacadeFactory.INSTANCE.getUserRebateBo().updateFailUseRecord(rebateUseRecord.getUserId(), rebateUseRecord.getUseRecordNo());
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u53d1\u653e\u5931\u8d25", null);
        }
        catch (Exception e) {
            logger.error("\u7528\u6237[" + userId + "]\u4f7f\u7528\u8fd4\u5229[" + rebateNos + "]\u51fa\u73b0\u5f02\u5e38", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u4f7f\u7528\u5931\u8d25", null);
        }
    }

    @CmdMapper(value={"/rebate/userebatejinzuan.do"})
    public Object useRebateJinZuan(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        String rebateNos = request.getParameter("rebateNos", "");
        String gameId = request.getParameter("gameId", "");
        String serverId = request.getParameter("serverId", "");
        String roleId = request.getParameter("roleId", "");
        String roleName = request.getParameter("roleName", "");
        int useMoney = request.getParameterInteger("useMoney");
        String cusrname = request.getCookieValue("usrname");
        try {
            int jinzuanflag = JinZuanClient.isJinZuanUser(userId);
            if (jinzuanflag == -1) {
                return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u91d1\u94bb\u4fe1\u606f\u67e5\u8be2\u5931\u8d25", null);
            }
            if (jinzuanflag == 1) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u975e\u91d1\u94bb\u7528\u6237", null);
            }
            if (jinzuanflag == 2) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u8be5\u91d1\u94bb\u7528\u6237\u5df2\u8fc7\u671f", null);
            }
            if (jinzuanflag == 3) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u4f53\u9a8c\u4f1a\u5458\u4e0d\u4eab\u6709\u8be5\u9879\u7279\u6743", null);
            }
            if (useMoney == 0) {
                return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u4f7f\u7528\u91d1\u989d\u4e3a\u96f6", null);
            }
            this.checkGiftGameInfoValid(gameId, serverId, roleId);
            String[] rebateNoArray = rebateNos.split("\\|");
            int useMoneyTemp = this.calRebateUseMoney(rebateNoArray, userId);
            if (useMoney != useMoneyTemp) {
                return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u91d1\u989d\u975e\u6cd5", null);
            }
            UserRebateUseRecord rebateUseRecord = new UserRebateUseRecord();
            rebateUseRecord.setGameId(gameId);
            rebateUseRecord.setServerId(serverId);
            rebateUseRecord.setRoleId(roleId);
            rebateUseRecord.setUseRecordNo(OrderNoUtil.getOrderNo());
            rebateUseRecord.setUserId(userId);
            rebateUseRecord.setUseMoney(useMoneyTemp);
            rebateUseRecord.setRoleName(roleName);
            String serverName = this.getServerName(gameId, serverId);
            if (serverName.equals("")) {
                logger.error("\u53d6\u4e0d\u5230\u5206\u533a\u4fe1\u606f\uff1agameId:" + gameId + ",serverid=" + serverId);
            }
            rebateUseRecord.setServerName(serverName);
            if (("000001".equals(gameId) || "000004".equals(gameId)) && rebateUseRecord.getUseMoney() < 10) {
                return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u6e38\u620f[" + gameId + "]\u91d1\u989d\u975e\u6cd5", null);
            }
            rebateUseRecord.setUseMoney(rebateUseRecord.getUseMoney());
            FacadeFactory.INSTANCE.getUserRebateBo().addRebateUseRecord(rebateUseRecord, rebateNoArray);
            rebateUseRecord = this.giveOutGameYuanBao(rebateUseRecord);
            if ("S".equals(rebateUseRecord.getUseStatus())) {
                CustomerInfo customer;
                CustomerInfo info = new CustomerInfo();
                info.setUid(userId);
                List<CustomerInfo> infolist = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getCustomerInfoBo().find(info, new Page());
                if (infolist != null && infolist.size() > 0 && (customer = infolist.get(0)) != null && !StringTools.isEmpty(customer.getPhone())) {
                    Games games = new Games();
                    games.setGameId(gameId);
                    List<Games> gamelist = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getGamesBo().findGames(games, new Page());
                    if (gamelist == null || gamelist.size() == 0) {
                        return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u8be5\u6e38\u620f\u4e0d\u5b58\u5728", null);
                    }
                    Games game = gamelist.get(0);
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("\u5c0a\u8d35\u7684\u91d1\u5361\u7528\u6237\uff0c\u60a8\u597d\uff1a\u60a8\u4e8e").append(UserRebateCmd.now()).append("\u5728\u725bx\u5e73\u53f0\u91d1\u5361\u4e13\u533a\u6210\u529f\u63d0\u53d6\u8fd4\u5229\uff1a").append(rebateUseRecord.getUseMoney()).append("\u5143\uff0c\u8fd4\u5229\u4f7f\u7528\u6e38\u620f\uff1a").append(game.getGameName());
                    SmsClient.sendSms(customer.getPhone(), buffer.toString());
                }
                return JsonObjectUtil.getRtnAndDataJsonObject(0, "success", null);
            }
            FacadeFactory.INSTANCE.getUserRebateBo().updateFailUseRecord(rebateUseRecord.getUserId(), rebateUseRecord.getUseRecordNo());
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u53d1\u653e\u5931\u8d25", null);
        }
        catch (Exception e) {
            logger.error("\u7528\u6237[" + userId + "]\u4f7f\u7528\u8fd4\u5229[" + rebateNos + "]\u51fa\u73b0\u5f02\u5e38", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u4f7f\u7528\u5931\u8d25", null);
        }
    }

    private UserRebateUseRecord giveOutGameYuanBao(UserRebateUseRecord useRecord) {
        useRecord = FacadeFactory.INSTANCE.getUserRebateBo().updateRebateUseRecordTimestamp(useRecord.getUseRecordNo());
        String userName = UserUtility.getUserNameByUserId(useRecord.getUserId());
        int userMoney = useRecord.getUseMoney();
        if ("000001".equals(useRecord.getGameId()) || "000004".equals(useRecord.getGameId())) {
            userMoney = userMoney / 10 * 10;
        }
        try {
            YuanBaoClient.giveOutYuanBao(userName, useRecord.getGameId(), useRecord.getServerId(), useRecord.getUseRecordNo(), "VipUser", userMoney, useRecord.getRoleId());
            useRecord.setUseStatus("S");
        }
        catch (Exception e) {
            logger.error("\u8fd4\u5229\u4f7f\u7528\u8bb0\u5f55[" + useRecord.getUseRecordNo() + "]\u53d1\u653e\u6e38\u620f\u5e01\u51fa\u73b0\u5f02\u5e38", e);
            useRecord.setUseStatus("F");
        }
        FacadeFactory.INSTANCE.getBaseBo().updateObjectById(useRecord);
        return useRecord;
    }

    private int calRebateUseMoney(String[] rebateNoArray, String userId) {
        int useMoneyTemp = 0;
        for (String rebateNo : rebateNoArray) {
            if (rebateNo == null || "".equals(rebateNo)) continue;
            UserRebateRecord rebateRecord = FacadeFactory.INSTANCE.getBaseBo().findById(UserRebateRecord.class, rebateNo);
            if (rebateRecord == null) {
                throw new RuntimeException("\u8fd4\u5229\u5355\u53f7[" + rebateNo + "]\u4e0d\u5b58\u5728");
            }
            if (!userId.equals(rebateRecord.getUserId())) {
                throw new RuntimeException("\u8fd4\u5229\u5355\u53f7[" + rebateNo + "]\u975e\u6cd5");
            }
            if (!"WAITUSE".equals(rebateRecord.getRebateStatus())) {
                throw new RuntimeException("\u8fd4\u5229\u5355\u53f7[" + rebateNo + "]\u4e0d\u80fd\u4f7f\u7528");
            }
            String date = sdfDate.format(new Date());
            if (date.compareTo(rebateRecord.getExpireDate()) > 0) {
                throw new RuntimeException("\u8fd4\u5229\u5355\u53f7[" + rebateNo + "]\u5df2\u8fc7\u671f");
            }
            useMoneyTemp += rebateRecord.getRebateMoney().intValue();
        }
        return useMoneyTemp;
    }

    @CmdMapper(value={"/rebate/getrebaterecords.do"})
    public Object getRebateRecords(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        int pageNo = request.getParameterInteger("pageNo", 1);
        int pageSize = request.getParameterInteger("pageSize", 10);
        String rebateStatus = request.getParameter("rebateStatus", "");
        UserRebateRecord queryRebateRecord = new UserRebateRecord();
        queryRebateRecord.setUserId(userId);
        String date = sdfDate.format(new Date());
        if ("EXPIRED".equals(rebateStatus)) {
            queryRebateRecord.setRebateStatus("WAITUSE");
            queryRebateRecord.setLeExpireDate(date);
        } else if ("WAITUSE".equals(rebateStatus)) {
            queryRebateRecord.setRebateStatus("WAITUSE");
            queryRebateRecord.setGeExpireDate(date);
        } else {
            queryRebateRecord.setRebateStatus(rebateStatus);
        }
        queryRebateRecord.setGtRebateMoney(0);
        Page page = new Page();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        page.addOrder("recordTime", OrderType.DESC);
        int count = FacadeFactory.INSTANCE.getBaseBo().countObject(queryRebateRecord);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("count", count);
        if (count > 0) {
            List<UserRebateRecord> list = FacadeFactory.INSTANCE.getBaseBo().findObjects(queryRebateRecord, page);
            for (UserRebateRecord record : list) {
                if (!"WAITUSE".equals(record.getRebateStatus()) || record.getExpireDate().compareToIgnoreCase(date) >= 0) continue;
                record.setRebateStatus("EXPIRED");
            }
            resultMap.put("records", list);
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    @CmdMapper(value={"/rebate/getrebateuserecords.do"})
    public Object getUserRebateUseRecord(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        int pageNo = request.getParameterInteger("pageNo", 1);
        int pageSize = request.getParameterInteger("pageSize", 10);
        UserRebateUseRecord queryRebateUseRecord = new UserRebateUseRecord();
        queryRebateUseRecord.setUserId(userId);
        Page page = new Page();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        page.addOrder("useTime", OrderType.DESC);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int count = FacadeFactory.INSTANCE.getBaseBo().countObject(queryRebateUseRecord);
        resultMap.put("count", count);
        if (count > 0) {
            resultMap.put("records", FacadeFactory.INSTANCE.getBaseBo().findObjects(queryRebateUseRecord, page));
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    @CmdMapper(value={"/rebate/getrebateinfo.do"})
    public Object getUserRebateInfo(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        UserRebateInfo rebateInfo = this.getUserRebateInfo(mainParam.getUserid());
        if (rebateInfo == null) {
            rebateInfo = new UserRebateInfo();
            rebateInfo.setCanUseRebateSum(0);
            rebateInfo.setExpiredRebateSum(0);
            rebateInfo.setLatestRebateSum(0);
            rebateInfo.setRebateSum(0);
            rebateInfo.setUsedRebateSum(0);
            rebateInfo.setUserId(String.valueOf(mainParam.getUserid()));
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, rebateInfo);
    }

    private UserRebateInfo getUserRebateInfo(long userId) {
        String date = sdfDate.format(new Date());
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -7);
        Date latestDate = calendar.getTime();
        UserRebateRecord queryRebateRecord = new UserRebateRecord();
        queryRebateRecord.setUserId(String.valueOf(userId));
        List<UserRebateRecord> rebateList = FacadeFactory.INSTANCE.getBaseBo().findObjects(queryRebateRecord, new Page());
        if (CollectionUtils.isEmpty(rebateList)) {
            return null;
        }
        int rebateSum = 0;
        int canUseRebateSum = 0;
        int expiredRebateSum = 0;
        int usedRebateSum = 0;
        int latestRebateSum = 0;
        for (UserRebateRecord rebateRecord : rebateList) {
            Date recordDate;
            if ("NOREBATE".equals(rebateRecord.getRebateStatus())) continue;
            try {
                recordDate = sdf_time.parse(rebateRecord.getRecordTime());
            }
            catch (ParseException e) {
                logger.error("getUserRebateInfo ParseException", e);
                continue;
            }
            rebateSum += rebateRecord.getRebateMoney().intValue();
            if (recordDate.after(latestDate)) {
                latestRebateSum += rebateRecord.getRebateMoney().intValue();
            }
            if ("WAITUSE".equals(rebateRecord.getRebateStatus())) {
                if (rebateRecord.getExpireDate().compareToIgnoreCase(date) >= 0) {
                    canUseRebateSum += rebateRecord.getRebateMoney().intValue();
                    continue;
                }
                expiredRebateSum += rebateRecord.getRebateMoney().intValue();
                continue;
            }
            if (!"USED".equals(rebateRecord.getRebateStatus())) continue;
            usedRebateSum += rebateRecord.getRebateMoney().intValue();
        }
        UserRebateInfo userRebateInfo = new UserRebateInfo();
        userRebateInfo.setUserId(String.valueOf(userId));
        userRebateInfo.setRebateSum(rebateSum);
        userRebateInfo.setCanUseRebateSum(canUseRebateSum);
        userRebateInfo.setExpiredRebateSum(expiredRebateSum);
        userRebateInfo.setUsedRebateSum(usedRebateSum);
        userRebateInfo.setLatestRebateSum(latestRebateSum);
        return userRebateInfo;
    }

    private void checkGiftGameInfoValid(String gameId, String serverId, String roleId) throws NiuExceptionAndCode {
        boolean isNeedSelectRole;
        if ("".equals(gameId)) {
            throw new NiuExceptionAndCode("2004", "\u6e38\u620f\u4e3a\u7a7a");
        }
        GamePayInfo query = new GamePayInfo();
        query.setGameid(gameId);
        GamePayInfo getGamePayInfo = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        boolean isNeedSelectServer = getGamePayInfo == null || getGamePayInfo.getFormType().contains("s");
        boolean bl = isNeedSelectRole = getGamePayInfo == null || getGamePayInfo.getFormType().contains("r");
        if (isNeedSelectServer && "".equals(serverId)) {
            throw new NiuExceptionAndCode("2005", "\u533a\u670d\u4e3a\u7a7a");
        }
        if (isNeedSelectRole && "".equals(roleId)) {
            throw new NiuExceptionAndCode("2006", "\u89d2\u8272\u4e3a\u7a7a");
        }
    }

    private String getFenQuName(String gameId, String serverId) {
        if (serverId == null || "".equals(serverId) || gameId == null || "".equals(gameId)) {
            throw new NullPointerException("gameId or serverId is null");
        }
        GameServers queryGameServes = new GameServers();
        queryGameServes.setGameId(gameId);
        queryGameServes.setServerId(serverId);
        GameServers gs = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObject(queryGameServes);
        if (gs == null) {
            return "";
        }
        return gs.getFenQuName();
    }

    private static String getClientIp(XLHttpRequest request) {
        String clientIp = request.getHeader("X-Real-IP");
        if (clientIp == null || "".equals(clientIp)) {
            clientIp = request.getRemoteIP();
        }
        return clientIp;
    }

    @CmdMapper(value={"/rebate/rebackusedrebate.do"})
    public Object rebackUsedRebate(XLHttpRequest request, XLHttpResponse response) {
        String userId = request.getParameter("userId");
        String useRecordNo = request.getParameter("useRecordNo");
        try {
            FacadeFactory.INSTANCE.getUserRebateBo().updateFailUseRecord(userId, useRecordNo);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u6210\u529f", null);
        }
        catch (Exception e) {
            logger.error("userId[" + userId + "]useRecordNo[" + useRecordNo + "]reback user record exception", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, e.getMessage(), null);
        }
    }
}

