/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.prop;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.RetData;
import com.xunlei.niux.center.util.Utility;
import com.xunlei.niux.data.pay.vo.PayDetailOK;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerInfo;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.MarketProduct;
import com.xunlei.niux.data.vipgame.vo.vip.PropOrder;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class PropCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(PropCmd.class);
    private static final Page page = new Page();

    @CmdMapper(value={"/prop/getorders.do"})
    public Object getMessages(XLHttpRequest request, XLHttpResponse response) {
        logger.info("\u5f00\u59cb\u9053\u5177\u5546\u57ce\u5145\u503c\u8bb0\u5f55\u67e5\u8be2");
        try {
            MainParam param = this.checkMainParam(request, response, true);
            String uid = param.getUserid() + "";
            String nowtime = PropCmd.now();
            String pagesizestr = request.getParameter("pagesize");
            String pagenostr = request.getParameter("pageno");
            int pageSize = 0;
            int pageNo = 0;
            if (pagesizestr == null || "".equals(pagesizestr)) {
                pageSize = 20;
            } else {
                pageSize = Integer.parseInt(pagesizestr);
                if (pageSize <= 0) {
                    pageSize = 1;
                }
            }
            if (pagenostr == null || "".equals(pagenostr)) {
                pageNo = 1;
            } else {
                pageNo = Integer.parseInt(pagenostr);
                if (pageNo <= 0) {
                    pageNo = 1;
                }
            }
            PropOrder order = new PropOrder();
            order.setUid(uid);
            order.setStatus(new Integer(1));
            Page page = new Page();
            page.setPageNo(pageNo);
            page.setPageSize(pageSize);
            page.addOrder("payTime", OrderType.DESC);
            List<PropOrder> cdqlist = FacadeFactory.INSTANCE.getBaseSo().findObjects(order, page);
            List<PropOrder> alllist = FacadeFactory.INSTANCE.getBaseSo().findObjects(order, new Page());
            int count = 0;
            if (alllist != null && alllist.size() > 0) {
                count = alllist.size();
            }
            double totalmoney = 0.0;
            for (PropOrder po : alllist) {
                totalmoney += po.getPayMoney().doubleValue();
            }
            ArrayList resultlist = new ArrayList();
            if (cdqlist != null) {
                int i = 1;
                for (PropOrder po : cdqlist) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("index", i);
                    map.put("payTime", po.getPayTime());
                    map.put("propMoney", po.getPropMoney());
                    map.put("propid", po.getPropId());
                    map.put("propName", po.getPropName());
                    map.put("status", po.getIsNotice() == 0 ? "\u672a\u53d1\u653e" : "\u5df2\u53d1\u653e");
                    map.put("gameId", po.getGameId());
                    map.put("gameName", po.getGameId());
                    resultlist.add(map);
                    ++i;
                }
            }
            HashMap<String, Object> backdata = new HashMap<String, Object>();
            backdata.put("messageList", resultlist);
            backdata.put("totalcount", count);
            backdata.put("nowtime", nowtime);
            backdata.put("totalmoney", totalmoney);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, backdata);
        }
        catch (Exception e) {
            logger.info("\u9053\u5177\u5546\u57ce\u5145\u503c\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage());
            e.printStackTrace();
            RetData data = new RetData();
            data.setErrmsg("\u5185\u90e8\u9519\u8bef");
            return JsonObjectUtil.getRtnAndDataJsonObject(1, data);
        }
    }

    @CmdMapper(value={"/prop/getqq.do"})
    public Object getQq(XLHttpRequest request, XLHttpResponse response) {
        logger.info("\u5f00\u59cb\u9053\u5177\u5546\u57ce\u7ed1\u5b9aQQ\u67e5\u8be2");
        MainParam param = this.checkMainParam(request, response, true);
        String uid = param.getUserid() + "";
        PropOrder order = new PropOrder();
        order.setUid(uid);
        order.setStatus(new Integer(1));
        Page page = new Page();
        page.addOrder("payTime", OrderType.DESC);
        List<PropOrder> polist = FacadeFactory.INSTANCE.getBaseSo().findObjects(order, page);
        HashMap<String, String> data = new HashMap<String, String>();
        if (polist == null || polist.size() == 0) {
            CustomerInfo info = new CustomerInfo();
            info.setUid(uid);
            List<CustomerInfo> cilist = FacadeFactory.INSTANCE.getBaseSo().findObjects(info, new Page());
            if (cilist == null || cilist.size() == 0) {
                data.put("qq", "");
                return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
            }
            for (CustomerInfo ci : cilist) {
                if (ci.getQq() == null || "".equals(ci.getQq())) continue;
                data.put("qq", ci.getQq());
                return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
            }
        } else {
            PropOrder po = polist.get(0);
            data.put("qq", po.getQq());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u7f51\u7edc\u5f02\u5e38");
    }

    @CmdMapper(value={"/prop/getprop.do"})
    public Object getProp(XLHttpRequest request, XLHttpResponse response) {
        logger.info("\u5f00\u59cb\u7d2f\u8ba1\u652f\u4ed8\u9886\u53d6\u9053\u5177");
        String propid = request.getParameter("propid");
        String qq = request.getParameter("qq");
        String uid = request.getCookieValue("userid");
        logger.info("prop/getprop.do start uid=" + uid + ",propid=" + propid + ",qq=" + qq);
        try {
            MainParam param = this.checkMainParam(request, response, true);
            if (StringTools.isEmpty(propid) || StringTools.isEmpty(qq)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
            }
            String orderid = this.getOrderId();
            String cusrname = request.getCookieValue("usrname");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long seqid = Long.parseLong(propid);
            MarketProduct mproduct = new MarketProduct();
            mproduct.setSeqid(seqid);
            List<MarketProduct> mplist = FacadeFactory.INSTANCE.getMarketProductBo().findMarketProduct(mproduct, page);
            if (mplist == null || mplist.size() == 0) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u8be5\u9053\u5177\u4e0d\u5b58\u5728");
            }
            MarketProduct product = mplist.get(0);
            if (product == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u8be5\u9053\u5177\u4e0d\u5b58\u5728");
            }
            LinkInfo info = new LinkInfo();
            info.setGameidbytuijian(product.getGameId());
            info.setExt1("2");
            info.setLinklocid("610");
            List<LinkInfo> linklist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info, page);
            if (linklist == null || linklist.size() == 0) {
                return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u6ee1\u8db3\u7d2f\u8ba1\u5145\u503c\u6761\u4ef6\u624d\u80fd\u9886\u53d6\u8be5\u9053\u5177");
            }
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
            String secord = System.currentTimeMillis() / 1000L + "";
            String nowtime = sdf2.format(calendar.getTime());
            String begintime = nowtime + " 00:00:00";
            calendar.add(5, 1);
            String endtime = sdf2.format(calendar.getTime());
            PropOrder po = new PropOrder();
            po.setUid(uid);
            po.setFromPayTime(begintime);
            po.setToPayTime(endtime);
            Page page = new Page();
            page.addOrder("payTime", OrderType.DESC);
            List<PropOrder> polist = FacadeFactory.INSTANCE.getBaseSo().findObjects(po, page);
            if (polist != null && polist.size() > 0) {
                PropOrder porder = polist.get(0);
                String propkey = porder.getPropkey();
                String key = propkey.split("_")[1];
                if (Long.parseLong(secord) - Long.parseLong(key) <= 5L) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(6, "\u9886\u53d6\u592a\u9891\u7e41\u4e86");
                }
            }
            double money = product.getMoney();
            double totalmoney = this.getPayTotal(uid, product.getGameId(), begintime, endtime);
            if (totalmoney <= 0.0) {
                return JsonObjectUtil.getRtnAndDataJsonObject(5, "\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
            }
            double usedmoney = this.getUsedTotal(uid, begintime, endtime);
            double leftmoney = totalmoney - usedmoney;
            if (money > leftmoney) {
                return JsonObjectUtil.getRtnAndDataJsonObject(5, "\u53ef\u7528\u91d1\u989d\u4e0d\u8db3");
            }
            PropOrder order = new PropOrder();
            order.setOrderId(orderid);
            order.setPayTime(sdf.format(new Date()));
            order.setPayMoney(product.getMoney());
            order.setUserName(cusrname);
            order.setPropId(propid);
            order.setIsNotice(new Integer(0));
            order.setGameId(product.getGameId());
            order.setUid(uid);
            order.setStatus(new Integer(1));
            order.setPropName(product.getTitle());
            order.setPropMoney(product.getPrice());
            order.setQq(qq);
            order.setPropkey(uid + "_" + secord);
            FacadeFactory.INSTANCE.getBaseSo().addObject(order);
            logger.info("prop/getprop.do success uid=" + uid + ",propid=" + propid + ",qq=" + qq);
            return JsonObjectUtil.getOnlyOkJson();
        }
        catch (NumberFormatException e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
        }
        catch (Exception e) {
            logger.info("prop/getprop.do exception uid=" + uid + ",propid=" + propid + ",qq=" + qq);
            return JsonObjectUtil.getRtnAndDataJsonObject(6, "\u9886\u53d6\u592a\u9891\u7e41\u4e86");
        }
    }

    private double getUsedTotal(String uid, String begintime, String endtime) {
        PropOrder order = new PropOrder();
        order.setUid(uid);
        order.setFromPayTime(begintime);
        order.setToPayTime(endtime);
        List<PropOrder> polist = FacadeFactory.INSTANCE.getBaseSo().findObjects(order, page);
        if (polist == null || polist.size() == 0) {
            return 0.0;
        }
        double totalmoney = 0.0;
        for (PropOrder po : polist) {
            totalmoney += po.getPayMoney().doubleValue();
        }
        return totalmoney;
    }

    private double getPayTotal(String uid, String gameid, String begintime, String endtime) {
        if (gameid != null && gameid.length() == 6) {
            gameid = gameid.substring(1);
        }
        PayDetailOK payDetailOk = new PayDetailOK();
        payDetailOk.setToinneruserid(uid);
        payDetailOk.setGiftFlag("0");
        payDetailOk.setGameid(gameid);
        payDetailOk.setNiuxactno("niuxzfzx");
        payDetailOk.setFromOrderTime(begintime);
        payDetailOk.setToOrderTime(endtime);
        List<PayDetailOK> pdolist = com.xunlei.niux.data.pay.facade.FacadeFactory.INSTANCE.getPayDetailOkBo().findPayDetailOk(payDetailOk, page);
        if (pdolist == null || pdolist.size() == 0) {
            return 0.0;
        }
        double paytotal = 0.0;
        for (PayDetailOK pdo : pdolist) {
            paytotal += pdo.getPayMondey().doubleValue();
        }
        return paytotal;
    }

    private String getOrderId() {
        return "P" + Utility.createApplyId();
    }

    @CmdMapper(value={"/prop/getmoney.do"})
    public Object getMoney(XLHttpRequest request, XLHttpResponse response) {
        try {
            logger.info("\u5f00\u59cb\u73a9\u5bb6\u5f53\u65e5\u7d2f\u8ba1\u5145\u503c\u91d1\u989d\u67e5\u8be2");
            String propid = request.getParameter("propid");
            MainParam param = this.checkMainParam(request, response, true);
            String uid = param.getUserid() + "";
            if (StringTools.isEmpty(propid)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u53c2\u6570\u9519\u8bef");
            }
            MarketProduct product = new MarketProduct();
            product.setSeqid(Long.parseLong(propid));
            MarketProduct mp = FacadeFactory.INSTANCE.getBaseSo().findObject(product);
            if (mp == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u8be5\u9053\u5177\u4e0d\u5b58\u5728");
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
            String nowtime = sdf2.format(calendar.getTime());
            String begintime = nowtime + " 00:00:00";
            calendar.add(5, 1);
            String endtime = sdf2.format(calendar.getTime());
            logger.info("mp:" + mp.getSeqid());
            double totalmoney = this.getPayTotal(uid, mp.getGameId(), begintime, endtime);
            logger.info("totalmoney:" + totalmoney);
            double usedmoney = this.getUsedTotal(uid, begintime, endtime);
            logger.info("usedmoney:" + usedmoney);
            long money = mp.getMoney() == null ? 0L : mp.getMoney().longValue();
            result.put("totalMoney", totalmoney);
            result.put("usedMoney", usedmoney);
            result.put("propMoney", money);
            if (totalmoney <= 0.0) {
                result.put("flag", "0");
                result.put("payMoney", money);
                return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
            }
            if (totalmoney - usedmoney - (double)money >= 0.0) {
                result.put("flag", "1");
            } else {
                result.put("flag", "0");
                result.put("payMoney", -(totalmoney - usedmoney - (double)money));
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.error("/prop/getmoney exception reason:" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    private MainParam checkMainParam(XLHttpRequest request, XLHttpResponse response, boolean isSeccode) {
        try {
            return this.getMainParam(request, response, isSeccode);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

