/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.product;

import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.util.RBundleUtil;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.ActivityExchangeProduct;
import com.xunlei.niux.data.vipgame.vo.ActivityExchangeRecord;
import com.xunlei.util.Log;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ActivityProductCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(ActivityProductCmd.class);
    private static String validips = null;

    @CmdMapper(value={"/product/updata.do"})
    public Object updateCardCount(XLHttpRequest request, XLHttpResponse response) {
        logger.info("\u5f00\u59cb\u8c03\u7528\u6d3b\u52a8\u9875\u5956\u54c1\u5151\u6362\u6570\u636e\u4e0a\u62a5\u63a5\u53e3");
        String uid = request.getParameter("uid");
        String actNo = request.getParameter("actNo");
        String actUrl = request.getParameter("actUrl");
        String productId = request.getParameter("productId");
        String ip = request.getParameter("ip");
        String amountStr = request.getParameter("amount");
        String typeStr = request.getParameter("type");
        String realValue = request.getParameter("realValue");
        logger.info("product.update.do uid=" + uid + ",actNo" + actNo + ",amount=" + amountStr + ",productId" + productId + ",type=" + typeStr + ",realValue=" + realValue);
        String validip = request.getRemoteIP();
        if (validips.indexOf(validip) == -1) {
            logger.info("product.update.do uid=" + uid + ",validip=" + validip + " \u975e\u6cd5\u8c03\u7528");
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u975e\u6cd5\u8c03\u7528");
        }
        if (StringUtil.isEmpty(uid) || StringUtil.isEmpty(actNo) || StringUtil.isEmpty(actUrl) || StringUtil.isEmpty(productId) || StringUtil.isEmpty(ip) || StringUtil.isEmpty(amountStr) || StringUtil.isEmpty(typeStr) || StringUtil.isEmpty(realValue)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
        }
        int type = 0;
        long amount = 0L;
        try {
            type = Integer.parseInt(typeStr);
            amount = Long.parseLong(amountStr);
        }
        catch (Exception e) {
            logger.info("product.update.do uid=" + uid + ",reason1=" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u53c2\u6570\u9519\u8bef");
        }
        if (amount <= 0L || type <= 0) {
            logger.info("product.update.do uid=" + uid + ",amount  or type is zero");
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u53c2\u6570\u9519\u8bef");
        }
        ActivityExchangeProduct product = new ActivityExchangeProduct();
        product.setActNo(actNo);
        product.setProductId(productId);
        List<ActivityExchangeProduct> list = FacadeFactory.INSTANCE.getActivityExchangeProductBo().findActivityExchangeProduct(product, new Page());
        if (list == null || list.size() == 0) {
            logger.info("product.update.do uid=" + uid + ",actNo=" + actNo + ",productId=" + productId + ",product not found");
            return JsonObjectUtil.getRtnAndDataJsonObject(5, "\u8be5\u6d3b\u52a8\u7684\u5956\u54c1\u4e0d\u5b58\u5728");
        }
        try {
            ActivityExchangeRecord record = new ActivityExchangeRecord();
            record.setActNo(actNo);
            actUrl = URLDecoder.decode(actUrl, "utf8");
            record.setActUrl(actUrl);
            record.setProductId(productId);
            record.setUid(uid);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String time = sdf.format(new Date());
            record.setTime(time);
            record.setIp(ip);
            record.setType(type + "");
            record.setRealValue(realValue);
            record.setCount(amount);
            record.setUsername("");
            FacadeFactory.INSTANCE.getActivityExchangeRecordBo().insert(record);
            logger.info("product.update.do uid=" + uid + ",updata success");
            return JsonObjectUtil.getOnlyOkJson();
        }
        catch (Exception e) {
            logger.info("product.update.do uid=" + uid + ",reason2=" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u7cfb\u7edf\u5f02\u5e38");
        }
    }

    private MainParam checkMainParam(XLHttpRequest request, XLHttpResponse response, boolean isSeccode) {
        try {
            return this.getMainParam(request, response, isSeccode);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static {
        if (validips == null) {
            validips = RBundleUtil.getString("niux", "validips");
        }
    }
}

