/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.prize;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.thirdclient.vip.VipClient;
import com.xunlei.niux.center.thirdclient.vip.vo.PrizeResponse;
import com.xunlei.niux.data.manager.facade.FacadeFactory;
import com.xunlei.niux.data.manager.vo.Activity;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class GetUserPrizeList
extends DefaultCmd {
    private static final Logger logger = Log.getLogger(GetUserPrizeList.class.getName());
    private static final String jinkuuseurl = EnvPropertyUtil.loadProperty("VipClient", "jinkuuseurl");
    private static final String jinkuimgurl = EnvPropertyUtil.loadProperty("VipClient", "jinkuimgurl");

    @CmdMapper(value={"/getUserPrizeList.do"})
    public Object getUserPriz(XLHttpRequest request, XLHttpResponse response) {
        try {
            this.setInnerContentType(request, response);
            MainParam mainParam = this.getMainParam(request, response, true);
            long userid = mainParam.getUserid();
            int pageNo = request.getParameterInteger("pageno");
            int pageSize = request.getParameterInteger("pagesize");
            PrizeResponse pr = VipClient.getPrize(userid, pageNo, pageSize);
            RetData data = new RetData();
            int count = pr.getCount();
            if (count <= 0) {
                logger.info("userid:" + userid + ",pageno:" + pageNo + "\u4e2d\u5956\u4fe1\u5fc3\u4e3a0");
                return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
            }
            int totalpage = count / pageSize;
            if (count % pageSize > 0) {
                ++totalpage;
            }
            ArrayList<Map<String, String>> mList = new ArrayList<Map<String, String>>();
            List<PrizeResponse.Prize> list = pr.getPrizes();
            for (PrizeResponse.Prize p : list) {
                HashMap<String, String> m = new HashMap<String, String>();
                String uselink = jinkuuseurl + "/jinkutool/douse/" + p.getFid() + "/1?callback=callback";
                String piclink = jinkuimgurl + "/img/jinku/" + p.getFpic();
                m.put("prizepic", piclink);
                m.put("prizename", p.getFtitle());
                m.put("usedate", p.getFexpire().substring(0, 10));
                m.put("isuse", "0");
                m.put("uselink", uselink);
                PagedFliper pf = new PagedFliper();
                Activity activity = new Activity();
                activity.setPrizeNo(p.getFact());
                Sheet<Activity> sheet = FacadeFactory.INSTANCE.getActivityBo().queryActivities(activity, pf);
                if (sheet != null && sheet.getDatas() != null && sheet.getDatas().size() > 0) {
                    List kalist = (List)sheet.getDatas();
                    Activity kqc = (Activity)kalist.get(0);
                    m.put("actlink", kqc.getLinkPath());
                    m.put("prizefrom", kqc.getActName());
                } else {
                    m.put("actlink", "");
                    m.put("prizefrom", "");
                }
                mList.add(m);
            }
            data.setTotalpage(totalpage);
            data.setData(mList);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
        }
        catch (Exception e) {
            logger.info("\u67e5\u8be2\u4e2d\u5956\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", e);
            RetData retData = new RetData();
            retData.setErrmsg(e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(1, retData);
        }
    }

    @CmdMapper(value={"/getUserPrizeListByServer.do"})
    public Object getUserPrizeByServer(XLHttpRequest request, XLHttpResponse response) {
        try {
            this.setInnerContentType(request, response);
            long userid = request.getParameterLong("userid");
            int pageNo = request.getParameterInteger("pageno");
            int pageSize = request.getParameterInteger("pagesize");
            PrizeResponse pr = VipClient.getPrize(userid, pageNo, pageSize);
            RetData data = new RetData();
            int count = pr.getCount();
            if (count <= 0) {
                logger.info("userid:" + userid + ",pageno:" + pageNo + "\u4e2d\u5956\u4fe1\u5fc3\u4e3a0");
                return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
            }
            int totalpage = count / pageSize;
            if (count % pageSize > 0) {
                ++totalpage;
            }
            ArrayList<Map<String, String>> mList = new ArrayList<Map<String, String>>();
            List<PrizeResponse.Prize> list = pr.getPrizes();
            for (PrizeResponse.Prize p : list) {
                HashMap<String, String> m = new HashMap<String, String>();
                String uselink = jinkuuseurl + "/jinkutool/douse/" + p.getFid() + "/1?callback=callback";
                String piclink = jinkuimgurl + "/img/jinku/" + p.getFpic();
                m.put("prizepic", piclink);
                m.put("prizename", p.getFtitle());
                m.put("usedate", p.getFexpire().substring(0, 10));
                m.put("isuse", "0");
                m.put("uselink", uselink);
                PagedFliper pf = new PagedFliper();
                Activity activity = new Activity();
                activity.setPrizeNo(p.getFact());
                Sheet<Activity> sheet = FacadeFactory.INSTANCE.getActivityBo().queryActivities(activity, pf);
                if (sheet != null && sheet.getDatas() != null && sheet.getDatas().size() > 0) {
                    List kalist = (List)sheet.getDatas();
                    Activity kqc = (Activity)kalist.get(0);
                    m.put("actlink", kqc.getLinkPath());
                    m.put("prizefrom", kqc.getActName());
                } else {
                    m.put("actlink", "");
                    m.put("prizefrom", "");
                }
                mList.add(m);
            }
            data.setTotalpage(totalpage);
            data.setData(mList);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
        }
        catch (Exception e) {
            logger.info("\u67e5\u8be2\u4e2d\u5956\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", e);
            RetData retData = new RetData();
            retData.setErrmsg(e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(1, retData);
        }
    }

    public static class RetData {
        private String errmsg = "";
        private int totalpage = 0;
        private List<Map<String, String>> data = new ArrayList<Map<String, String>>();

        public String getErrmsg() {
            return this.errmsg;
        }

        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }

        public int getTotalpage() {
            return this.totalpage;
        }

        public void setTotalpage(int totalpage) {
            this.totalpage = totalpage;
        }

        public List<Map<String, String>> getData() {
            return this.data;
        }

        public void setData(List<Map<String, String>> data) {
            this.data = data;
        }
    }
}

