/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.pay;

import com.ferret.common.dao.vo.Page;
import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.common.util.StringTools;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.so.pay.PayResponse;
import com.xunlei.niux.center.util.Utility;
import com.xunlei.niux.data.vip.bo.UserVipBo;
import com.xunlei.niux.data.vip.facade.FacadeFactory;
import com.xunlei.niux.data.vip.vo.UserVip;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.vo.CustomerGrade;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.MarketProduct;
import com.xunlei.niux.data.vipgame.vo.vip.PropOrder;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class PropPayCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(PropPayCmd.class.getName());
    private static final String PAY_URL = "http://paysvr.niu.xunlei.com:8090/gamepaycenter/pay";
    private static final String KEY = EnvPropertyUtil.loadProperty("niux", "propkey");
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final int VIP_GRADE = 3;

    @CmdMapper(value={"/pay/buyprop.do"})
    public Object buyProp(XLHttpRequest request, XLHttpResponse response) {
        String clientIp = request.getRemoteIP();
        MainParam mainParam = null;
        try {
            mainParam = this.getMainParam(request, response, true);
        }
        catch (Exception e) {
            logger.error("ip[" + clientIp + "]\u8bf7\u6c42/pay/buyprop.do\u7684session\u9a8c\u8bc1\u5931\u8d25", e);
        }
        if (mainParam == null) {
            PayResponse payResponse = new PayResponse();
            payResponse.setCode("99");
            payResponse.setMsg("session\u9a8c\u8bc1\u5931\u8d25");
            return JsonObjectUtil.getRtnAndDataJsonObject(2, payResponse);
        }
        String propid = request.getParameter("propid");
        String username = request.getParameter("getUsername");
        String gameid = request.getParameter("gameid");
        String serverid = request.getParameter("serverid");
        String chargeType = request.getParameter("chargeType");
        String paybiz = request.getParameter("paybiz");
        String unitPrice = request.getParameter("unitPrice");
        String goodstimes = request.getParameter("goodstimes");
        String cookieprefix = request.getParameter("cookieprefix");
        String qq = request.getParameter("qq");
        response.setInnerContentType(XLHttpResponse.ContentType.html);
        String uri = request.getUri();
        logger.info("proppay.do  gameid:" + gameid + ",username:" + username + ",propid:" + propid + ",ip=" + clientIp + ", url=" + uri);
        if (StringTools.isEmpty(propid) || StringTools.isEmpty(username) || StringTools.isEmpty(gameid) || StringTools.isEmpty(serverid) || StringTools.isEmpty(chargeType) || StringTools.isEmpty(paybiz) || StringTools.isEmpty(unitPrice) || StringTools.isEmpty(goodstimes) || StringTools.isEmpty(cookieprefix) || StringTools.isEmpty(qq)) {
            PayResponse payResponse = new PayResponse();
            payResponse.setCode("1");
            payResponse.setMsg("\u53c2\u6570\u9519\u8bef");
            logger.info("proppay.do  gameid:" + gameid + ",username:" + username + ",propid:" + propid + ", msg=param empty");
            return this.getReturn(payResponse, chargeType);
        }
        if (!("B".equals(chargeType) || "A1".equals(chargeType) || "E".equals(chargeType))) {
            return "var defaultRtnName = {code:\"\", msg:\"\u8be5\u652f\u4ed8\u65b9\u5f0f\u4e0d\u5b58\u5728\"}";
        }
        if (gameid.length() == 5) {
            gameid = "0" + gameid;
        }
        double paymoney = 0.0;
        try {
            double price = Double.parseDouble(unitPrice);
            int times = Integer.parseInt(goodstimes);
            if (price <= 0.0 || times <= 0) {
                PayResponse payResponse = new PayResponse();
                payResponse.setCode("1");
                payResponse.setMsg("\u53c2\u6570\u9519\u8bef");
                logger.info("proppay.do  gameid:" + gameid + ",username:" + username + ",propid:" + propid + ", msg=param empty");
                return this.getReturn(payResponse, chargeType);
            }
            paymoney = price * (double)times;
        }
        catch (Exception e) {
            PayResponse payResponse = new PayResponse();
            payResponse.setCode("1");
            payResponse.setMsg("\u53c2\u6570\u9519\u8bef");
            logger.info("proppay.do  gameid:" + gameid + ",username:" + username + ",propid:" + propid + ", msg=param empty");
            return this.getReturn(payResponse, chargeType);
        }
        String orderid = this.getOrderId();
        String uid = request.getCookieValue("userid");
        String cusrname = request.getCookieValue("usrname");
        String usernewno = request.getCookieValue("usernewno");
        boolean checkUserFlag = false;
        if (cusrname != null && username.trim().equals(cusrname)) {
            checkUserFlag = true;
        }
        if (usernewno != null && username.trim().equals(usernewno)) {
            checkUserFlag = true;
        }
        if (!checkUserFlag) {
            PayResponse payResponse = new PayResponse();
            payResponse.setCode("12");
            payResponse.setMsg("\u8bf7\u7528\u767b\u5f55\u8d26\u53f7\u652f\u4ed8");
            logger.info("proppay.do  gameid:" + gameid + ",username:" + username + ",propid:" + propid + ", msg=login username is not right");
            return this.getReturn(payResponse, chargeType);
        }
        UserVipBo userVipBo = FacadeFactory.INSTANCE.getUserVipBo();
        UserVip userVip = userVipBo.find(Long.parseLong(uid));
        if (userVip == null) {
            PayResponse payResponse = new PayResponse();
            payResponse.setCode("6");
            payResponse.setMsg("\u8be5\u7528\u6237\u975e\u91d1\u5361vip\u7528\u6237");
            logger.info("proppay.do  gameid:" + gameid + ",username:" + username + ",propid:" + propid + ", msg= the user is not vip");
            return this.getReturn(payResponse, chargeType);
        }
        int vipgrade = userVip.getVipLervelNum();
        if (vipgrade < 3) {
            PayResponse payResponse = new PayResponse();
            payResponse.setCode("10");
            payResponse.setMsg("\u8be5\u7528\u6237\u91d1\u5361vip\u7b49\u7ea7\u4e0d\u591f");
            logger.info("proppay.do  gameid:" + gameid + ",username:" + username + ",propid:" + propid + ", msg= the user is not vip");
            return this.getReturn(payResponse, chargeType);
        }
        Games games = new Games();
        games.setGameId(gameid);
        Games resultgames = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObject(games);
        if (resultgames == null) {
            PayResponse payResponse = new PayResponse();
            payResponse.setCode("4");
            payResponse.setMsg("\u5145\u503c\u6e38\u620f\u4e0d\u5b58\u5728");
            logger.info("proppay.do  gameid:" + gameid + ",username:" + username + ",propid:" + propid + ", msg=the game is not exist");
            return this.getReturn(payResponse, chargeType);
        }
        BaseSo baseSo = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo();
        Page page = new Page();
        CustomerGrade grade = new CustomerGrade();
        grade.setVipGrade(vipgrade);
        List<CustomerGrade> list = baseSo.findObjects(grade, page);
        if (list.size() == 0) {
            PayResponse payResponse = new PayResponse();
            payResponse.setCode("7");
            payResponse.setMsg("\u8be5\u7528\u6237\u7684vip\u7b49\u7ea7\u4e0d\u5b58\u5728");
            logger.info("proppay.do  gameid:" + gameid + ",username:" + username + ",propid:" + propid + ", msg=the customergrade is not exist");
            return this.getReturn(payResponse, chargeType);
        }
        MarketProduct product = new MarketProduct();
        product.setSeqid(Long.parseLong(propid));
        MarketProduct mp = baseSo.findObject(product);
        if (mp == null) {
            PayResponse payResponse = new PayResponse();
            payResponse.setCode("8");
            payResponse.setMsg("\u8be5\u9053\u5177\u4e0d\u5b58\u5728");
            logger.info("proppay.do  gameid:" + gameid + ",username:" + username + ",propid:" + propid + ", msg=the prop is not exist");
            return this.getReturn(payResponse, chargeType);
        }
        LinkInfo info = new LinkInfo();
        info.setGameidbytuijian(gameid);
        info.setExt1("1");
        info.setLinklocid("610");
        List<LinkInfo> linklist = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getLinkInfoBo().find(info, page);
        if (linklist == null || linklist.size() == 0) {
            PayResponse payResponse = new PayResponse();
            payResponse.setCode("10");
            payResponse.setMsg("\u6ee1\u8db3\u5355\u7b14\u5145\u503c\u6761\u4ef6\u624d\u80fd\u83b7\u5f97\u8be5\u9053\u5177");
            logger.info("proppay.do  gameid:" + gameid + ",username:" + username + ",propid:" + propid + ", msg=the prop is not exist");
            return this.getReturn(payResponse, chargeType);
        }
        double money = mp.getMoney();
        if (paymoney < money) {
            PayResponse payResponse = new PayResponse();
            payResponse.setCode("9");
            payResponse.setMsg("\u5145\u503c\u91d1\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u83b7\u5f97\u8be5\u9053\u5177");
            logger.info("proppay.do  gameid:" + gameid + ",username:" + username + ",propid:" + propid + ",paymoney=" + paymoney + ",price=" + money + ", msg=the paymoney is little");
            return this.getReturn(payResponse, chargeType);
        }
        PropOrder order = new PropOrder();
        order.setOrderId(orderid);
        order.setPayTime(sdf.format(new Date()));
        order.setPayMoney(mp.getMoney());
        order.setUserName(username);
        order.setPropId(propid);
        order.setIsNotice(new Integer(0));
        order.setGameId(gameid);
        order.setUid(uid);
        order.setStatus(new Integer(0));
        order.setPropName(mp.getTitle());
        order.setPropMoney(mp.getPrice());
        order.setQq(qq);
        String secord = System.currentTimeMillis() / 1000L + "";
        order.setPropkey(uid + "_" + secord);
        com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().addObject(order);
        if (uri.indexOf("?") != -1) {
            uri = uri.substring(uri.indexOf("?") + 1);
        }
        String url = "";
        url = PAY_URL.indexOf("?") != -1 ? "http://paysvr.niu.xunlei.com:8090/gamepaycenter/pay&" + uri + "&extparam=" + orderid : "http://paysvr.niu.xunlei.com:8090/gamepaycenter/pay?" + uri + "&extparam=" + orderid;
        logger.info("proppay.do  gameid:" + gameid + ",username:" + username + ",propid:" + propid + "payurl:" + url);
        response.redirect(url);
        return JsonObjectUtil.getOnlyOkJson();
    }

    public Object getReturn(PayResponse payResponse, String chargeType) {
        if ("B".equals(chargeType)) {
            return "<script type='text/javascript'>alert(\"" + payResponse.getMsg() + "\");window.close();</script>";
        }
        if ("A1".equals(chargeType)) {
            return "var defaultRtnName = {code:\"\",msg:\"" + payResponse.getMsg() + "\"}";
        }
        return "<script type='text/javascript'>alert(\"" + payResponse.getMsg() + "\");window.close();</script>";
    }

    @CmdMapper(value={"/pay/backprop.do"})
    public Object backProp(XLHttpRequest request, XLHttpResponse response) {
        String sign = request.getParameter("sign");
        String actno = request.getParameter("actno");
        String orderid = request.getParameter("orderid");
        String userid = request.getParameter("userid");
        String gameid = request.getParameter("gameid");
        String serverid = request.getParameter("serverid");
        String totalmoney = request.getParameter("totalmoney");
        String time = request.getParameter("time");
        String proporderid = request.getParameter("extparam");
        if (StringTools.isEmpty(orderid) || StringTools.isEmpty(actno) || StringTools.isEmpty(userid) || StringTools.isEmpty(gameid) || StringTools.isEmpty(serverid) || StringTools.isEmpty(totalmoney) || StringTools.isEmpty(time) || StringTools.isEmpty(proporderid) || StringTools.isEmpty(sign)) {
            return "{\"code\":2,\"msg\":\"\u53c2\u6570\u9519\u8bef\"}";
        }
        super.setInnerContentType(request, response);
        String params = actno + orderid + userid + gameid + serverid + totalmoney + time + KEY;
        String mysign = Md5Encrypt.md5(params).toLowerCase();
        logger.info("orderid:" + orderid + ",backprop.do param:" + params);
        logger.info("orderid:" + orderid + ",backprop.do mysign:" + mysign);
        if (!mysign.trim().equals(sign.trim())) {
            return "{\"code\":3,\"msg\":\"\u6570\u5b57\u7b7e\u540d\u9519\u8bef\"}";
        }
        if (proporderid != null && !"".equals(proporderid)) {
            PropOrder order = new PropOrder();
            order.setOrderId(proporderid);
            BaseSo baseSo = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo();
            List<PropOrder> polist = baseSo.findObjects(order, new Page());
            if (polist != null && polist.size() > 0) {
                PropOrder porder = polist.get(0);
                porder.setStatus(new Integer(1));
                baseSo.updateObjectById(porder);
                return "{\"code\":0,\"msg\":\"\u6210\u529f\"}";
            }
        }
        return "{\"code\":1,\"msg\":\"\u7f51\u7edc\u5f02\u5e38\"}";
    }

    private String getOrderId() {
        return "P" + Utility.createApplyId();
    }
}

